# Руководство OpenComputers

OpenComputers - мод, который добавляет модульные и настраиваемые [компьютеры](general/computer.md), [серверы](item/server1.md), [роботов](block/robot.md) и [дронов](item/drone.md) в игру, сохраняющие свое состояние. Все устройства могут быть запрограммированы на языке Lua 5.2 или 5.3, что позволяет создавать системы различной сложности.

Чтобы понять, как использовать руководство, прочитайте [эту страницу](item/manual.md) (этот зеленый текст - ссылка, кликните на него).

## Содержание

### Устройства

- [Компьютеры](general/computer.md)
- [Серверы](item/server1.md)
- [Микроконтроллеры](block/microcontroller.md)
- [Роботы](block/robot.md)
- [Дроны](item/drone.md)

### Программы и программирование
- [OpenOS](general/openOS.md)
- [Lua](general/lua.md)

### Блоки и предметы
- [Предметы](item/index.md)
- [Блоки](block/index.md)

### Обучение
- [С чего начать?](general/quickstart.md)

## Обзор

Как упоминалось выше, компьютеры в OpenComputers сохраняют свое состояние, даже если чанк был отгружен. Это означает, что если игрок отошел от [компьютера](general/computer.md) или вышел из игры, то [компьютер](general/computer.md) запомнит свое последнее состояние и продолжит работу, когда игрок снова окажется около [компьютера](general/computer.md). Так работают все блоки, за исключением [планшетов](item/tablet.md).

Все устройства модульные и могут быть собраны с большим количеством различных компонентов, как и [компьютеры](general/computer.md) в реальной жизни. Игроки, которые любят что-либо мастерить, могут собрать себе робота таким, каким хотят. Если потребуется, устройства могут быть [разобраны](block/disassembler.md) и пересобраны. В [компьютерах](general/computer.md) и [серверах](item/server1.md) компоненты могут быть заменены с помощью графического интерфейса.

Устройства OpenComputers совместимы со множеством других модов, что позволяет манипулировать блоками и сущностями (через [адаптер](block/adapter.md) или с помощью улучшений для [роботов](block/robot.md) и [дронов](item/drone.md)). Энергию можно подключить от разных модов, включая: Redstone Flux, EU из IndustrialCraft2, джоули Mekanism, заряд из Applied Energistics 2 и Factorization.

Устройства в OpenComputers имеют дополнительные функции и ограничения. [Компьютеры](general/computer.md) - основа всего; они могут обслуживать различное количество компонентов, в зависимости от уровня используемого процессора. [Компьютеры](general/computer.md) подключаются к компонентам со всех шести сторон. [Серверы](item/server1.md) могут подключаться к большему количеству компонентов (внешних или внутренних), чем [компьютеры](general/computer.md), за счет использования [компонентных шин](item/componentBus1.md), однако в [стойках](block/rack.md) каждый [сервер](item/server1.md) имеет доступ к компонентам только с одной стороны [стойки](block/rack.md), как настроено в ее интерфейсе. [Микроконтроллеры](block/microcontroller.md) еще сильнее ограничены по сравнению с [компьютерами](general/computer.md): они не имеют [жесткого диска](item/hdd1.md) и [дисковода](block/diskDrive.md), поэтому [OpenOS](general/openOS.md) не может быть установлена на [микроконтроллер](block/microcontroller.md). [Микроконтроллеры](block/microcontroller.md) имеют слот для [EEPROM](item/eeprom.md) и могут быть запрограммированы для специфических задач.

[Роботы](block/robot.md) - это передвижные [компьютеры](general/computer.md), которые могут взаимодействовать с игровым миром (но не могут взаимодействовать с внешними блоками OpenComputers). В отличие от [компьютеров](general/computer.md), после создания [робота](block/robot.md) компоненты внутри него не могут быть извлечены. Для обхода этого ограничения [роботы](block/robot.md) могут быть созданы с [контейнером для улучшения](item/upgradeContainer1.md) или [контейнером для карт](item/cardContainer1.md), что позволяет в любой момент добавить дополнительную карту или улучшение, если требуется. Чтобы установить операционная система [OpenOS](general/openOS.md) в [роботов](block/robot.md), установите [дисковод](block/diskDrive.md) в один из слотов для контейнеров при сборке, после чего вы сможете вставить [дискету](item/floppy.md), или вставьте [жесткий диск](item/hdd1.md) с установленной на него [OpenOS](general/openOS.md). Для полного изменения конфигурации [робота](block/robot.md) вам потребуется [разборщик](block/disassembler.md). [Дроны](item/drone.md) - это урезанная версия [роботов](block/robot.md). Они двигаются по-другому, имеют несколько слотов для компонентов и не имеют операционной системы (так же, как и [микроконтроллеры](block/microcontroller.md), [дроны](item/drone.md) могут быть сконфигурированы с помощью [EEPROM](item/eeprom.md) для выполнения специфических задач). В основном, [роботы](block/robot.md) и [дроны](item/drone.md) могут иметь одни и те же компоненты и улучшения, однако, эффективность улучшений различна, например у [дронов](item/drone.md) [улучшение инвентаря](item/inventoryUpgrade.md) добавит только 4 слота за каждое улучшение и позволяет иметь всего до 8 слотов, в то время как [роботы](block/robot.md) могут иметь больше [улучшений инвентаря](item/inventoryUpgrade.md) (в сумме 4), а также большее количество слотов с каждым улучшение (по 16 слотов на улучшение).

Данное руководство содержит подробную информацию обо всех блоках и предметах, о настройке систем и устройств, а также введение в программирование на Lua.
