/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.teleport;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.meecreeps.items.PortalGunItem;
import mcjty.meecreeps.teleport.TeleportDestination;
import mcjty.meecreeps.teleport.TeleportationTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketMakePortals
implements IMessage {
    private BlockPos selectedBlock;
    private TeleportDestination destination;
    private EnumFacing selectedSide;

    public void fromBytes(ByteBuf buf) {
        this.selectedBlock = BlockPos.func_177969_a((long)buf.readLong());
        this.selectedSide = EnumFacing.field_82609_l[buf.readByte()];
        this.destination = new TeleportDestination(NetworkTools.readStringUTF8((ByteBuf)buf), buf.readInt(), BlockPos.func_177969_a((long)buf.readLong()), EnumFacing.field_82609_l[buf.readByte()]);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.selectedBlock.func_177986_g());
        buf.writeByte(this.selectedSide.ordinal());
        NetworkTools.writeStringUTF8((ByteBuf)buf, (String)this.destination.getName());
        buf.writeInt(this.destination.getDimension());
        buf.writeLong(this.destination.getPos().func_177986_g());
        buf.writeByte(this.destination.getSide().ordinal());
    }

    public PacketMakePortals() {
    }

    public PacketMakePortals(BlockPos selectedBlock, EnumFacing selectedSide, TeleportDestination destination) {
        this.selectedBlock = selectedBlock;
        this.selectedSide = selectedSide;
        this.destination = destination;
    }

    public static class Handler
    implements IMessageHandler<PacketMakePortals, IMessage> {
        public IMessage onMessage(PacketMakePortals message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketMakePortals message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack heldItem = PortalGunItem.getGun((EntityPlayer)player);
            if (heldItem.func_190926_b()) {
                return;
            }
            TeleportationTools.makePortalPair((EntityPlayer)player, message.selectedBlock, message.selectedSide, message.destination);
        }
    }
}

