/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.typed.TypedMap;
import mcjty.meecreeps.CommandHandler;
import mcjty.meecreeps.MeeCreeps;
import mcjty.meecreeps.actions.PacketShowBalloonToClient;
import mcjty.meecreeps.blocks.ModBlocks;
import mcjty.meecreeps.config.Config;
import mcjty.meecreeps.entities.EntityProjectile;
import mcjty.meecreeps.gui.GuiWheel;
import mcjty.meecreeps.items.ModItems;
import mcjty.meecreeps.network.MeeCreepsMessages;
import mcjty.meecreeps.teleport.TeleportDestination;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class PortalGunItem
extends Item {
    public PortalGunItem() {
        this.setRegistryName("portalgun");
        this.func_77655_b("meecreeps.portalgun");
        this.func_77625_d(1);
        this.func_77637_a(MeeCreeps.creativeTab);
    }

    public static ItemStack getGun(EntityPlayer player) {
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_77973_b() != ModItems.portalGunItem && (heldItem = player.func_184586_b(EnumHand.OFF_HAND)).func_77973_b() != ModItems.portalGunItem) {
            return ItemStack.field_190927_a;
        }
        return heldItem;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Collections.addAll(tooltip, StringUtils.split((String)I18n.func_135052_a((String)"message.meecreeps.tooltip.portalgun", (Object[])new Object[]{Integer.toString(PortalGunItem.getCharge(stack))}), (String)"\n"));
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.field_72995_K) {
            if (world.func_180495_p(pos.func_177972_a(side)).func_177230_c() == ModBlocks.portalBlock) {
                MeeCreepsMessages.INSTANCE.sendToServer((IMessage)new PacketSendServerCommand("meecreeps", "cancel_portal", TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)pos.func_177972_a(side)).build()));
                return EnumActionResult.SUCCESS;
            }
            if (side != EnumFacing.UP && side != EnumFacing.DOWN && world.func_180495_p(pos.func_177972_a(side).func_177977_b()).func_177230_c() == ModBlocks.portalBlock) {
                MeeCreepsMessages.INSTANCE.sendToServer((IMessage)new PacketSendServerCommand("meecreeps", "cancel_portal", TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)pos.func_177972_a(side).func_177977_b()).build()));
                return EnumActionResult.SUCCESS;
            }
            if (player.func_70093_af()) {
                GuiWheel.selectedBlock = pos;
                GuiWheel.selectedSide = side;
                player.openGui((Object)MeeCreeps.instance, 3, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return EnumActionResult.SUCCESS;
        }
        if (world.func_180495_p(pos.func_177972_a(side)).func_177230_c() == ModBlocks.portalBlock) {
            return EnumActionResult.SUCCESS;
        }
        if (side != EnumFacing.UP && side != EnumFacing.DOWN && world.func_180495_p(pos.func_177972_a(side).func_177977_b()).func_177230_c() == ModBlocks.portalBlock) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_70093_af()) {
            this.throwProjectile(player, hand, world);
        }
        return EnumActionResult.SUCCESS;
    }

    private void throwProjectile(EntityPlayer player, EnumHand hand, World world) {
        ItemStack heldItem = player.func_184586_b(hand);
        int charge = PortalGunItem.getCharge(heldItem);
        if (charge <= 0) {
            MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketShowBalloonToClient("message.meecreeps.gun_no_charge", new String[0]), (EntityPlayerMP)player);
            return;
        }
        PortalGunItem.setCharge(heldItem, charge - 1);
        List<TeleportDestination> destinations = PortalGunItem.getDestinations(heldItem);
        int current = PortalGunItem.getCurrentDestination(heldItem);
        if (current == -1) {
            MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketShowBalloonToClient("message.meecreeps.gun_no_destination", new String[0]), (EntityPlayerMP)player);
        } else if (destinations.get(current) == null) {
            MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketShowBalloonToClient("message.meecreeps.gun_bad_destination", new String[0]), (EntityPlayerMP)player);
        } else {
            EntityProjectile projectile = new EntityProjectile(world, (EntityLivingBase)player);
            projectile.setDestination(destinations.get(current));
            projectile.setPlayerId(player.func_110124_au());
            projectile.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
            world.func_72838_d((Entity)projectile);
        }
    }

    public static void addDestination(ItemStack stack, @Nullable TeleportDestination destination, int destinationIndex) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        List<TeleportDestination> destinations = PortalGunItem.getDestinations(stack);
        destinations.set(destinationIndex, destination);
        PortalGunItem.setDestinations(stack, destinations);
        if (destination != null) {
            PortalGunItem.setCurrentDestination(stack, destinationIndex);
        }
    }

    private static void setDestinations(ItemStack stack, List<TeleportDestination> destinations) {
        NBTTagList dests = new NBTTagList();
        for (TeleportDestination destination : destinations) {
            if (destination != null) {
                dests.func_74742_a((NBTBase)destination.getCompound());
                continue;
            }
            dests.func_74742_a((NBTBase)new NBTTagCompound());
        }
        stack.func_77978_p().func_74782_a("dests", (NBTBase)dests);
    }

    public static int getCurrentDestination(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return -1;
        }
        return tag.func_74762_e("destination");
    }

    public static void setCurrentDestination(ItemStack stack, int dest) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("destination", dest);
    }

    public static List<TeleportDestination> getDestinations(ItemStack stack) {
        ArrayList<TeleportDestination> destinations = new ArrayList<TeleportDestination>();
        if (!stack.func_77942_o()) {
            for (int i = 0; i < 8; ++i) {
                destinations.add(null);
            }
        } else {
            NBTTagCompound tag = stack.func_77978_p();
            NBTTagList dests = tag.func_150295_c("dests", 10);
            for (int i = 0; i < 8; ++i) {
                NBTTagCompound tc;
                NBTTagCompound nBTTagCompound = tc = i < dests.func_74745_c() ? dests.func_150305_b(i) : null;
                if (tc != null && tc.func_74764_b("dim")) {
                    destinations.add(new TeleportDestination(tc));
                    continue;
                }
                destinations.add(null);
            }
        }
        return destinations;
    }

    public static void setCharge(ItemStack stack, int charge) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("charge", charge);
    }

    public static int getCharge(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("charge");
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int max = Config.maxCharge;
        int stored = PortalGunItem.getCharge(stack);
        return (double)(max - stored) / (double)max;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public Item func_77668_q() {
        return ModItems.emptyPortalGunItem;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        ItemStack stack = new ItemStack((Item)ModItems.emptyPortalGunItem);
        stack.func_77982_d(itemStack.func_77978_p());
        return stack;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            this.throwProjectile(player, hand, world);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }
}

