/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.items;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.meecreeps.MeeCreeps;
import mcjty.meecreeps.actions.PacketShowBalloonToClient;
import mcjty.meecreeps.config.Config;
import mcjty.meecreeps.network.MeeCreepsMessages;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class CartridgeItem
extends Item {
    public CartridgeItem() {
        this.setRegistryName("cartridge");
        this.func_77655_b("meecreeps.cartridge");
        this.func_77625_d(1);
        this.func_77637_a(MeeCreeps.creativeTab);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Collections.addAll(tooltip, StringUtils.split((String)I18n.func_135052_a((String)"message.meecreeps.tooltip.cartridge_item", (Object[])new Object[]{Integer.toString(CartridgeItem.getCharge(stack))}), (String)"\n"));
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public static void setCharge(ItemStack stack, int charge) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("charge", charge);
    }

    public static int getCharge(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("charge");
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int max = Config.maxCharge;
        int stored = CartridgeItem.getCharge(stack);
        return (double)(max - stored) / (double)max;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K) {
            this.chargeCartridge(player, world, pos, hand);
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            this.chargeCartridge(player, world, player.func_180425_c(), hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private void chargeCartridge(EntityPlayer player, World world, BlockPos pos, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        int charge = CartridgeItem.getCharge(heldItem);
        if (charge >= Config.maxCharge - Config.chargesPerEnderpearl + 1) {
            MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketShowBalloonToClient("message.meecreeps.cartridge_full", new String[0]), (EntityPlayerMP)player);
        } else {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_77973_b() != Items.field_151079_bi) continue;
                ItemStack splitted = stack.func_77979_a(1);
                CartridgeItem.setCharge(heldItem, charge += Config.chargesPerEnderpearl);
                return;
            }
            MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketShowBalloonToClient("message.meecreeps.missing_enderpearls", new String[0]), (EntityPlayerMP)player);
        }
    }
}

