/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.workers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.SoundTools;
import mcjty.meecreeps.ForgeEventHandlers;
import mcjty.meecreeps.MeeCreeps;
import mcjty.meecreeps.actions.ActionOptions;
import mcjty.meecreeps.actions.MeeCreepActionType;
import mcjty.meecreeps.actions.PacketShowBalloonToClient;
import mcjty.meecreeps.actions.ServerActionManager;
import mcjty.meecreeps.actions.Stage;
import mcjty.meecreeps.api.BuildProgress;
import mcjty.meecreeps.api.IActionContext;
import mcjty.meecreeps.api.IActionWorker;
import mcjty.meecreeps.api.IBuildSchematic;
import mcjty.meecreeps.api.IDesiredBlock;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.api.IWorkerHelper;
import mcjty.meecreeps.api.PreferedChest;
import mcjty.meecreeps.blocks.ModBlocks;
import mcjty.meecreeps.config.Config;
import mcjty.meecreeps.entities.EntityMeeCreeps;
import mcjty.meecreeps.items.CreepCubeItem;
import mcjty.meecreeps.network.MeeCreepsMessages;
import mcjty.meecreeps.varia.GeneralTools;
import mcjty.meecreeps.varia.InventoryTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class WorkerHelper
implements IWorkerHelper {
    private final double DISTANCE_TOLERANCE = 1.4;
    private IActionWorker worker;
    private final ActionOptions options;
    private EntityMeeCreeps entity;
    private boolean needsToPutAway = false;
    private int waitABit = 10;
    private int speed = 10;
    private BlockPos movingToPos;
    private Entity movingToEntity;
    private double prevPosX;
    private double prevPosY;
    private double prevPosZ;
    private int stuckCounter;
    private int pathTries = 0;
    private Consumer<BlockPos> job;
    private Runnable delayedJob;
    private int delayedTicks;
    private List<EntityItem> itemsToPickup = new ArrayList<EntityItem>();
    private BlockPos materialChest;
    private Set<BlockPos> positionsToSkip = new HashSet<BlockPos>();
    private String lastMessage = "";
    private static final Set<String> TORCHES = new HashSet<String>();
    private static final IDesiredBlock AIR;
    private static final IDesiredBlock IGNORE;

    public WorkerHelper(IActionContext options) {
        this.options = (ActionOptions)options;
    }

    public static boolean isTorch(ItemStack stack) {
        return TORCHES.contains(stack.func_77973_b().getRegistryName().toString());
    }

    public static boolean isTorch(Block block) {
        return TORCHES.contains(block.getRegistryName().toString());
    }

    public void setWorker(IActionWorker worker) {
        this.worker = worker;
    }

    public IActionWorker getWorker() {
        return this.worker;
    }

    public void cancelJob() {
        this.job = null;
        this.delayedJob = null;
    }

    @Override
    public void setSpeed(int speed) {
        this.speed = speed;
    }

    @Override
    public int getSpeed() {
        return this.speed;
    }

    @Override
    public IActionContext getContext() {
        return this.options;
    }

    @Override
    public IMeeCreep getMeeCreep() {
        return this.entity;
    }

    @Override
    public IDesiredBlock getAirBlock() {
        return AIR;
    }

    @Override
    public IDesiredBlock getIgnoreBlock() {
        return IGNORE;
    }

    @Override
    public BlockPos findSpotToFlatten(@Nonnull IBuildSchematic schematic) {
        BlockPos tpos = this.options.getTargetPos();
        BlockPos minPos = schematic.getMinPos();
        BlockPos maxPos = schematic.getMaxPos();
        ArrayList<BlockPos> todo = new ArrayList<BlockPos>();
        for (int x = minPos.func_177958_n(); x <= maxPos.func_177958_n(); ++x) {
            for (int y = minPos.func_177956_o(); y <= maxPos.func_177956_o(); ++y) {
                for (int z = minPos.func_177952_p(); z <= maxPos.func_177952_p(); ++z) {
                    BlockPos relativePos = new BlockPos(x, y, z);
                    BlockPos p = tpos.func_177971_a((Vec3i)relativePos);
                    IBlockState state = this.entity.getWorld().func_180495_p(p);
                    IDesiredBlock desired = schematic.getDesiredBlock(relativePos);
                    if (desired == IGNORE || desired.getStateMatcher().test(state) || this.entity.getWorld().func_175623_d(p) || this.positionsToSkip.contains(p)) continue;
                    todo.add(p);
                }
            }
        }
        if (todo.isEmpty()) {
            return null;
        }
        BlockPos position = this.entity.getEntity().func_180425_c();
        todo.sort((o1, o2) -> {
            double d1 = position.func_177951_i((Vec3i)o1);
            double d2 = position.func_177951_i((Vec3i)o2);
            return Double.compare(d1, d2);
        });
        return (BlockPos)todo.get(0);
    }

    @Override
    public BlockPos findSpotToBuild(@Nonnull IBuildSchematic schematic, @Nonnull BuildProgress progress, @Nonnull Set<BlockPos> toSkip) {
        BlockPos tpos = this.options.getTargetPos();
        BlockPos minPos = schematic.getMinPos();
        BlockPos maxPos = schematic.getMaxPos();
        ArrayList<BlockPos> todo = new ArrayList<BlockPos>();
        for (int x = minPos.func_177958_n(); x <= maxPos.func_177958_n(); ++x) {
            for (int z = minPos.func_177952_p(); z <= maxPos.func_177952_p(); ++z) {
                BlockPos relativePos = new BlockPos(x, progress.getHeight(), z);
                if (toSkip.contains(relativePos)) continue;
                BlockPos p = tpos.func_177971_a((Vec3i)relativePos);
                IBlockState state = this.entity.getWorld().func_180495_p(p);
                IDesiredBlock desired = schematic.getDesiredBlock(relativePos);
                if (desired.getPass() != progress.getPass() || desired.getStateMatcher().test(state) || this.positionsToSkip.contains(p)) continue;
                todo.add(relativePos);
            }
        }
        if (todo.isEmpty()) {
            if (!progress.next(schematic)) {
                return null;
            }
            return this.findSpotToBuild(schematic, progress, toSkip);
        }
        BlockPos position = this.entity.getEntity().func_180425_c().func_177973_b((Vec3i)tpos);
        todo.sort((o1, o2) -> {
            double d1 = position.func_177951_i((Vec3i)o1);
            double d2 = position.func_177951_i((Vec3i)o2);
            return Double.compare(d1, d2);
        });
        return (BlockPos)todo.get(0);
    }

    @Override
    public void delayForHardBlocks(BlockPos pos, Consumer<BlockPos> nextJob) {
        World world = this.entity.func_130014_f_();
        if (world.func_175623_d(pos)) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!this.allowedToHarvest(state, world, pos, (EntityPlayer)GeneralTools.getHarvester(world))) {
            return;
        }
        Block block = state.func_177230_c();
        if (block instanceof BlockLiquid) {
            nextJob.accept(pos);
        } else {
            float hardness = state.func_185887_b(world, pos);
            if (hardness < Config.delayAtHardness) {
                nextJob.accept(pos);
            } else {
                this.delay((int)(hardness * Config.delayFactor), () -> nextJob.accept(pos));
            }
        }
    }

    @Override
    public boolean handleFlatten(@Nonnull IBuildSchematic schematic) {
        BlockPos flatSpot = this.findSpotToFlatten(schematic);
        if (flatSpot == null) {
            return false;
        }
        BlockPos navigate = this.findBestNavigationSpot(flatSpot);
        if (navigate != null) {
            this.navigateTo(navigate, (BlockPos p) -> this.delayForHardBlocks(flatSpot, pp -> {
                if (!this.harvestAndDrop(flatSpot)) {
                    this.positionsToSkip.add(flatSpot);
                }
            }));
        } else {
            this.delayForHardBlocks(flatSpot, pp -> {
                if (!this.harvestAndDrop(flatSpot)) {
                    this.positionsToSkip.add(flatSpot);
                }
            });
        }
        return true;
    }

    @Override
    public boolean handleBuilding(@Nonnull IBuildSchematic schematic, @Nonnull BuildProgress progress, @Nonnull Set<BlockPos> toSkip) {
        BlockPos relativePos = this.findSpotToBuild(schematic, progress, toSkip);
        if (relativePos != null) {
            IDesiredBlock desired = schematic.getDesiredBlock(relativePos);
            if (!this.entity.hasItem(desired.getMatcher())) {
                if (this.entity.hasRoom(desired.getMatcher())) {
                    if (desired.isOptional()) {
                        if (!this.findItemOnGroundOrInChest(desired.getMatcher(), desired.getAmount())) {
                            toSkip.add(relativePos);
                        }
                    } else {
                        this.findItemOnGroundOrInChest(desired.getMatcher(), desired.getAmount(), "message.meecreeps.cannot_find", desired.getName());
                    }
                } else {
                    this.putStuffAway();
                }
            } else {
                BlockPos buildPos = relativePos.func_177971_a((Vec3i)this.options.getTargetPos());
                BlockPos navigate = this.findBestNavigationSpot(buildPos);
                if (navigate != null) {
                    this.navigateTo(navigate, (BlockPos p) -> {
                        if (!this.placeBuildingBlock(buildPos, desired)) {
                            this.positionsToSkip.add(buildPos);
                        }
                    });
                } else if (!this.placeBuildingBlock(buildPos, desired)) {
                    this.positionsToSkip.add(buildPos);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void giveDropsToMeeCreeps(@Nonnull List<ItemStack> drops) {
        for (ItemStack stack : drops) {
            ItemStack remaining = this.entity.addStack(stack);
            if (remaining.func_190926_b()) continue;
            this.itemsToPickup.add(this.entity.func_70099_a(remaining, 0.0f));
            this.needsToPutAway = true;
        }
    }

    @Override
    public void showMessage(String message, String ... parameters) {
        if (this.lastMessage.equals(message)) {
            return;
        }
        this.lastMessage = message;
        EntityPlayerMP player = this.getPlayer();
        if (player != null) {
            MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketShowBalloonToClient(message, parameters), player);
        }
    }

    @Override
    public void registerHarvestableBlock(BlockPos pos) {
        ForgeEventHandlers.harvestableBlocksToCollect.put(pos, this.options.getActionId());
    }

    @Override
    public void navigateTo(BlockPos pos, Consumer<BlockPos> job) {
        double d = WorkerHelper.getSquareDist((Entity)this.entity, pos);
        if (d < 1.4) {
            job.accept(pos);
        } else if (!this.entity.func_70661_as().func_75492_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 2.0)) {
            this.entity.func_70634_a((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            job.accept(pos);
        } else {
            this.movingToPos = pos;
            this.movingToEntity = null;
            this.pathTries = 1;
            this.job = job;
            this.prevPosX = this.entity.field_70165_t;
            this.prevPosY = this.entity.field_70163_u;
            this.prevPosZ = this.entity.field_70161_v;
            this.stuckCounter = 0;
        }
    }

    @Override
    public boolean navigateTo(Entity dest, Consumer<BlockPos> job, double maxDist) {
        if (dest == null || dest.field_70128_L) {
            return false;
        }
        double d = WorkerHelper.getSquareDist((Entity)this.entity, dest);
        if (d > maxDist * maxDist) {
            return false;
        }
        if (d < 1.4) {
            job.accept(dest.func_180425_c());
        } else if (!this.entity.func_70661_as().func_75497_a(dest, 2.0)) {
            this.entity.func_70634_a(dest.field_70165_t, dest.field_70163_u, dest.field_70161_v);
            job.accept(dest.func_180425_c());
        } else {
            this.movingToPos = null;
            this.movingToEntity = dest;
            this.pathTries = 1;
            this.job = job;
        }
        return true;
    }

    private static double getSquareDist(Entity source, BlockPos dest) {
        double d0 = dest.func_177957_d(source.field_70165_t, source.field_70163_u - 1.0, source.field_70161_v);
        double d1 = dest.func_177957_d(source.field_70165_t, source.field_70163_u, source.field_70161_v);
        double d2 = dest.func_177957_d(source.field_70165_t, source.field_70163_u + (double)source.func_70047_e(), source.field_70161_v);
        return Math.min(Math.min(d0, d1), d2);
    }

    private static double getSquareDist(Entity source, Entity dest) {
        Vec3d lowPosition = new Vec3d(source.field_70165_t, source.field_70163_u - 1.0, source.field_70161_v);
        Vec3d position = new Vec3d(source.field_70165_t, source.field_70163_u, source.field_70161_v);
        Vec3d eyePosition = new Vec3d(source.field_70165_t, source.field_70163_u + (double)source.func_70047_e(), source.field_70161_v);
        double d0 = lowPosition.func_186679_c(dest.field_70165_t, dest.field_70163_u, dest.field_70161_v);
        double d1 = position.func_186679_c(dest.field_70165_t, dest.field_70163_u, dest.field_70161_v);
        double d2 = eyePosition.func_186679_c(dest.field_70165_t, dest.field_70163_u, dest.field_70161_v);
        return Math.min(Math.min(d0, d1), d2);
    }

    @Override
    public boolean navigateTo(Entity dest, Consumer<BlockPos> job) {
        return this.navigateTo(dest, job, 1.0E9);
    }

    private boolean isStuck() {
        return Math.abs(this.entity.field_70165_t - this.prevPosX) < 0.01 && Math.abs(this.entity.field_70163_u - this.prevPosY) < 0.01 && Math.abs(this.entity.field_70161_v - this.prevPosZ) < 0.01;
    }

    private boolean isCube(ItemStack stack) {
        return stack.func_77973_b() instanceof CreepCubeItem;
    }

    @Override
    public void delay(int ticks, Runnable task) {
        this.delayedTicks = ticks;
        this.delayedJob = task;
    }

    public void tick(EntityMeeCreeps entity, boolean timeToWrapUp) {
        --this.waitABit;
        if (this.waitABit > 0) {
            return;
        }
        this.waitABit = this.speed;
        this.entity = entity;
        if (this.delayedJob != null) {
            this.delayedTicks -= this.speed;
            if (this.delayedTicks < 0) {
                Runnable d = this.delayedJob;
                this.delayedJob = null;
                d.run();
            }
        } else if (this.job != null) {
            this.handleJob();
        } else if (entity.hasItem(this::isCube)) {
            this.spawnAngryCreep();
        } else if (this.findMeeCreepBoxOnGround()) {
            entity.dropInventory();
            this.setSpeed(20);
        } else if (!this.options.getDrops().isEmpty()) {
            this.handleDropCollection();
        } else if (this.needToFindChest(timeToWrapUp)) {
            this.handlePutAway();
        } else if (!this.itemsToPickup.isEmpty()) {
            this.tryFindingItemsToPickup();
        } else {
            this.worker.tick(timeToWrapUp);
        }
        this.entity = null;
    }

    private void spawnAngryCreep() {
        this.entity.setHeldBlockState(ModBlocks.heldCubeBlock.func_176223_P());
        this.entity.setVariationFace(1);
        ServerActionManager manager = ServerActionManager.getManager();
        World world = this.entity.getWorld();
        int cnt = world.func_72907_a(EntityMeeCreeps.class);
        if (cnt >= Config.maxSpawnCount) {
            return;
        }
        Random r = this.entity.getRandom();
        BlockPos targetPos = new BlockPos(this.entity.field_70165_t + (double)(r.nextFloat() * 8.0f) - 4.0, this.entity.field_70163_u, this.entity.field_70161_v + (double)(r.nextFloat() * 8.0f) - 4.0);
        int actionId = manager.createActionOptions(world, targetPos, EnumFacing.UP, (EntityPlayer)this.getPlayer());
        ActionOptions.spawn(world, targetPos, EnumFacing.UP, actionId, false);
        manager.performAction(null, actionId, new MeeCreepActionType("meecreeps.angry"), null);
    }

    private void handlePutAway() {
        if (!this.findChestToPutItemsIn() && !this.navigateTo((Entity)this.getPlayer(), p -> this.giveToPlayerOrDrop(), 12.0)) {
            this.entity.dropInventory();
        }
        this.needsToPutAway = false;
    }

    private void handleDropCollection() {
        for (Pair<BlockPos, ItemStack> pair : this.options.getDrops()) {
            ItemStack remaining;
            ItemStack drop = (ItemStack)pair.getValue();
            if (drop.func_190926_b() || (remaining = this.entity.addStack(drop)).func_190926_b()) continue;
            this.entity.func_70099_a(remaining, 0.0f);
            this.needsToPutAway = true;
        }
        this.options.clearDrops();
        ServerActionManager.getManager().save();
        this.waitABit = 1;
    }

    private void handleJob() {
        if (this.movingToEntity != null) {
            if (this.movingToEntity.field_70128_L) {
                this.job = null;
            } else {
                double d = WorkerHelper.getSquareDist((Entity)this.entity, this.movingToEntity);
                if (d < 1.4) {
                    this.job.accept(this.movingToEntity.func_180425_c());
                    this.job = null;
                } else if (this.entity.func_70661_as().func_75500_f()) {
                    if (this.pathTries > 2) {
                        this.entity.func_70634_a(this.movingToEntity.field_70165_t, this.movingToEntity.field_70163_u, this.movingToEntity.field_70161_v);
                        this.job.accept(this.movingToEntity.func_180425_c());
                        this.job = null;
                    } else {
                        ++this.pathTries;
                        this.entity.func_70661_as().func_75497_a(this.movingToEntity, 2.0);
                        this.stuckCounter = 0;
                    }
                } else if (this.isStuck()) {
                    ++this.stuckCounter;
                    if (this.stuckCounter > 5) {
                        this.entity.func_70634_a(this.movingToEntity.field_70165_t, this.movingToEntity.field_70163_u, this.movingToEntity.field_70161_v);
                        this.job.accept(this.movingToEntity.func_180425_c());
                        this.job = null;
                    }
                }
            }
        } else {
            double d = WorkerHelper.getSquareDist((Entity)this.entity, this.movingToPos);
            if (d < 1.4) {
                this.job.accept(this.movingToPos);
                this.job = null;
            } else if (this.entity.func_70661_as().func_75500_f()) {
                if (this.pathTries > 2) {
                    this.entity.func_70634_a((double)this.movingToPos.func_177958_n() + 0.5, this.movingToPos.func_177956_o(), (double)this.movingToPos.func_177952_p() + 0.5);
                    this.job.accept(this.movingToPos);
                    this.job = null;
                } else {
                    ++this.pathTries;
                    this.entity.func_70661_as().func_75492_a((double)this.movingToPos.func_177958_n() + 0.5, (double)this.movingToPos.func_177956_o(), (double)this.movingToPos.func_177952_p() + 0.5, 2.0);
                    this.stuckCounter = 0;
                }
            } else if (this.isStuck()) {
                ++this.stuckCounter;
                if (this.stuckCounter > 5) {
                    this.entity.func_70634_a((double)this.movingToPos.func_177958_n() + 0.5, this.movingToPos.func_177956_o(), (double)this.movingToPos.func_177952_p() + 0.5);
                    this.job.accept(this.movingToPos);
                    this.job = null;
                }
            }
        }
        this.prevPosX = this.entity.field_70165_t;
        this.prevPosY = this.entity.field_70163_u;
        this.prevPosZ = this.entity.field_70161_v;
    }

    @Override
    public boolean placeBuildingBlock(BlockPos pos, IDesiredBlock desiredBlock) {
        World world = this.entity.getWorld();
        if (!world.func_175623_d(pos) && !world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            if (!this.allowedToHarvest(world.func_180495_p(pos), world, pos, (EntityPlayer)GeneralTools.getHarvester(world))) {
                return false;
            }
            this.delayForHardBlocks(pos, pp -> {
                this.harvestAndDrop(pos);
                this.reallyPlace(pos, desiredBlock, world);
            });
        } else {
            this.reallyPlace(pos, desiredBlock, world);
        }
        return true;
    }

    private void reallyPlace(BlockPos pos, IDesiredBlock desiredBlock, World world) {
        ItemStack blockStack = this.entity.consumeItem(desiredBlock.getMatcher(), 1);
        if (!blockStack.func_190926_b()) {
            boolean jump;
            this.placeStackAt(blockStack, world, pos);
            boolean bl = jump = !this.entity.func_70058_J();
            if (jump) {
                this.entity.getEntity().func_70683_ar().func_75660_a();
            }
        }
    }

    @Override
    public void placeStackAt(ItemStack blockStack, World world, BlockPos pos) {
        IBlockState state = BlockTools.placeStackAt((EntityPlayer)GeneralTools.getHarvester(world), (ItemStack)blockStack, (World)world, (BlockPos)pos, null);
        SoundTools.playSound((World)world, (SoundEvent)state.func_177230_c().func_185467_w().func_185841_e(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)1.0, (double)1.0);
    }

    @Override
    public boolean harvestAndPickup(BlockPos pos) {
        World world = this.entity.func_130014_f_();
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!this.allowedToHarvest(state, world, pos, (EntityPlayer)GeneralTools.getHarvester(world))) {
            return false;
        }
        Block block = state.func_177230_c();
        List drops = block.getDrops((IBlockAccess)world, pos, state, 0);
        ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)GeneralTools.getHarvester(world));
        SoundTools.playSound((World)world, (SoundEvent)block.func_185467_w().func_185845_c(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)1.0, (double)1.0);
        block.func_176208_a(world, pos, state, (EntityPlayer)GeneralTools.getHarvester(world));
        this.entity.func_130014_f_().func_175698_g(pos);
        this.giveDropsToMeeCreeps(drops);
        return true;
    }

    @Override
    public boolean harvestAndDrop(BlockPos pos) {
        World world = this.entity.func_130014_f_();
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!this.allowedToHarvest(state, world, pos, (EntityPlayer)GeneralTools.getHarvester(world))) {
            return false;
        }
        Block block = state.func_177230_c();
        List drops = block.getDrops((IBlockAccess)world, pos, state, 0);
        ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)GeneralTools.getHarvester(world));
        SoundTools.playSound((World)world, (SoundEvent)block.func_185467_w().func_185845_c(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)1.0, (double)1.0);
        block.func_176208_a(world, pos, state, (EntityPlayer)GeneralTools.getHarvester(world));
        this.entity.func_130014_f_().func_175698_g(pos);
        for (ItemStack stack : drops) {
            this.entity.func_70099_a(stack, 0.0f);
        }
        return true;
    }

    @Override
    public void pickup(EntityItem item) {
        ItemStack remaining = this.entity.addStack(item.func_92059_d().func_77946_l());
        if (remaining.func_190926_b()) {
            item.func_70106_y();
        } else {
            item.func_92058_a(remaining);
            this.needsToPutAway = true;
        }
    }

    @Override
    public boolean allowedToHarvest(IBlockState state, World world, BlockPos pos, EntityPlayer entityPlayer) {
        if (state.func_177230_c().func_176195_g(state, world, pos) < 0.0f) {
            return false;
        }
        if (!state.func_177230_c().canEntityDestroy(state, (IBlockAccess)world, pos, (Entity)entityPlayer)) {
            return false;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, entityPlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        return state.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, entityPlayer);
    }

    @Override
    public void done() {
        this.options.setStage(Stage.DONE);
        ServerActionManager.getManager().save();
    }

    @Override
    public void taskIsDone() {
        this.options.setStage(Stage.TASK_IS_DONE);
        ServerActionManager.getManager().save();
    }

    @Override
    public void putStuffAway() {
        this.needsToPutAway = true;
    }

    @Override
    public void speedUp(int t) {
        this.waitABit = t;
    }

    @Override
    public void dropAndPutAwayLater(ItemStack stack) {
        EntityItem entityItem = this.entity.getEntity().func_70099_a(stack, 0.0f);
        this.itemsToPickup.add(entityItem);
        this.putStuffAway();
    }

    @Override
    public BlockPos findSuitablePositionNearPlayer(double distance) {
        return WorkerHelper.findSuitablePositionNearPlayer(this.entity, this.options.getPlayer(), distance);
    }

    public static BlockPos findSuitablePositionNearPlayer(@Nonnull EntityMeeCreeps meeCreep, @Nonnull EntityPlayer player, double distance) {
        float eyeHeight;
        float width;
        Vec3d playerPos = player.func_174791_d();
        Vec3d entityPos = meeCreep.func_174791_d();
        if (entityPos.func_72438_d(playerPos) < distance * 1.2) {
            return meeCreep.func_180425_c();
        }
        double dx = playerPos.field_72450_a - entityPos.field_72450_a;
        double dy = playerPos.field_72450_a - entityPos.field_72450_a;
        double dz = playerPos.field_72450_a - entityPos.field_72450_a;
        Vec3d v = new Vec3d(-dx, -dy, -dz);
        v = v.func_72432_b();
        Vec3d pos = new Vec3d(playerPos.field_72450_a + v.field_72450_a * distance, playerPos.field_72448_b + v.field_72448_b * distance, playerPos.field_72449_c + v.field_72449_c * distance);
        World world = player.func_130014_f_();
        BlockPos p = WorkerHelper.scanSuitablePos(new BlockPos(pos.field_72450_a, pos.field_72448_b + 0.5, pos.field_72449_c), world, width = meeCreep.field_70130_N, eyeHeight = meeCreep.func_70047_e());
        if (p != null) {
            return p;
        }
        p = WorkerHelper.scanAround(pos, world, width, eyeHeight);
        if (p != null) {
            return p;
        }
        p = WorkerHelper.scanAround(playerPos, world, width, eyeHeight);
        if (p != null) {
            return p;
        }
        return player.func_180425_c();
    }

    private static BlockPos scanAround(Vec3d vec, World world, float width, float eyeHeight) {
        BlockPos pos = new BlockPos(vec.field_72450_a, vec.field_72448_b + 0.5, vec.field_72449_c);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos p = pos.func_177982_a(dx, 0, dz);
                if ((p = WorkerHelper.scanSuitablePos(p, world, width, eyeHeight)) == null) continue;
                return p;
            }
        }
        return null;
    }

    private static BlockPos scanSuitablePos(BlockPos pos, World world, float width, float eyeHeight) {
        for (int d = 0; d < 6; ++d) {
            BlockPos p = pos.func_177979_c(d);
            if (WorkerHelper.isSuitableStandingPos(world, p, width, eyeHeight)) {
                return p;
            }
            p = pos.func_177981_b(d);
            if (!WorkerHelper.isSuitableStandingPos(world, p, width, eyeHeight)) continue;
            return p;
        }
        return null;
    }

    private static boolean isSuitableStandingPos(World world, BlockPos p, float width, float eyeHeight) {
        return WorkerHelper.canStandOn(world.func_180495_p(p.func_177977_b())) && !WorkerHelper.canStandOn(world.func_180495_p(p)) && !WorkerHelper.willSuffocateHere(world, (double)p.func_177958_n() + 0.5, p.func_177956_o(), (double)p.func_177952_p() + 0.5, width, eyeHeight);
    }

    private static boolean canStandOn(IBlockState state) {
        return state.func_185904_a().func_76230_c() && state.func_185917_h();
    }

    private static boolean willSuffocateHere(World world, double posX, double posY, double posZ, float width, float eyeHeight) {
        BlockPos.PooledMutableBlockPos mutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int i = 0; i < 8; ++i) {
            int x = MathHelper.func_76128_c((double)(posX + (double)(((float)((i >> 1) % 2) - 0.5f) * width * 0.8f)));
            int y = MathHelper.func_76128_c((double)(posY + (double)(((float)((i >> 0) % 2) - 0.5f) * 0.1f) + (double)eyeHeight));
            int z = MathHelper.func_76128_c((double)(posZ + (double)(((float)((i >> 2) % 2) - 0.5f) * width * 0.8f)));
            if (mutableBlockPos.func_177958_n() == x && mutableBlockPos.func_177956_o() == y && mutableBlockPos.func_177952_p() == z) continue;
            mutableBlockPos.func_181079_c(x, y, z);
            if (!world.func_180495_p((BlockPos)mutableBlockPos).func_191058_s()) continue;
            mutableBlockPos.func_185344_t();
            return true;
        }
        mutableBlockPos.func_185344_t();
        return false;
    }

    @Override
    public void giveToPlayerOrDrop() {
        EntityPlayerMP player = this.getPlayer();
        BlockPos position = this.entity.func_180425_c();
        if (player == null || position.func_177951_i((Vec3i)player.func_180425_c()) > 4.0) {
            if (player != null) {
                this.showMessage("message.meecreeps.where_are_you", new String[0]);
            }
            this.entity.dropInventory();
        } else {
            this.showMessage("message.meecreeps.i_gave_some_things", new String[0]);
            ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
            for (ItemStack stack : this.entity.getInventory()) {
                if (stack.func_190926_b() || player.field_71071_by.func_70441_a(stack)) continue;
                remaining.add(stack);
            }
            player.field_71070_bA.func_75142_b();
            for (ItemStack stack : remaining) {
                this.entity.func_70099_a(stack, 0.0f);
            }
            this.entity.getInventory().clear();
        }
    }

    @Nullable
    protected EntityPlayerMP getPlayer() {
        return (EntityPlayerMP)this.options.getPlayer();
    }

    @Override
    public boolean findItemOnGroundOrInChest(Predicate<ItemStack> matcher, int maxAmount, String message, String ... parameters) {
        List<BlockPos> meeCreepChests = this.findMeeCreepChests(this.worker.getSearchBox());
        if (meeCreepChests.isEmpty()) {
            if (!this.findItemOnGround(this.worker.getSearchBox(), matcher, this::pickup) && !this.findInventoryContainingMost(this.worker.getSearchBox(), matcher, (BlockPos p) -> this.fetchFromInventory((BlockPos)p, matcher, maxAmount))) {
                this.showMessage(message, parameters);
                return false;
            }
        } else if (!this.findInventoryContainingMost(meeCreepChests, matcher, (BlockPos p) -> this.fetchFromInventory((BlockPos)p, matcher, maxAmount))) {
            this.showMessage(message, parameters);
            return false;
        }
        return true;
    }

    @Override
    public boolean findItemOnGroundOrInChest(Predicate<ItemStack> matcher, int maxAmount) {
        List<BlockPos> meeCreepChests = this.findMeeCreepChests(this.worker.getSearchBox());
        return !(meeCreepChests.isEmpty() ? !this.findItemOnGround(this.worker.getSearchBox(), matcher, this::pickup) && !this.findInventoryContainingMost(this.worker.getSearchBox(), matcher, (BlockPos p) -> this.fetchFromInventory((BlockPos)p, matcher, maxAmount)) : !this.findInventoryContainingMost(meeCreepChests, matcher, (BlockPos p) -> this.fetchFromInventory((BlockPos)p, matcher, maxAmount)));
    }

    private List<BlockPos> findMeeCreepChests(AxisAlignedBB box) {
        List frames = this.entity.func_130014_f_().func_175647_a(EntityItemFrame.class, box, input -> {
            if (!input.func_82335_i().func_190926_b() && input.func_82335_i().func_77973_b() instanceof CreepCubeItem) {
                BlockPos position = input.func_174857_n().func_177972_a(input.field_174860_b.func_176734_d());
                if (InventoryTools.isInventory(this.entity.func_130014_f_(), position)) {
                    return true;
                }
            }
            return false;
        });
        return frames.stream().map(entityItemFrame -> entityItemFrame.func_174857_n().func_177972_a(entityItemFrame.field_174860_b.func_176734_d())).collect(Collectors.toList());
    }

    private boolean findMeeCreepBoxOnGround() {
        BlockPos position = this.entity.getEntity().func_180425_c();
        List items = this.entity.getWorld().func_175647_a(EntityItem.class, this.worker.getSearchBox(), input -> !input.func_92059_d().func_190926_b() && input.func_92059_d().func_77973_b() instanceof CreepCubeItem);
        if (!items.isEmpty()) {
            items.sort((o1, o2) -> {
                double d1 = position.func_177954_c(o1.field_70165_t, o1.field_70163_u, o1.field_70161_v);
                double d2 = position.func_177954_c(o2.field_70165_t, o2.field_70163_u, o2.field_70161_v);
                return Double.compare(d1, d2);
            });
            EntityItem entityItem = (EntityItem)items.get(0);
            this.navigateTo((Entity)entityItem, (BlockPos pos) -> this.pickup(entityItem));
            return true;
        }
        return false;
    }

    @Override
    public boolean findItemOnGround(AxisAlignedBB box, Predicate<ItemStack> matcher, Consumer<EntityItem> job) {
        BlockPos position = this.entity.func_180425_c();
        List items = this.entity.func_130014_f_().func_175647_a(EntityItem.class, box, input -> matcher.test(input.func_92059_d()));
        if (!items.isEmpty()) {
            items.sort((o1, o2) -> {
                double d1 = position.func_177954_c(o1.field_70165_t, o1.field_70163_u, o1.field_70161_v);
                double d2 = position.func_177954_c(o2.field_70165_t, o2.field_70163_u, o2.field_70161_v);
                return Double.compare(d1, d2);
            });
            EntityItem entityItem = (EntityItem)items.get(0);
            this.navigateTo((Entity)entityItem, (BlockPos pos) -> job.accept(entityItem));
            return true;
        }
        return false;
    }

    @Override
    public void putInventoryInChest(BlockPos pos) {
        this.putInventoryInChestWithMessage(pos, null, new String[0]);
    }

    private void putInventoryInChestWithMessage(BlockPos pos, String message, String ... parameters) {
        if (!InventoryTools.isInventory(this.entity.func_130014_f_(), pos)) {
            if (message != null) {
                this.showMessage("message.meecreeps.inventory_missing", new String[0]);
            }
            this.entity.dropInventory();
        } else {
            if (message != null) {
                this.showMessage(message, parameters);
            }
            TileEntity te = this.entity.func_130014_f_().func_175625_s(pos);
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            for (ItemStack stack : this.entity.getInventory()) {
                ItemStack remaining;
                if (stack.func_190926_b() || (remaining = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false)).func_190926_b()) continue;
                this.entity.func_70099_a(remaining, 0.0f);
            }
            this.entity.getInventory().clear();
        }
    }

    private void fetchFromInventory(BlockPos pos, Predicate<ItemStack> matcher, int maxAmount) {
        this.materialChest = pos;
        World world = this.entity.func_130014_f_();
        if (!InventoryTools.isInventory(world, pos)) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (maxAmount <= 0) {
                return;
            }
            ItemStack stack = handler.getStackInSlot(i);
            if (stack == null) {
                String badBlock = world.func_180495_p(pos).func_177230_c().getRegistryName().toString();
                MeeCreeps.logger.warn("Block " + badBlock + " is returning null for handler.getStackInSlot()! That's a bug!");
                continue;
            }
            if (stack.func_190926_b() || !matcher.test(stack)) continue;
            ItemStack extracted = handler.extractItem(i, Math.min(maxAmount, stack.func_190916_E()), false);
            ItemStack remaining = this.entity.addStack(extracted);
            maxAmount -= extracted.func_190916_E() - remaining.func_190916_E();
            if (remaining.func_190926_b()) continue;
            handler.insertItem(i, remaining, false);
        }
    }

    private float calculateScore(int countMatching, int countFreeForMatching) {
        return 2.0f * (float)countMatching + (float)countFreeForMatching;
    }

    protected boolean findInventoryContainingMost(List<BlockPos> inventoryList, Predicate<ItemStack> matcher, Consumer<BlockPos> job) {
        World world = this.entity.func_130014_f_();
        ArrayList<BlockPos> inventories = new ArrayList<BlockPos>();
        HashMap<BlockPos, Float> countMatching = new HashMap<BlockPos, Float>();
        for (BlockPos pos : inventoryList) {
            TileEntity te = world.func_175625_s(pos);
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            int cnt = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack == null) {
                    String badBlock = world.func_180495_p(pos).func_177230_c().getRegistryName().toString();
                    MeeCreeps.logger.warn("Block " + badBlock + " is returning null for handler.getStackInSlot()! That's a bug!");
                    continue;
                }
                if (stack.func_190926_b() || !matcher.test(stack)) continue;
                cnt += stack.func_190916_E();
            }
            if (cnt <= 0) continue;
            inventories.add(pos);
            countMatching.put(pos, Float.valueOf(cnt));
        }
        if (inventories.isEmpty()) {
            return false;
        }
        inventories.sort((p1, p2) -> Float.compare(((Float)countMatching.get(p2)).floatValue(), ((Float)countMatching.get(p1)).floatValue()));
        this.navigateTo((BlockPos)inventories.get(0), job);
        return true;
    }

    protected boolean findInventoryContainingMost(AxisAlignedBB box, Predicate<ItemStack> matcher, Consumer<BlockPos> job) {
        World world = this.entity.func_130014_f_();
        ArrayList inventories = new ArrayList();
        HashMap countMatching = new HashMap();
        GeneralTools.traverseBox(world, box, (pos, state) -> InventoryTools.isInventory(world, pos), (pos, state) -> {
            TileEntity te = world.func_175625_s(pos);
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            int cnt = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack == null) {
                    String badBlock = world.func_180495_p(pos).func_177230_c().getRegistryName().toString();
                    MeeCreeps.logger.warn("Block " + badBlock + " is returning null for handler.getStackInSlot()! That's a bug!");
                    continue;
                }
                if (stack.func_190926_b() || !matcher.test(stack)) continue;
                cnt += stack.func_190916_E();
            }
            if (cnt > 0) {
                inventories.add(pos);
                countMatching.put(pos, Float.valueOf(cnt));
            }
        });
        if (inventories.isEmpty()) {
            return false;
        }
        inventories.sort((p1, p2) -> Float.compare(((Float)countMatching.get(p2)).floatValue(), ((Float)countMatching.get(p1)).floatValue()));
        this.navigateTo((BlockPos)inventories.get(0), job);
        return true;
    }

    private boolean findChestToPutItemsIn() {
        block6: for (PreferedChest chest : this.worker.getPreferedChests()) {
            switch (chest) {
                case MARKED: {
                    List<BlockPos> meeCreepChests = this.findMeeCreepChests(this.worker.getSearchBox());
                    if (meeCreepChests.isEmpty()) continue block6;
                    this.navigateTo(meeCreepChests.get(0), (BlockPos p) -> this.putInventoryInChestWithMessage((BlockPos)p, "message.meecreeps.put_stuff_away_marked", new String[0]));
                    return true;
                }
                case TARGET: {
                    BlockPos pos = this.options.getTargetPos();
                    if (!InventoryTools.isInventory(this.entity.func_130014_f_(), pos)) continue block6;
                    this.navigateTo(pos, (BlockPos p) -> this.putInventoryInChestWithMessage((BlockPos)p, "message.meecreeps.put_stuff_away_target", new String[0]));
                    return true;
                }
                case FIND_MATCHING_INVENTORY: {
                    if (!this.findSuitableInventory(this.worker.getSearchBox(), this.entity.getInventoryMatcher(), this::putAwayAndTellPlayerTheDistance)) continue block6;
                    return true;
                }
                case LAST_CHEST: {
                    if (this.materialChest == null || !InventoryTools.isInventory(this.entity.func_130014_f_(), this.materialChest)) continue block6;
                    this.navigateTo(this.materialChest, this::putAwayAndTellPlayerTheDistance);
                    return true;
                }
            }
        }
        return false;
    }

    private void putAwayAndTellPlayerTheDistance(BlockPos p) {
        EntityPlayerMP player = this.getPlayer();
        double dist = 0.0;
        if (player != null) {
            dist = player.func_180425_c().func_185332_f(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
        }
        this.putInventoryInChestWithMessage(p, "message.meecreeps.put_stuff_away_specific", Integer.toString((int)dist));
    }

    protected boolean needToFindChest(boolean timeToWrapUp) {
        return this.needsToPutAway || timeToWrapUp && this.entity.hasStuffInInventory();
    }

    @Override
    public boolean findSuitableInventory(AxisAlignedBB box, Predicate<ItemStack> matcher, Consumer<BlockPos> job) {
        World world = this.entity.func_130014_f_();
        ArrayList inventories = new ArrayList();
        HashMap countMatching = new HashMap();
        GeneralTools.traverseBox(world, box, (pos, state) -> InventoryTools.isInventory(world, pos), (pos, state) -> {
            TileEntity te = world.func_175625_s(pos);
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            if (handler.getSlots() > 8) {
                int cnt = 0;
                int free = 0;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack == null) {
                        String badBlock = world.func_180495_p(pos).func_177230_c().getRegistryName().toString();
                        MeeCreeps.logger.warn("Block " + badBlock + " is returning null for handler.getStackInSlot()! That's a bug!");
                        continue;
                    }
                    if (!stack.func_190926_b()) {
                        if (!matcher.test(stack)) continue;
                        cnt += stack.func_190916_E();
                        free += handler.getSlotLimit(i) - stack.func_190916_E();
                        continue;
                    }
                    free += handler.getSlotLimit(i);
                }
                if (cnt >= 0) {
                    inventories.add(pos);
                    countMatching.put(pos, Float.valueOf(this.calculateScore(cnt, free)));
                }
            }
        });
        if (inventories.isEmpty()) {
            return false;
        }
        inventories.sort((p1, p2) -> Float.compare(((Float)countMatching.get(p2)).floatValue(), ((Float)countMatching.get(p1)).floatValue()));
        this.navigateTo((BlockPos)inventories.get(0), job);
        return true;
    }

    private boolean tryFindingItemsToPickup() {
        BlockPos position = this.entity.func_180425_c();
        List<EntityItem> items = this.itemsToPickup;
        if (!items.isEmpty()) {
            items.sort((o1, o2) -> {
                double d1 = position.func_177954_c(o1.field_70165_t, o1.field_70163_u, o1.field_70161_v);
                double d2 = position.func_177954_c(o2.field_70165_t, o2.field_70163_u, o2.field_70161_v);
                return Double.compare(d1, d2);
            });
            EntityItem entityItem = items.get(0);
            items.remove(0);
            this.navigateTo((Entity)entityItem, (BlockPos p) -> this.pickup(entityItem));
            return true;
        }
        return false;
    }

    boolean isStandable(BlockPos pos) {
        World world = this.entity.getWorld();
        return !world.func_175623_d(pos.func_177977_b()) && world.func_175623_d(pos) && world.func_175623_d(pos.func_177984_a());
    }

    private BlockPos findSuitableSpot(BlockPos pos) {
        if (this.isStandable(pos)) {
            return pos;
        }
        if (this.isStandable(pos.func_177977_b())) {
            return pos.func_177977_b();
        }
        if (this.isStandable(pos.func_177984_a())) {
            return pos.func_177984_a();
        }
        if (this.isStandable(pos.func_177979_c(2))) {
            return pos.func_177979_c(2);
        }
        return null;
    }

    @Override
    public BlockPos findBestNavigationSpot(BlockPos pos) {
        double dw;
        EntityCreature ent = this.entity.getEntity();
        World world = this.entity.getWorld();
        BlockPos spotN = this.findSuitableSpot(pos.func_177978_c());
        BlockPos spotS = this.findSuitableSpot(pos.func_177968_d());
        BlockPos spotW = this.findSuitableSpot(pos.func_177976_e());
        BlockPos spotE = this.findSuitableSpot(pos.func_177974_f());
        double dn = spotN == null ? Double.MAX_VALUE : spotN.func_177957_d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
        double ds = spotS == null ? Double.MAX_VALUE : spotS.func_177957_d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
        double de = spotE == null ? Double.MAX_VALUE : spotE.func_177957_d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
        double d = dw = spotW == null ? Double.MAX_VALUE : spotW.func_177957_d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
        BlockPos p = dn <= ds && dn <= de && dn <= dw ? spotN : (ds <= de && ds <= dw && ds <= dn ? spotS : (de <= dn && de <= dw && de <= ds ? spotE : spotW));
        if (p == null && (p = this.findSuitableSpot(pos)) != null && !world.func_175623_d(p.func_177981_b(2))) {
            p = null;
        }
        return p;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.worker.readFromNBT(tag);
        if (tag.func_74764_b("materialChest")) {
            this.materialChest = BlockPos.func_177969_a((long)tag.func_74763_f("materialChest"));
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        this.worker.writeToNBT(tag);
        if (this.materialChest != null) {
            tag.func_74772_a("materialChest", this.materialChest.func_177986_g());
        }
    }

    static {
        TORCHES.add("minecraft:torch");
        TORCHES.add("tconstruct:stone_torch");
        TORCHES.add("integrateddynamics:menril_torch");
        TORCHES.add("integrateddynamics:menril_torch_stone");
        AIR = new IDesiredBlock(){

            @Override
            public String getName() {
                return "air";
            }

            @Override
            public int getAmount() {
                return 0;
            }

            @Override
            public Predicate<ItemStack> getMatcher() {
                return ItemStack::func_190926_b;
            }

            @Override
            public Predicate<IBlockState> getStateMatcher() {
                return blockState -> blockState.func_177230_c() == Blocks.field_150350_a;
            }
        };
        IGNORE = new IDesiredBlock(){

            @Override
            public String getName() {
                return "IGNORE";
            }

            @Override
            public int getAmount() {
                return 0;
            }

            @Override
            public int getPass() {
                return -1;
            }

            @Override
            public boolean isOptional() {
                return true;
            }

            @Override
            public Predicate<ItemStack> getMatcher() {
                return stack -> false;
            }

            @Override
            public Predicate<IBlockState> getStateMatcher() {
                return blockState -> false;
            }
        };
    }
}

