/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.workers;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.meecreeps.actions.schematics.SchematicPlatform;
import mcjty.meecreeps.actions.workers.AbstractActionWorker;
import mcjty.meecreeps.api.BuildProgress;
import mcjty.meecreeps.api.IBuildSchematic;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.api.IWorkerHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class MakePlatformActionWorker
extends AbstractActionWorker {
    protected IBuildSchematic schematic = null;
    private AxisAlignedBB actionBox = null;
    private BuildProgress progress = new BuildProgress(1, 0);
    private Set<BlockPos> toSkip = new HashSet<BlockPos>();

    public MakePlatformActionWorker(IWorkerHelper helper) {
        super(helper);
    }

    protected IBuildSchematic getSchematic() {
        if (this.schematic == null) {
            String id = this.options.getFurtherQuestionId();
            int size = "9x9".equals(id) ? 9 : ("11x11".equals(id) ? 11 : 13);
            this.schematic = new SchematicPlatform(size, this.helper);
        }
        return this.schematic;
    }

    @Override
    public boolean onlyStopWhenDone() {
        return true;
    }

    @Override
    public void init(IMeeCreep meeCreep) {
        this.helper.setSpeed(5);
    }

    @Override
    @Nullable
    public AxisAlignedBB getActionBox() {
        if (this.actionBox == null) {
            this.actionBox = new AxisAlignedBB(this.options.getTargetPos().func_177982_a(-12, -5, -12), this.options.getTargetPos().func_177982_a(12, 5, 12));
        }
        return this.actionBox;
    }

    @Override
    public void tick(boolean timeToWrapUp) {
        if (timeToWrapUp) {
            this.helper.done();
            return;
        }
        if (!this.helper.handleBuilding(this.getSchematic(), this.progress, this.toSkip)) {
            this.helper.taskIsDone();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.progress.setHeight(tag.func_74762_e("stage"));
        this.progress.setPass(tag.func_74762_e("pass"));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("stage", this.progress.getHeight());
        tag.func_74768_a("pass", this.progress.getPass());
    }
}

