/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.workers;

import mcjty.meecreeps.actions.workers.AbstractActionWorker;
import mcjty.meecreeps.actions.workers.WorkerHelper;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.api.IWorkerHelper;
import mcjty.meecreeps.varia.GeneralTools;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;

public class LightupActionWorker
extends AbstractActionWorker {
    private AxisAlignedBB actionBox = null;

    @Override
    public AxisAlignedBB getActionBox() {
        if (this.actionBox == null) {
            this.actionBox = new AxisAlignedBB(this.options.getTargetPos().func_177982_a(-10, -5, -10), this.options.getTargetPos().func_177982_a(10, 5, 10));
        }
        return this.actionBox;
    }

    public LightupActionWorker(IWorkerHelper helper) {
        super(helper);
    }

    private BlockPos findDarkSpot() {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        AxisAlignedBB box = this.getActionBox();
        return GeneralTools.traverseBoxFirst(box, p -> {
            int light;
            if (world.func_175623_d(p) && WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)world, (BlockPos)p) && (light = world.func_175671_l(p)) < 7) {
                return p;
            }
            return null;
        });
    }

    private void placeTorch(BlockPos pos) {
        ItemStack torch;
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        int light = world.func_175671_l(pos);
        if (light < 7 && !(torch = entity.consumeItem(WorkerHelper::isTorch, 1)).func_190926_b()) {
            this.helper.placeStackAt(torch, world, pos);
        }
    }

    @Override
    public void tick(boolean timeToWrapUp) {
        IMeeCreep entity = this.helper.getMeeCreep();
        if (timeToWrapUp) {
            this.helper.done();
        } else if (!entity.hasItem(WorkerHelper::isTorch)) {
            this.helper.findItemOnGroundOrInChest(WorkerHelper::isTorch, 128, "message.meecreeps.cant_find_torches", new String[0]);
        } else {
            BlockPos darkSpot = this.findDarkSpot();
            if (darkSpot != null) {
                this.helper.navigateTo(darkSpot, this::placeTorch);
            } else {
                this.helper.taskIsDone();
            }
        }
    }
}

