/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.workers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.SoundTools;
import mcjty.meecreeps.actions.workers.HarvestActionWorker;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.api.IWorkerHelper;
import mcjty.meecreeps.varia.GeneralTools;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;

public class HarvestReplantActionWorker
extends HarvestActionWorker {
    private Map<BlockPos, Block> needToReplant = new HashMap<BlockPos, Block>();

    public HarvestReplantActionWorker(IWorkerHelper helper) {
        super(helper);
    }

    private void replant(BlockPos pos) {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        Block block = this.needToReplant.get(pos);
        this.needToReplant.remove(pos);
        for (ItemStack stack : entity.getInventory()) {
            IBlockState plant;
            if (!(stack.func_77973_b() instanceof IPlantable) || (plant = ((IPlantable)stack.func_77973_b()).getPlant((IBlockAccess)world, pos)).func_177230_c() != block) continue;
            stack.func_77979_a(1);
            world.func_175656_a(pos, plant);
            break;
        }
    }

    @Override
    protected void harvest(BlockPos pos) {
        ItemStack seed;
        IBlockState plant;
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        List drops = block.getDrops((IBlockAccess)world, pos, state, 0);
        ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)GeneralTools.getHarvester(world));
        SoundTools.playSound((World)world, (SoundEvent)block.func_185467_w().func_185845_c(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)1.0, (double)1.0);
        world.func_175698_g(pos);
        boolean replanted = false;
        for (ItemStack stack : drops) {
            ItemStack remaining;
            if (!replanted && stack.func_77973_b() instanceof IPlantable && (plant = ((IPlantable)stack.func_77973_b()).getPlant((IBlockAccess)world, pos)).func_177230_c() == state.func_177230_c()) {
                seed = stack.func_77979_a(1);
                world.func_175656_a(pos, plant);
                replanted = true;
            }
            if ((remaining = entity.addStack(stack)).func_190926_b()) continue;
            this.helper.dropAndPutAwayLater(remaining);
        }
        for (ItemStack stack : entity.getInventory()) {
            if (!(stack.func_77973_b() instanceof IPlantable) || (plant = ((IPlantable)stack.func_77973_b()).getPlant((IBlockAccess)world, pos)).func_177230_c() != state.func_177230_c()) continue;
            seed = stack.func_77979_a(1);
            world.func_175656_a(pos, plant);
            replanted = true;
            break;
        }
        if (!replanted) {
            this.needToReplant.put(pos, state.func_177230_c());
        }
    }

    private BlockPos hasSuitableSeed() {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        for (Map.Entry<BlockPos, Block> entry : this.needToReplant.entrySet()) {
            BlockPos pos = entry.getKey();
            Block block = entry.getValue();
            for (ItemStack stack : entity.getInventory()) {
                IBlockState plant;
                if (!(stack.func_77973_b() instanceof IPlantable) || (plant = ((IPlantable)stack.func_77973_b()).getPlant((IBlockAccess)world, pos)).func_177230_c() != block) continue;
                return pos;
            }
        }
        return null;
    }

    @Override
    public void tick(boolean timeToWrapUp) {
        BlockPos pos;
        if (!this.needToReplant.isEmpty() && (pos = this.hasSuitableSeed()) != null) {
            this.helper.navigateTo(pos, this::replant);
        } else if (timeToWrapUp) {
            this.helper.done();
        } else {
            this.tryFindingCropsToHarvest();
        }
    }
}

