/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.workers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.meecreeps.actions.workers.AbstractActionWorker;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.api.IWorkerHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class FlattenAreaActionWorker
extends AbstractActionWorker {
    private int size = 0;
    private Set<BlockPos> positionsToSkip = new HashSet<BlockPos>();

    public FlattenAreaActionWorker(IWorkerHelper helper) {
        super(helper);
    }

    @Override
    public boolean onlyStopWhenDone() {
        return true;
    }

    @Override
    public void init(IMeeCreep meeCreep) {
        this.helper.setSpeed(3);
    }

    @Override
    @Nullable
    public AxisAlignedBB getActionBox() {
        return null;
    }

    private int getSize() {
        if (this.size == 0) {
            String id = this.options.getFurtherQuestionId();
            this.size = "9x9".equals(id) ? 9 : ("11x11".equals(id) ? 11 : 13);
        }
        return this.size;
    }

    private BlockPos findSpotToFlatten() {
        IMeeCreep entity = this.helper.getMeeCreep();
        BlockPos tpos = this.options.getTargetPos();
        int hs = (this.getSize() - 1) / 2;
        ArrayList<BlockPos> todo = new ArrayList<BlockPos>();
        for (int x = -hs; x <= hs; ++x) {
            for (int y = 1; y <= 5; ++y) {
                for (int z = -hs; z <= hs; ++z) {
                    BlockPos relativePos = new BlockPos(x, y, z);
                    BlockPos p = tpos.func_177971_a((Vec3i)relativePos);
                    if (entity.getWorld().func_175623_d(p) || this.positionsToSkip.contains(p)) continue;
                    todo.add(p);
                }
            }
        }
        if (todo.isEmpty()) {
            return null;
        }
        BlockPos position = entity.getEntity().func_180425_c();
        todo.sort((o1, o2) -> {
            double d1 = position.func_177951_i((Vec3i)o1);
            double d2 = position.func_177951_i((Vec3i)o2);
            return Double.compare(d1, d2);
        });
        return (BlockPos)todo.get(0);
    }

    @Override
    public void tick(boolean timeToWrapUp) {
        if (timeToWrapUp) {
            this.helper.done();
            return;
        }
        this.handleFlatten();
    }

    private void handleFlatten() {
        BlockPos flatSpot = this.findSpotToFlatten();
        if (flatSpot == null) {
            this.helper.taskIsDone();
        } else {
            BlockPos navigate = this.helper.findBestNavigationSpot(flatSpot);
            if (navigate != null) {
                this.helper.navigateTo(navigate, p -> this.helper.delayForHardBlocks(flatSpot, pp -> {
                    if (!this.helper.harvestAndDrop(flatSpot)) {
                        this.positionsToSkip.add(flatSpot);
                    }
                }));
            } else {
                this.helper.delayForHardBlocks(flatSpot, pp -> {
                    if (!this.helper.harvestAndDrop(flatSpot)) {
                        this.positionsToSkip.add(flatSpot);
                    }
                });
            }
        }
    }
}

