/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.workers;

import java.util.HashSet;
import java.util.Set;
import mcjty.lib.varia.SoundTools;
import mcjty.meecreeps.actions.workers.AbstractActionWorker;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.api.IWorkerHelper;
import mcjty.meecreeps.varia.GeneralTools;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DigdownActionWorker
extends AbstractActionWorker {
    private AxisAlignedBB actionBox = null;
    private BlockPos supportPosTodo = null;
    private static Set<Block> buildingBlocks = null;

    @Override
    public AxisAlignedBB getActionBox() {
        if (this.actionBox == null) {
            this.actionBox = new AxisAlignedBB(this.options.getTargetPos().func_177982_a(-10, -5, -10), this.options.getTargetPos().func_177982_a(10, 5, 10));
        }
        return this.actionBox;
    }

    public DigdownActionWorker(IWorkerHelper helper) {
        super(helper);
    }

    private boolean isLadder(ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150468_ap);
    }

    private void placeLadder(BlockPos pos) {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        ItemStack ladder = entity.consumeItem(this::isLadder, 1);
        if (!ladder.func_190926_b()) {
            world.func_180501_a(pos, Blocks.field_150468_ap.func_176223_P(), 3);
            SoundTools.playSound((World)world, (SoundEvent)Blocks.field_150468_ap.func_185467_w().func_185841_e(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)1.0, (double)1.0);
        }
    }

    private BlockPos findTopSpotNotDiggedYet() {
        IMeeCreep entity = this.helper.getMeeCreep();
        BlockPos p = this.options.getTargetPos();
        World world = entity.getWorld();
        IBlockState state = world.func_180495_p(p);
        while (p.func_177956_o() > 0 && (world.func_175623_d(p) || state.func_177230_c() == Blocks.field_150468_ap)) {
            p = p.func_177977_b();
            state = world.func_180495_p(p);
        }
        return p;
    }

    private void digDown() {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        BlockPos p = this.findTopSpotNotDiggedYet();
        IBlockState state = world.func_180495_p(p);
        if (p.func_177956_o() < 1 || world.func_175623_d(p) || state.func_177230_c() == Blocks.field_150468_ap) {
            this.helper.taskIsDone();
        } else if (this.helper.allowedToHarvest(state, world, p, (EntityPlayer)GeneralTools.getHarvester(world))) {
            this.helper.delayForHardBlocks(p, pp -> {
                if (this.helper.harvestAndDrop(p)) {
                    this.placeLadder(p);
                } else {
                    this.helper.taskIsDone();
                }
            });
        }
    }

    private boolean needsSupportPillar(BlockPos p) {
        IMeeCreep entity = this.helper.getMeeCreep();
        this.supportPosTodo = null;
        if (p.func_177956_o() < this.options.getTargetPos().func_177956_o()) {
            World world = entity.getWorld();
            for (int y = p.func_177956_o(); y < this.options.getTargetPos().func_177956_o(); ++y) {
                BlockPos test = new BlockPos(p.func_177958_n(), y, p.func_177952_p());
                if (!world.func_175623_d(test.func_177968_d())) continue;
                this.supportPosTodo = test;
                return true;
            }
        }
        return false;
    }

    private void buildSupportBlock(EntityItem entityItem) {
        ItemStack blockStack = entityItem.func_92059_d();
        ItemStack actual = blockStack.func_77979_a(1);
        if (blockStack.func_190926_b()) {
            entityItem.func_70106_y();
        }
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        Block block = ((ItemBlock)actual.func_77973_b()).func_179223_d();
        IBlockState stateForPlacement = block.getStateForPlacement(world, this.supportPosTodo.func_177968_d(), EnumFacing.DOWN, 0.0f, 0.0f, 0.0f, actual.func_77973_b().getMetadata(actual), (EntityLivingBase)GeneralTools.getHarvester(world), EnumHand.MAIN_HAND);
        world.func_180501_a(this.supportPosTodo.func_177968_d(), stateForPlacement, 3);
        this.placeLadder(this.supportPosTodo);
        this.supportPosTodo = null;
    }

    private static boolean isBuildingBlock(Block block) {
        if (buildingBlocks == null) {
            HashSet<Block> b = new HashSet<Block>();
            b.add(Blocks.field_150348_b);
            b.add(Blocks.field_150347_e);
            b.add(Blocks.field_150346_d);
            b.add(Blocks.field_150322_A);
            b.add(Blocks.field_150424_aL);
            b.add(Blocks.field_150385_bj);
            b.add(Blocks.field_150377_bs);
            b.add(Blocks.field_180395_cM);
            b.add(Blocks.field_185767_cT);
            buildingBlocks = b;
        }
        return buildingBlocks.contains(block);
    }

    private boolean isBuildingBlock(ItemStack stack) {
        ItemBlock itemBlock;
        Item item;
        return !stack.func_190926_b() && (item = stack.func_77973_b()) instanceof ItemBlock && DigdownActionWorker.isBuildingBlock((itemBlock = (ItemBlock)item).func_179223_d());
    }

    @Override
    public void tick(boolean timeToWrapUp) {
        IMeeCreep entity = this.helper.getMeeCreep();
        if (this.supportPosTodo != null && !this.helper.findItemOnGround(new AxisAlignedBB(entity.getEntity().func_180425_c().func_177982_a(-3, -3, -3), entity.getEntity().func_180425_c().func_177982_a(3, 3, 3)), this::isBuildingBlock, this::buildSupportBlock) && timeToWrapUp) {
            this.helper.done();
            return;
        }
        if (timeToWrapUp && this.supportPosTodo == null) {
            this.helper.done();
        } else if (!entity.hasItem(this::isLadder)) {
            this.helper.findItemOnGroundOrInChest(this::isLadder, 128, "message.meecreeps.cant_find_ladders", new String[0]);
        } else {
            BlockPos p = this.findTopSpotNotDiggedYet();
            if (!this.needsSupportPillar(p)) {
                this.helper.navigateTo(p, blockPos -> this.digDown());
            }
        }
    }
}

