/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.workers;

import java.util.HashSet;
import java.util.Set;
import mcjty.lib.varia.SoundTools;
import mcjty.meecreeps.actions.workers.AbstractActionWorker;
import mcjty.meecreeps.actions.workers.WorkerHelper;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.api.IWorkerHelper;
import mcjty.meecreeps.varia.GeneralTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DigTunnelActionWorker
extends AbstractActionWorker {
    private AxisAlignedBB actionBox = null;
    private int offset = 0;
    private int blockidx = 0;
    private int torchChecker = 40;
    private Set<BlockPos> positionsToSkip = new HashSet<BlockPos>();
    private static Set<Block> notInterestedInBlocks = null;

    public DigTunnelActionWorker(IWorkerHelper helper) {
        super(helper);
    }

    @Override
    public void init(IMeeCreep meeCreep) {
        this.helper.setSpeed(5);
    }

    @Override
    public boolean onlyStopWhenDone() {
        return true;
    }

    @Override
    public AxisAlignedBB getActionBox() {
        if (this.actionBox == null) {
            this.actionBox = new AxisAlignedBB(this.options.getTargetPos().func_177982_a(-20, -5, -20), this.options.getTargetPos().func_177982_a(20, 5, 20));
        }
        return this.actionBox;
    }

    public static boolean isNotInterestedIn(Block block) {
        if (notInterestedInBlocks == null) {
            HashSet<Block> b = new HashSet<Block>();
            b.add(Blocks.field_150348_b);
            b.add(Blocks.field_150347_e);
            b.add(Blocks.field_150346_d);
            b.add(Blocks.field_150322_A);
            b.add(Blocks.field_150424_aL);
            b.add(Blocks.field_150385_bj);
            b.add(Blocks.field_150377_bs);
            b.add(Blocks.field_180395_cM);
            b.add(Blocks.field_185767_cT);
            notInterestedInBlocks = b;
        }
        return notInterestedInBlocks.contains(block);
    }

    private boolean isSupportBlock(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlock ? DigTunnelActionWorker.isNotInterestedIn(((ItemBlock)stack.func_77973_b()).func_179223_d()) : false;
    }

    private void dig(BlockPos p) {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        IBlockState state = world.func_180495_p(p);
        boolean result = DigTunnelActionWorker.isNotInterestedIn(state.func_177230_c()) ? this.helper.harvestAndDrop(p) : this.helper.harvestAndPickup(p);
        if (!result) {
            this.positionsToSkip.add(p);
        }
    }

    private BlockPos getBlockToDig(BlockPos p, EnumFacing facing, int blockidx) {
        switch (blockidx) {
            case 0: {
                return p.func_177981_b(1).func_177972_a(facing.func_176746_e());
            }
            case 1: {
                return p.func_177981_b(1);
            }
            case 2: {
                return p.func_177981_b(1).func_177972_a(facing.func_176735_f());
            }
            case 3: {
                return p.func_177972_a(facing.func_176746_e());
            }
            case 4: {
                return p;
            }
            case 5: {
                return p.func_177972_a(facing.func_176735_f());
            }
            case 6: {
                return p.func_177979_c(1).func_177972_a(facing.func_176735_f());
            }
            case 7: {
                return p.func_177979_c(1);
            }
            case 8: {
                return p.func_177979_c(1).func_177972_a(facing.func_176746_e());
            }
        }
        return p;
    }

    private void buildSupport(BlockPos pos, EntityItem entityItem) {
        ItemStack blockStack = entityItem.func_92059_d();
        ItemStack actual = blockStack.func_77979_a(1);
        if (blockStack.func_190926_b()) {
            entityItem.func_70106_y();
        }
        if (actual.func_190926_b()) {
            return;
        }
        Item item = actual.func_77973_b();
        if (!(item instanceof ItemBlock)) {
            return;
        }
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        Block block = ((ItemBlock)item).func_179223_d();
        IBlockState stateForPlacement = block.getStateForPlacement(world, pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f, item.getMetadata(actual), (EntityLivingBase)GeneralTools.getHarvester(world), EnumHand.MAIN_HAND);
        world.func_180501_a(pos, stateForPlacement, 3);
        SoundTools.playSound((World)world, (SoundEvent)block.func_185467_w().func_185841_e(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)1.0, (double)1.0);
    }

    private void placeTorch(BlockPos pos) {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        ItemStack torch = entity.consumeItem(WorkerHelper::isTorch, 1);
        if (!torch.func_190926_b()) {
            this.helper.placeStackAt(torch, world, pos);
        }
    }

    @Override
    public void tick(boolean timeToWrapUp) {
        BlockPos p;
        EnumFacing facing;
        IMeeCreep entity = this.helper.getMeeCreep();
        if (timeToWrapUp) {
            this.helper.done();
            return;
        }
        --this.torchChecker;
        if (this.torchChecker <= 0) {
            this.torchChecker = 40;
            if (!entity.hasItem(WorkerHelper::isTorch) && this.helper.findItemOnGroundOrInChest(WorkerHelper::isTorch, 64)) {
                return;
            }
        }
        if (this.checkSupports(facing = this.helper.getContext().getTargetSide().func_176734_d(), p = this.helper.getContext().getTargetPos().func_177984_a().func_177967_a(facing, this.offset))) {
            return;
        }
        BlockPos torchPos = p.func_177977_b().func_177972_a(facing.func_176734_d());
        if (this.offset % 7 == 0 && !WorkerHelper.isTorch(entity.getWorld().func_180495_p(torchPos).func_177230_c()) && entity.hasItem(WorkerHelper::isTorch)) {
            this.placeTorch(torchPos);
        }
        BlockPos digpos = this.getBlockToDig(p, facing, this.blockidx);
        this.helper.navigateTo(p.func_177972_a(facing.func_176734_d()), blockPos -> this.helper.delayForHardBlocks(digpos, pp -> this.dig(digpos)));
        ++this.blockidx;
        if (this.blockidx >= 9) {
            if (this.checkClear(p, facing)) {
                ++this.offset;
                this.blockidx = 0;
                if (this.offset >= 32) {
                    this.helper.taskIsDone();
                }
            } else {
                this.blockidx = 0;
            }
        }
    }

    private boolean checkClear(BlockPos p, EnumFacing facing) {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        if (this.canDig(p, world)) {
            return false;
        }
        if (this.canDig(p.func_177972_a(facing.func_176746_e()), world)) {
            return false;
        }
        if (this.canDig(p.func_177972_a(facing.func_176735_f()), world)) {
            return false;
        }
        if (this.canDig(p.func_177984_a(), world)) {
            return false;
        }
        if (this.canDig(p.func_177984_a().func_177972_a(facing.func_176746_e()), world)) {
            return false;
        }
        if (this.canDig(p.func_177984_a().func_177972_a(facing.func_176735_f()), world)) {
            return false;
        }
        if (this.canDig(p.func_177977_b(), world)) {
            return false;
        }
        if (this.canDig(p.func_177977_b().func_177972_a(facing.func_176746_e()), world)) {
            return false;
        }
        return !this.canDig(p.func_177977_b().func_177972_a(facing.func_176735_f()), world);
    }

    private boolean canDig(BlockPos p, World world) {
        return !world.func_175623_d(p) && !this.positionsToSkip.contains(p);
    }

    private boolean checkSupports(EnumFacing facing, BlockPos p) {
        if (this.checkForSupport(p.func_177979_c(2))) {
            return true;
        }
        if (this.checkForSupport(p.func_177979_c(2).func_177972_a(facing.func_176746_e()))) {
            return true;
        }
        if (this.checkForSupport(p.func_177979_c(2).func_177972_a(facing.func_176735_f()))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177979_c(1).func_177967_a(facing.func_176746_e(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177967_a(facing.func_176746_e(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177981_b(1).func_177967_a(facing.func_176746_e(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177979_c(1).func_177967_a(facing.func_176735_f(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177967_a(facing.func_176735_f(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177981_b(1).func_177967_a(facing.func_176735_f(), 2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177981_b(2))) {
            return true;
        }
        if (this.checkForLiquid(p.func_177981_b(2).func_177972_a(facing.func_176746_e()))) {
            return true;
        }
        return this.checkForLiquid(p.func_177981_b(2).func_177972_a(facing.func_176735_f()));
    }

    private boolean checkForSupport(BlockPos p) {
        IMeeCreep entity = this.helper.getMeeCreep();
        if (entity.getWorld().func_175623_d(p) || this.isLiquid(p)) {
            if (!this.helper.findItemOnGround(this.getSearchBox(), this::isSupportBlock, entityItem -> this.buildSupport(p, (EntityItem)entityItem))) {
                this.helper.showMessage("message.meecreeps.cant_continue", new String[0]);
                this.helper.taskIsDone();
            }
            return true;
        }
        return false;
    }

    private boolean checkForLiquid(BlockPos p) {
        if (this.isLiquid(p)) {
            if (!this.helper.findItemOnGround(this.getSearchBox(), this::isSupportBlock, entityItem -> this.buildSupport(p, (EntityItem)entityItem))) {
                this.helper.showMessage("message.meecreeps.cant_continue", new String[0]);
                this.helper.taskIsDone();
            }
            return true;
        }
        return false;
    }

    private boolean isLiquid(BlockPos p) {
        IMeeCreep entity = this.helper.getMeeCreep();
        Block block = entity.getWorld().func_180495_p(p).func_177230_c();
        return block instanceof BlockLiquid || block instanceof BlockDynamicLiquid || block instanceof BlockStaticLiquid;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.offset = tag.func_74762_e("offset");
        this.blockidx = tag.func_74762_e("blockidx");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("offset", this.offset);
        tag.func_74768_a("blockidx", this.blockidx);
    }
}

