/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.schematics;

import java.util.function.Predicate;
import mcjty.meecreeps.actions.workers.WorkerHelper;
import mcjty.meecreeps.api.IBuildSchematic;
import mcjty.meecreeps.api.IDesiredBlock;
import mcjty.meecreeps.api.IWorkerHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class SchematicHouse
implements IBuildSchematic {
    private final int size;
    private final IWorkerHelper helper;
    private static final IDesiredBlock COBBLE = new IDesiredBlock(){

        @Override
        public String getName() {
            return "cobblestone";
        }

        @Override
        public int getAmount() {
            return 128;
        }

        @Override
        public Predicate<ItemStack> getMatcher() {
            return stack -> stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150347_e);
        }

        @Override
        public Predicate<IBlockState> getStateMatcher() {
            return blockState -> blockState.func_177230_c() == Blocks.field_150347_e;
        }
    };
    private static final IDesiredBlock GLASS = new IDesiredBlock(){

        @Override
        public String getName() {
            return "glass";
        }

        @Override
        public int getAmount() {
            return 64;
        }

        @Override
        public Predicate<ItemStack> getMatcher() {
            return stack -> stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150359_w);
        }

        @Override
        public Predicate<IBlockState> getStateMatcher() {
            return blockState -> blockState.func_177230_c() instanceof BlockGlass;
        }
    };
    private static final IDesiredBlock DOOR = new IDesiredBlock(){

        @Override
        public String getName() {
            return "door";
        }

        @Override
        public int getAmount() {
            return 1;
        }

        @Override
        public int getPass() {
            return 1;
        }

        @Override
        public boolean isOptional() {
            return true;
        }

        @Override
        public Predicate<ItemStack> getMatcher() {
            return stack -> stack.func_77973_b() instanceof ItemDoor;
        }

        @Override
        public Predicate<IBlockState> getStateMatcher() {
            return blockState -> blockState.func_177230_c() instanceof BlockDoor;
        }
    };
    private static final IDesiredBlock DOORTOP = new IDesiredBlock(){

        @Override
        public String getName() {
            return "door";
        }

        @Override
        public int getAmount() {
            return 0;
        }

        @Override
        public int getPass() {
            return 1;
        }

        @Override
        public boolean isOptional() {
            return true;
        }

        @Override
        public Predicate<ItemStack> getMatcher() {
            return stack -> false;
        }

        @Override
        public Predicate<IBlockState> getStateMatcher() {
            return blockState -> blockState.func_177230_c() instanceof BlockDoor;
        }
    };
    private static final IDesiredBlock TORCH = new IDesiredBlock(){

        @Override
        public String getName() {
            return "torch";
        }

        @Override
        public int getAmount() {
            return 4;
        }

        @Override
        public boolean isOptional() {
            return true;
        }

        @Override
        public int getPass() {
            return 1;
        }

        @Override
        public Predicate<ItemStack> getMatcher() {
            return stack -> WorkerHelper.isTorch(stack);
        }

        @Override
        public Predicate<IBlockState> getStateMatcher() {
            return blockState -> WorkerHelper.isTorch(blockState.func_177230_c());
        }
    };

    public SchematicHouse(int size, IWorkerHelper helper) {
        this.size = size;
        this.helper = helper;
    }

    @Override
    public BlockPos getMinPos() {
        return new BlockPos(-this.size / 2, 1, -this.size / 2);
    }

    @Override
    public BlockPos getMaxPos() {
        return new BlockPos(this.size / 2, 5, this.size / 2);
    }

    private boolean isBorderPos(BlockPos relativePos, int hs) {
        return relativePos.func_177958_n() <= -hs || relativePos.func_177958_n() >= hs || relativePos.func_177952_p() <= -hs || relativePos.func_177952_p() >= hs;
    }

    private boolean isDoorPos(BlockPos relativePos, int hs) {
        return relativePos.func_177952_p() == 0 && relativePos.func_177958_n() == hs;
    }

    private boolean isGlassPos(BlockPos relativePos, int hs) {
        return relativePos.func_177958_n() != 0 && relativePos.func_177952_p() != 0 && Math.abs(relativePos.func_177958_n()) < hs - 1 && Math.abs(relativePos.func_177952_p()) < hs - 1;
    }

    private boolean isTorchPos(BlockPos relativePos, int hs) {
        if (relativePos.func_177952_p() == 0 && (relativePos.func_177958_n() == hs - 1 || relativePos.func_177958_n() == -hs + 1)) {
            return true;
        }
        return relativePos.func_177958_n() == 0 && (relativePos.func_177952_p() == hs - 1 || relativePos.func_177952_p() == -hs + 1);
    }

    @Override
    public IDesiredBlock getDesiredBlock(BlockPos relativePos) {
        int hs = (this.size - 1) / 2;
        IDesiredBlock air = this.helper.getAirBlock();
        IDesiredBlock ignore = this.helper.getIgnoreBlock();
        switch (relativePos.func_177956_o()) {
            case 1: {
                if (this.isDoorPos(relativePos, hs)) {
                    return DOOR;
                }
                if (this.isBorderPos(relativePos, hs)) {
                    return COBBLE;
                }
                return ignore;
            }
            case 2: {
                if (this.isDoorPos(relativePos, hs)) {
                    return DOORTOP;
                }
                if (this.isBorderPos(relativePos, hs)) {
                    return COBBLE;
                }
                return ignore;
            }
            case 3: {
                if (this.isTorchPos(relativePos, hs)) {
                    return TORCH;
                }
                if (this.isBorderPos(relativePos, hs)) {
                    return COBBLE;
                }
                return ignore;
            }
            case 4: {
                if (this.isBorderPos(relativePos, hs)) {
                    return COBBLE;
                }
                return ignore;
            }
            case 5: {
                if (this.isGlassPos(relativePos, hs)) {
                    return GLASS;
                }
                return COBBLE;
            }
        }
        return air;
    }
}

