/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.factories;

import javax.annotation.Nonnull;
import mcjty.meecreeps.actions.workers.HarvestReplantActionWorker;
import mcjty.meecreeps.api.IActionFactory;
import mcjty.meecreeps.api.IActionWorker;
import mcjty.meecreeps.api.IWorkerHelper;
import mcjty.meecreeps.varia.InventoryTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class HarvestReplantActionFactory
implements IActionFactory {
    @Override
    public boolean isPossible(World world, BlockPos pos, EnumFacing side) {
        if (!InventoryTools.isInventory(world, pos)) {
            return false;
        }
        AxisAlignedBB box = new AxisAlignedBB(pos.func_177982_a(-10, -5, -10), pos.func_177982_a(10, 5, 10));
        for (double x = box.field_72340_a; x <= box.field_72336_d; x += 1.0) {
            for (double y = box.field_72338_b; y <= box.field_72337_e; y += 1.0) {
                for (double z = box.field_72339_c; z <= box.field_72334_f; z += 1.0) {
                    int maxAge;
                    int age;
                    boolean hasCrops;
                    BlockPos p = new BlockPos(x, y, z);
                    IBlockState state = world.func_180495_p(p);
                    if (state.func_177230_c() != Blocks.field_150458_ak) continue;
                    IBlockState cropState = world.func_180495_p(p.func_177984_a());
                    Block cropBlock = cropState.func_177230_c();
                    boolean bl = hasCrops = cropBlock instanceof IPlantable && state.func_177230_c().canSustainPlant(world.func_180495_p(p), (IBlockAccess)world, p, EnumFacing.UP, (IPlantable)cropBlock);
                    if (!hasCrops) continue;
                    if (cropBlock instanceof BlockCrops) {
                        BlockCrops crops = (BlockCrops)cropBlock;
                        age = crops.func_185527_x(cropState);
                        if (age < (maxAge = crops.func_185526_g())) continue;
                        return true;
                    }
                    if (!(cropBlock instanceof BlockNetherWart)) continue;
                    BlockNetherWart wart = (BlockNetherWart)cropBlock;
                    age = (Integer)cropState.func_177229_b((IProperty)BlockNetherWart.field_176486_a);
                    if (age < (maxAge = 3)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isPossibleSecondary(World world, BlockPos pos, EnumFacing side) {
        if (!InventoryTools.isInventory(world, pos)) {
            return false;
        }
        AxisAlignedBB box = new AxisAlignedBB(pos.func_177982_a(-10, -5, -10), pos.func_177982_a(10, 5, 10));
        for (double x = box.field_72340_a; x <= box.field_72336_d; x += 1.0) {
            for (double y = box.field_72338_b; y <= box.field_72337_e; y += 1.0) {
                for (double z = box.field_72339_c; z <= box.field_72334_f; z += 1.0) {
                    boolean hasCrops;
                    BlockPos p = new BlockPos(x, y, z);
                    IBlockState state = world.func_180495_p(p);
                    if (state.func_177230_c() != Blocks.field_150458_ak) continue;
                    IBlockState cropState = world.func_180495_p(p.func_177984_a());
                    Block cropBlock = cropState.func_177230_c();
                    boolean bl = hasCrops = cropBlock instanceof IPlantable && state.func_177230_c().canSustainPlant(world.func_180495_p(p), (IBlockAccess)world, p, EnumFacing.UP, (IPlantable)cropBlock);
                    if (!hasCrops) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public IActionWorker createWorker(@Nonnull IWorkerHelper helper) {
        return new HarvestReplantActionWorker(helper);
    }
}

