/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.meecreeps.MeeCreeps;
import mcjty.meecreeps.actions.ClientActionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketShowBalloonToClient
implements IMessage {
    private String message;
    private String[] parameters;

    public void fromBytes(ByteBuf buf) {
        this.message = NetworkTools.readStringUTF8((ByteBuf)buf);
        int size = buf.readInt();
        this.parameters = new String[size];
        for (int i = 0; i < size; ++i) {
            this.parameters[i] = NetworkTools.readStringUTF8((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeStringUTF8((ByteBuf)buf, (String)this.message);
        if (this.parameters != null) {
            buf.writeInt(this.parameters.length);
            for (String s : this.parameters) {
                NetworkTools.writeStringUTF8((ByteBuf)buf, (String)s);
            }
        } else {
            buf.writeInt(0);
        }
    }

    public PacketShowBalloonToClient() {
    }

    public PacketShowBalloonToClient(String message, String ... parameters) {
        this.message = message;
        this.parameters = parameters;
    }

    public static class Handler
    implements IMessageHandler<PacketShowBalloonToClient, IMessage> {
        public IMessage onMessage(PacketShowBalloonToClient message, MessageContext ctx) {
            MeeCreeps.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketShowBalloonToClient message, MessageContext ctx) {
            ClientActionManager.showProblem(message.message, message.parameters);
        }
    }
}

