/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.meecreeps.actions.ActionOptions;
import mcjty.meecreeps.actions.MeeCreepActionType;
import mcjty.meecreeps.actions.ServerActionManager;
import mcjty.meecreeps.actions.factories.AngryActionFactory;
import mcjty.meecreeps.actions.factories.ChopTreeActionFactory;
import mcjty.meecreeps.actions.factories.ChopTreeAndCollectActionFactory;
import mcjty.meecreeps.actions.factories.DigTunnelActionFactory;
import mcjty.meecreeps.actions.factories.DigdownActionFactory;
import mcjty.meecreeps.actions.factories.DigdownStairsActionFactory;
import mcjty.meecreeps.actions.factories.FlattenAreaActionFactory;
import mcjty.meecreeps.actions.factories.FollowAndLightupActionFactory;
import mcjty.meecreeps.actions.factories.FollowAndPickupActionFactory;
import mcjty.meecreeps.actions.factories.HarvestActionFactory;
import mcjty.meecreeps.actions.factories.HarvestReplantActionFactory;
import mcjty.meecreeps.actions.factories.IdleActionFactory;
import mcjty.meecreeps.actions.factories.LightupActionFactory;
import mcjty.meecreeps.actions.factories.MakeHouseActionFactory;
import mcjty.meecreeps.actions.factories.MakePlatformActionFactory;
import mcjty.meecreeps.actions.factories.MineOresActionFactory;
import mcjty.meecreeps.actions.factories.MoveStuffActionFactory;
import mcjty.meecreeps.actions.factories.PickupActionFactory;
import mcjty.meecreeps.api.IActionFactory;
import mcjty.meecreeps.api.IMeeCreepsApi;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MeeCreepsApi
implements IMeeCreepsApi {
    private List<Factory> factories = new ArrayList<Factory>();
    private Map<MeeCreepActionType, Factory> factoryMap = new HashMap<MeeCreepActionType, Factory>();

    @Override
    public void registerActionFactory(String id, String message, IActionFactory factory) {
        Factory fact = new Factory(id, message, factory);
        this.factories.add(fact);
        this.factoryMap.put(new MeeCreepActionType(id), fact);
    }

    @Override
    public boolean spawnMeeCreep(String id, String furtherQuestionId, World world, BlockPos targetPos, EnumFacing targetSide, @Nullable EntityPlayerMP player, boolean doSound) {
        ServerActionManager manager = ServerActionManager.getManager();
        int actionId = manager.createActionOptions(world, targetPos, targetSide, (EntityPlayer)player);
        ActionOptions.spawn(world, targetPos, targetSide, actionId, doSound);
        manager.performAction(player, actionId, new MeeCreepActionType(id), furtherQuestionId);
        return true;
    }

    public List<Factory> getFactories() {
        return this.factories;
    }

    public Factory getFactory(MeeCreepActionType id) {
        return this.factoryMap.get(id);
    }

    public void registerFactories() {
        this.registerActionFactory("meecreeps.make_house", "message.meecreeps.action.make_house", new MakeHouseActionFactory());
        this.registerActionFactory("meecreeps.make_platform", "message.meecreeps.action.make_platform", new MakePlatformActionFactory());
        this.registerActionFactory("meecreeps.flatten_area", "message.meecreeps.action.flatten_area", new FlattenAreaActionFactory());
        this.registerActionFactory("meecreeps.chop_tree", "message.meecreeps.action.chop_tree", new ChopTreeActionFactory());
        this.registerActionFactory("meecreeps.chop_tree_collect", "message.meecreeps.action.chop_tree_collect", new ChopTreeAndCollectActionFactory());
        this.registerActionFactory("meecreeps.dig_down", "message.meecreeps.action.dig_down", new DigdownActionFactory());
        this.registerActionFactory("meecreeps.dig_down_stairs", "message.meecreeps.action.dig_down_stairs", new DigdownStairsActionFactory());
        this.registerActionFactory("meecreeps.mine_ores", "message.meecreeps.action.mine_ores", new MineOresActionFactory());
        this.registerActionFactory("meecreeps.dig_tunnel", "message.meecreeps.action.dig_tunnel", new DigTunnelActionFactory());
        this.registerActionFactory("meecreeps.harvest_replant", "message.meecreeps.action.harvest_replant", new HarvestReplantActionFactory());
        this.registerActionFactory("meecreeps.harvest", "message.meecreeps.action.harvest", new HarvestActionFactory());
        this.registerActionFactory("meecreeps.torches", "message.meecreeps.action.torches", new LightupActionFactory());
        this.registerActionFactory("meecreeps.follow_and_lightup", "message.meecreeps.action.follow_and_lightup", new FollowAndLightupActionFactory());
        this.registerActionFactory("meecreeps.pickup", "message.meecreeps.action.pickup", new PickupActionFactory());
        this.registerActionFactory("meecreeps.follow_and_pickup", "message.meecreeps.action.follow_and_pickup", new FollowAndPickupActionFactory());
        this.registerActionFactory("meecreeps.move_stuff", "message.meecreeps.action.move_stuff", new MoveStuffActionFactory());
        this.registerActionFactory("meecreeps.idle", "message.meecreeps.action.idle", new IdleActionFactory());
        this.registerActionFactory("meecreeps.angry", "message.meecreeps.action.angry", new AngryActionFactory());
    }

    public static class Factory {
        private final String id;
        private final String message;
        private final IActionFactory factory;

        public Factory(String id, String message, IActionFactory factory) {
            this.id = id;
            this.message = message;
            this.factory = factory;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            return this.message;
        }

        public IActionFactory getFactory() {
            return this.factory;
        }
    }
}

