/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import squeek.appleskin.helpers.HungerHelper;
import squeek.appleskin.network.MessageExhaustionSync;
import squeek.appleskin.network.MessageSaturationSync;

public class SyncHandler {
    public static final SimpleNetworkWrapper CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("appleskin");
    private static final Map<UUID, Float> lastSaturationLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> lastExhaustionLevels = new HashMap<UUID, Float>();

    public static void init() {
        CHANNEL.registerMessage(MessageExhaustionSync.class, MessageExhaustionSync.class, 1, Side.CLIENT);
        CHANNEL.registerMessage(MessageSaturationSync.class, MessageSaturationSync.class, 2, Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)new SyncHandler());
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        Float lastSaturationLevel = lastSaturationLevels.get(player.func_110124_au());
        Float lastExhaustionLevel = lastExhaustionLevels.get(player.func_110124_au());
        if (lastSaturationLevel == null || lastSaturationLevel.floatValue() != player.func_71024_bL().func_75115_e()) {
            CHANNEL.sendTo((IMessage)new MessageSaturationSync(player.func_71024_bL().func_75115_e()), player);
            lastSaturationLevels.put(player.func_110124_au(), Float.valueOf(player.func_71024_bL().func_75115_e()));
        }
        float exhaustionLevel = HungerHelper.getExhaustion((EntityPlayer)player);
        if (lastExhaustionLevel == null || Math.abs(lastExhaustionLevel.floatValue() - exhaustionLevel) >= 0.01f) {
            CHANNEL.sendTo((IMessage)new MessageExhaustionSync(exhaustionLevel), player);
            lastExhaustionLevels.put(player.func_110124_au(), Float.valueOf(exhaustionLevel));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        lastSaturationLevels.remove(event.player.func_110124_au());
        lastExhaustionLevels.remove(event.player.func_110124_au());
    }
}

