/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.handler.PlayerMorphHandler;
import me.ichun.mods.morph.common.morph.MorphVariant;
import me.ichun.mods.morph.common.packet.PacketUpdateMorphList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class PacketGuiInput
extends AbstractPacket {
    public String identifier;
    public int id;
    public boolean flag;

    public PacketGuiInput() {
    }

    public PacketGuiInput(String ident, int id, boolean flag) {
        this.identifier = ident;
        this.id = id;
        this.flag = flag;
    }

    public void writeTo(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.identifier);
        buffer.writeInt(this.id);
        buffer.writeBoolean(this.flag);
    }

    public void readFrom(ByteBuf buffer) {
        this.identifier = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.id = buffer.readInt();
        this.flag = buffer.readBoolean();
    }

    public void execute(Side side, EntityPlayer player) {
        ArrayList<MorphVariant> morphs = Morph.eventHandlerServer.getPlayerMorphs(player);
        boolean found = false;
        for (int i = morphs.size() - 1; i >= 0; --i) {
            MorphVariant variant = morphs.get(i);
            MorphVariant.Variant var = variant.getVariantByIdentifier(this.identifier);
            if (var == null) continue;
            found = true;
            switch (this.id) {
                case 0: {
                    PlayerMorphHandler.getInstance().morphPlayer(player, variant.createWithVariant(var));
                    break;
                }
                case 1: {
                    var.isFavourite = this.flag;
                    break;
                }
                case 2: {
                    found = false;
                    if (!variant.deleteVariant(var)) break;
                    morphs.remove(i);
                }
            }
            PlayerMorphHandler.getInstance().savePlayerData(player);
            break;
        }
        if (!found) {
            Morph.channel.sendTo((AbstractPacket)new PacketUpdateMorphList(true, morphs.toArray(new MorphVariant[morphs.size()])), player);
        }
    }

    public Side receivingSide() {
        return Side.SERVER;
    }
}

