/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.command;

import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.morph.api.event.MorphAcquiredEvent;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.handler.PlayerMorphHandler;
import me.ichun.mods.morph.common.morph.MorphVariant;
import me.ichun.mods.morph.common.packet.PacketUpdateMorphList;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CommandMorph
extends CommandBase {
    public final Style TEXT_GRAY = new Style().func_150238_a(TextFormatting.GRAY);
    public final ArrayList<String> entityNames = new ArrayList();

    public String func_71517_b() {
        return "morph";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " help";
    }

    public int func_82362_a() {
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player;
        block64: {
            if (args.length <= 0) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            if (args[0].equalsIgnoreCase("help")) {
                sender.func_145747_a(new TextComponentTranslation("morph.command.analyse", new Object[0]).func_150255_a(this.TEXT_GRAY));
                sender.func_145747_a(new TextComponentTranslation("morph.command.demorph", new Object[0]).func_150255_a(this.TEXT_GRAY));
                sender.func_145747_a(new TextComponentTranslation("morph.command.clean", new Object[0]).func_150255_a(this.TEXT_GRAY));
                sender.func_145747_a(new TextComponentTranslation("morph.command.remove", new Object[0]).func_150255_a(this.TEXT_GRAY));
                sender.func_145747_a(new TextComponentTranslation("morph.command.clear", new Object[0]).func_150255_a(this.TEXT_GRAY));
                sender.func_145747_a(new TextComponentTranslation("morph.command.morph", new Object[0]).func_150255_a(this.TEXT_GRAY));
                sender.func_145747_a(new TextComponentTranslation("morph.command.give", new Object[0]).func_150255_a(this.TEXT_GRAY));
                return;
            }
            player = null;
            boolean force = !(!args[0].equalsIgnoreCase("demorph") && !args[0].equalsIgnoreCase("clear") || args.length != 3 || !args[2].equalsIgnoreCase("force") && !args[2].equalsIgnoreCase("true"));
            try {
                player = args.length == 1 ? CommandMorph.func_71521_c((ICommandSender)sender) : CommandMorph.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
            }
            catch (PlayerNotFoundException e) {
                if (force) break block64;
                throw e;
            }
        }
        if (player == null) {
            EntityPlayerMP player1 = new EntityPlayerMP(FMLCommonHandler.instance().getMinecraftServerInstance(), DimensionManager.getWorld((int)0), EntityHelper.getGameProfile((String)args[1]), new PlayerInteractionManager((World)DimensionManager.getWorld((int)0)));
            FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72380_a(player1);
            NBTTagCompound tag = EntityHelper.getPlayerPersistentData((EntityPlayer)player1, (String)"MorphSave");
            boolean changed = false;
            if (args[0].equalsIgnoreCase("demorph") && tag.func_74764_b("currentMorph")) {
                tag.func_82580_o("currentMorph");
                changed = true;
            }
            if (args[0].equalsIgnoreCase("clear") && tag.func_74764_b("variantCount")) {
                tag.func_82580_o("variantCount");
                int i = 0;
                while (tag.func_74764_b("variant_" + i)) {
                    tag.func_82580_o("variant_" + i);
                    ++i;
                }
                changed = true;
            }
            if (changed) {
                FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v().add(player1);
                FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72389_g();
                FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v().remove(player1);
                CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.successfulForce", (Object[])new Object[]{player1.func_70005_c_()});
                return;
            } else {
                CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.playerNotFoundForcedNoTagsChanged", (Object[])new Object[]{player1.func_70005_c_()});
            }
            return;
        } else if (args[0].equalsIgnoreCase("demorph")) {
            if (PlayerMorphHandler.getInstance().forceDemorph(player)) {
                PlayerMorphHandler.getInstance().savePlayerData((EntityPlayer)player);
                CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.forcingDemorph", (Object[])new Object[]{player.func_70005_c_()});
                return;
            } else {
                CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.notInMorph", (Object[])new Object[]{player.func_70005_c_()});
            }
            return;
        } else if (args[0].equalsIgnoreCase("clean")) {
            PlayerMorphHandler.getInstance().forceDemorph(player);
            ArrayList<MorphVariant> morphs = Morph.eventHandlerServer.playerMorphs.get(player.func_70005_c_());
            if (morphs != null && !morphs.isEmpty()) {
                Morph.eventHandlerServer.playerMorphs.remove(player.func_70005_c_());
                ArrayList<MorphVariant> morphsToClean = new ArrayList<MorphVariant>();
                for (int i = 0; i < morphs.size(); ++i) {
                    MorphVariant var = morphs.get(i);
                    if (!var.entId.startsWith("player:")) {
                        morphsToClean.addAll(var.split());
                        continue;
                    }
                    ArrayList newMorphs = Morph.eventHandlerServer.playerMorphs.computeIfAbsent(player.func_70005_c_(), v -> new ArrayList());
                    newMorphs.add(var);
                }
                morphs = Morph.eventHandlerServer.getPlayerMorphs((EntityPlayer)player);
                for (MorphVariant var : morphsToClean) {
                    EntityLivingBase living = var.createEntityInstance(player.func_130014_f_());
                    MorphVariant variant = MorphVariant.createVariant(living);
                    if (variant == null) continue;
                    variant.thisVariant.isFavourite = var.thisVariant.isFavourite;
                    int variantIndex = -2;
                    for (MorphVariant morphVariant : morphs) {
                        if (!variant.entId.equals(morphVariant.entId) || (variantIndex = MorphVariant.combineVariants(morphVariant, variant)) == -2) continue;
                        variant = morphVariant.createWithVariant(variantIndex == -1 ? morphVariant.thisVariant : morphVariant.variants.get(variantIndex));
                        break;
                    }
                    if (variantIndex != -2) continue;
                    morphs.add(variant);
                }
                Collections.sort(morphs);
                PlayerMorphHandler.getInstance().savePlayerData((EntityPlayer)player);
                Morph.channel.sendTo((AbstractPacket)new PacketUpdateMorphList(true, morphs.toArray(new MorphVariant[morphs.size()])), (EntityPlayer)player);
                CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.successful", (Object[])new Object[]{player.func_70005_c_()});
                return;
            }
            CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.unsuccessful", (Object[])new Object[]{player.func_70005_c_()});
            return;
        } else if (args[0].equalsIgnoreCase("remove")) {
            if (args.length != 3) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            ArrayList<MorphVariant> morphs = Morph.eventHandlerServer.playerMorphs.get(player.func_70005_c_());
            if (morphs == null || morphs.isEmpty()) return;
            boolean found = false;
            for (int i = morphs.size() - 1; i >= 0; --i) {
                MorphVariant var = morphs.get(i);
                if ((!args[2].startsWith("player:") || !var.entId.equalsIgnoreCase("PlayerMorph") || var.playerName.equalsIgnoreCase(player.func_70005_c_()) || !var.playerName.equalsIgnoreCase(args[2].substring("player:".length(), args[2].length()))) && !var.entId.equalsIgnoreCase(args[2])) continue;
                morphs.remove(i);
                found = true;
            }
            if (found) {
                PlayerMorphHandler.getInstance().savePlayerData((EntityPlayer)player);
                morphs = Morph.eventHandlerServer.getPlayerMorphs((EntityPlayer)player);
                Morph.channel.sendTo((AbstractPacket)new PacketUpdateMorphList(true, morphs.toArray(new MorphVariant[morphs.size()])), (EntityPlayer)player);
                CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.successful", (Object[])new Object[]{player.func_70005_c_()});
                return;
            } else {
                CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.unsuccessful", (Object[])new Object[]{player.func_70005_c_()});
            }
            return;
        } else if (args[0].equalsIgnoreCase("analyse")) {
            if (args.length != 3) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            if (args[2].startsWith("player:")) {
                CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.analysePlayer", (Object[])new Object[0]);
                return;
            }
            ArrayList<MorphVariant> morphs = Morph.eventHandlerServer.playerMorphs.get(player.func_70005_c_());
            if (morphs == null || morphs.isEmpty()) return;
            for (MorphVariant var : morphs) {
                if (!var.entId.equals(args[2])) continue;
                EntityLivingBase living = var.createEntityInstance(player.func_130014_f_());
                if (var.thisVariant.invalid) {
                    CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.unsuccessful", (Object[])new Object[]{player.func_70005_c_()});
                    return;
                }
                CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.analyseClass", (Object[])new Object[]{living.getClass().getName()});
                TreeMap tags = new TreeMap(Ordering.natural());
                tags.putAll(var.entTag.field_74784_a);
                TreeMap added = new TreeMap(Ordering.natural());
                added.putAll(var.thisVariant.variantData.field_74784_a);
                TreeMap removed = new TreeMap((Comparator<String>)Ordering.natural());
                for (String string : var.thisVariant.tagsToRemove) {
                    removed.put(string, null);
                }
                for (MorphVariant.Variant variant : var.variants) {
                    added.putAll(variant.variantData.field_74784_a);
                    for (String string : variant.tagsToRemove) {
                        removed.put(string, null);
                    }
                }
                tags.putAll(added);
                tags.putAll(removed);
                tags.remove("Age");
                tags.remove("CanPickUpLoot");
                tags.remove("HealF");
                tags.remove("Health");
                tags.remove("Morph_HealthBalancing");
                tags.remove("NoAI");
                tags.remove("PersistenceRequired");
                added.remove("Morph_HealthBalancing");
                StringBuilder addedSb = new StringBuilder();
                for (Map.Entry entry : tags.entrySet()) {
                    addedSb.append((String)entry.getKey());
                    addedSb.append(", ");
                    addedSb.append(" (");
                    addedSb.append(entry.getValue() == null ? "null" : ((NBTBase)entry.getValue()).getClass().getSimpleName().substring(6));
                    addedSb.append("), ");
                }
                CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.analyseAllTags", (Object[])new Object[]{addedSb.toString().isEmpty() ? "" : addedSb.toString().substring(0, addedSb.toString().length() - 2)});
                TreeMap treeMap = new TreeMap(Ordering.natural());
                added.keySet().stream().filter(removed.keySet()::contains).forEach(k -> {
                    NBTBase cfr_ignored_0 = (NBTBase)treeMap.put(k, added.get(k));
                });
                removed.keySet().stream().filter(added.keySet()::contains).forEach(k -> {
                    NBTBase cfr_ignored_0 = (NBTBase)treeMap.put(k, added.get(k));
                });
                TreeSet treeSet = new TreeSet(added.keySet());
                for (Iterator s : removed.keySet()) {
                    added.remove(s);
                }
                for (Iterator s : treeSet) {
                    removed.remove(s);
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry tag : treeMap.entrySet()) {
                    stringBuilder.append("+/-");
                    stringBuilder.append((String)tag.getKey());
                    stringBuilder.append(" (");
                    stringBuilder.append(tag.getValue() == null ? "null" : ((NBTBase)tag.getValue()).getClass().getSimpleName().substring(6));
                    stringBuilder.append("), ");
                }
                for (Map.Entry tag : added.entrySet()) {
                    stringBuilder.append("+");
                    stringBuilder.append((String)tag.getKey());
                    stringBuilder.append(" (");
                    stringBuilder.append(tag.getValue() == null ? "null" : ((NBTBase)tag.getValue()).getClass().getSimpleName().substring(6));
                    stringBuilder.append("), ");
                }
                for (Map.Entry tag : removed.entrySet()) {
                    stringBuilder.append("-");
                    stringBuilder.append((String)tag.getKey());
                    stringBuilder.append(" (");
                    stringBuilder.append(tag.getValue() == null ? "null" : ((NBTBase)tag.getValue()).getClass().getSimpleName().substring(6));
                    stringBuilder.append("), ");
                }
                CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.analyseVariantTags", (Object[])new Object[]{stringBuilder.toString().isEmpty() ? "" : stringBuilder.toString().substring(0, stringBuilder.toString().length() - 2)});
                return;
            }
            CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.unsuccessful", (Object[])new Object[]{player.func_70005_c_()});
            return;
        } else if (args[0].equalsIgnoreCase("clear")) {
            Morph.eventHandlerServer.playerMorphs.remove(player.func_70005_c_());
            PlayerMorphHandler.getInstance().savePlayerData((EntityPlayer)player);
            ArrayList<MorphVariant> morphs = Morph.eventHandlerServer.getPlayerMorphs((EntityPlayer)player);
            Morph.channel.sendTo((AbstractPacket)new PacketUpdateMorphList(true, morphs.toArray(new MorphVariant[morphs.size()])), (EntityPlayer)player);
            CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.clearingMorphs", (Object[])new Object[]{player.func_70005_c_()});
            return;
        } else {
            if (!args[0].equalsIgnoreCase("morph") && !args[0].equalsIgnoreCase("give")) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            EntityLivingBase entToMorphTo = null;
            if (args.length <= 2) {
                RayTraceResult mop = EntityHelper.getEntityLook((Entity)player, (double)5.0);
                if (mop.field_72313_a == RayTraceResult.Type.ENTITY && mop.field_72308_g instanceof EntityLivingBase) {
                    entToMorphTo = (EntityLivingBase)mop.field_72308_g;
                }
            } else if (!args[2].equalsIgnoreCase("*")) {
                if (args[2].startsWith("player:")) {
                    entToMorphTo = new EntityPlayerMP(FMLCommonHandler.instance().getMinecraftServerInstance(), DimensionManager.getWorld((int)0), EntityHelper.getGameProfile((String)args[2].substring("player:".length(), args[2].length())), new PlayerInteractionManager((World)DimensionManager.getWorld((int)0)));
                } else {
                    Entity ent = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(args[2]), (World)player.func_130014_f_());
                    if (ent instanceof EntityLivingBase) {
                        entToMorphTo = (EntityLivingBase)ent;
                    }
                }
            } else if (args[0].equalsIgnoreCase("give")) {
                CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"...", (Object[])new Object[]{player.func_70005_c_()});
                boolean newMorph = false;
                for (EntityEntry entry : ForgeRegistries.ENTITIES.getValues()) {
                    if (!EntityLivingBase.class.isAssignableFrom(entry.getEntityClass())) continue;
                    for (int i = 0; i < 100; ++i) {
                        MorphVariant variant;
                        EntityLivingBase living = (EntityLivingBase)entry.newInstance(player.field_70170_p);
                        if (living == null) continue;
                        if (living instanceof EntityLiving) {
                            EntityLiving entityliving = (EntityLiving)living;
                            entityliving.func_180482_a(player.field_70170_p.func_175649_E(new BlockPos((Entity)entityliving)), (IEntityLivingData)null);
                        }
                        if (Morph.config.childMorphs == 0 && living.func_70631_g_() || Morph.config.playerMorphs == 0 && living instanceof EntityPlayer || Morph.config.bossMorphs == 0 && !living.func_184222_aU() || player.getClass() == FakePlayer.class || player.field_71135_a == null || !PlayerMorphHandler.isEntityMorphableConfig(living) || MinecraftForge.EVENT_BUS.post((Event)new MorphAcquiredEvent((EntityPlayer)player, living)) || (variant = MorphVariant.createVariant(living)) == null) continue;
                        ArrayList<MorphVariant> morphs = Morph.eventHandlerServer.playerMorphs.get(player.func_70005_c_());
                        int n = -2;
                        boolean bl = false;
                        for (MorphVariant var : morphs) {
                            if (variant.entId.equals("PlayerMorph")) {
                                if (!var.entId.equals("PlayerMorph") || !variant.playerName.equals(var.playerName)) continue;
                                bl = true;
                                continue;
                            }
                            if (!variant.entId.equals(var.entId)) continue;
                            n = MorphVariant.combineVariants(var, variant);
                            if (n == -2) {
                                bl = true;
                                break;
                            }
                            variant = var.createWithVariant(n == -1 ? var.thisVariant : var.variants.get(n));
                            newMorph = true;
                            break;
                        }
                        if (n == -2 && !bl) {
                            morphs.add(variant);
                            newMorph = true;
                        }
                        Collections.sort(morphs);
                    }
                }
                if (newMorph) {
                    ArrayList<MorphVariant> morphs = Morph.eventHandlerServer.getPlayerMorphs((EntityPlayer)player);
                    Morph.channel.sendTo((AbstractPacket)new PacketUpdateMorphList(true, morphs.toArray(new MorphVariant[morphs.size()])), (EntityPlayer)player);
                    PlayerMorphHandler.getInstance().savePlayerData((EntityPlayer)player);
                    CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.successful", (Object[])new Object[]{player.func_70005_c_()});
                    return;
                } else {
                    CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.unsuccessful", (Object[])new Object[]{player.func_70005_c_()});
                }
                return;
            }
            if (entToMorphTo != null) {
                if (args[0].equalsIgnoreCase("morph") && PlayerMorphHandler.getInstance().forceMorph(player, entToMorphTo) || args[0].equalsIgnoreCase("give") && PlayerMorphHandler.getInstance().acquireMorph(player, entToMorphTo, false, false)) {
                    CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.successful", (Object[])new Object[]{player.func_70005_c_()});
                    return;
                } else {
                    CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.unsuccessful", (Object[])new Object[]{player.func_70005_c_()});
                }
                return;
            } else {
                CommandMorph.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"morph.command.cannotFindEntity", (Object[])new Object[0]);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (this.entityNames.isEmpty()) {
            for (EntityEntry entry : ForgeRegistries.ENTITIES.getValues()) {
                if (!EntityLivingBase.class.isAssignableFrom(entry.getEntityClass())) continue;
                this.entityNames.add(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entry).toString());
            }
        }
        ArrayList<String> entityNamesWithPlayers = new ArrayList<String>(this.entityNames);
        if (args.length >= 2 && args[0].equalsIgnoreCase("give")) {
            for (int i = 0; i < server.func_71213_z().length; ++i) {
                if (args[1].equals(server.func_71213_z()[i])) continue;
                entityNamesWithPlayers.add("player:" + server.func_71213_z()[i]);
            }
        }
        if (args.length == 3 && (args[0].equalsIgnoreCase("remove") || args[0].equalsIgnoreCase("analyse"))) {
            ArrayList<MorphVariant> morphs;
            EntityPlayerMP player;
            try {
                player = CommandMorph.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
            }
            catch (CommandException e) {
                player = null;
            }
            if (player != null && (morphs = Morph.eventHandlerServer.playerMorphs.get(player.func_70005_c_())) != null && !morphs.isEmpty()) {
                ArrayList<String> names = new ArrayList<String>();
                for (MorphVariant var : morphs) {
                    if (var.entId.equals("PlayerMorph") && player.func_70005_c_().equals(var.playerName)) continue;
                    if (var.entId.equals("PlayerMorph")) {
                        names.add("player:" + var.playerName);
                        continue;
                    }
                    names.add(var.entId);
                }
                return CommandMorph.func_175762_a((String[])args, names);
            }
        }
        return args.length == 1 ? CommandMorph.func_71530_a((String[])args, (String[])new String[]{"analyse", "demorph", "clean", "remove", "clear", "morph", "give", "help"}) : (args.length == 2 ? CommandMorph.func_71530_a((String[])args, (String[])server.func_71213_z()) : (args.length == 3 ? (args[0].equalsIgnoreCase("demorph") || args[0].equalsIgnoreCase("clear") ? CommandMorph.func_71530_a((String[])args, (String[])new String[]{"true"}) : (args[0].equalsIgnoreCase("morph") || args[0].equalsIgnoreCase("give") ? CommandMorph.func_175762_a((String[])args, entityNamesWithPlayers) : CommandMorph.func_71530_a((String[])args, (String[])new String[]{""}))) : CommandMorph.func_71530_a((String[])args, (String[])new String[]{""})));
    }

    public boolean func_82358_a(String[] args, int index) {
        return args.length > 0 && !args[0].equalsIgnoreCase("help") && index == 1;
    }
}

