/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.items.IItemHandler;

public class Util {
    public static Random rand = new Random();

    @Nonnull
    public static <T extends TileEntity> List<T> getTileEntitiesWithin(@Nonnull World world, @Nonnull Class<? extends T> teClass, BlockPos pos, int radius) {
        ArrayList<TileEntity> tiles = new ArrayList<TileEntity>();
        for (int i = pos.func_177958_n() - radius; i <= pos.func_177958_n() + radius; ++i) {
            for (int j = pos.func_177956_o() - radius; j <= pos.func_177956_o() + radius; ++j) {
                for (int k = pos.func_177952_p() - radius; k <= pos.func_177952_p() + radius; ++k) {
                    TileEntity t;
                    BlockPos p = new BlockPos(i, j, k);
                    Chunk c = world.func_175726_f(p);
                    if (!c.func_177410_o() || (t = world.func_175726_f(p).func_177424_a(p, Chunk.EnumCreateEntityType.CHECK)) == null || !teClass.isInstance(t)) continue;
                    tiles.add(t);
                }
            }
        }
        return tiles;
    }

    public static <T extends Entity> List<T> getEntitiesWithinRadius(World world, Class<? extends T> classEntity, BlockPos pos, float xradius, float yradius, float zradius) {
        return world.func_72872_a(classEntity, new AxisAlignedBB((double)((float)pos.func_177958_n() - xradius), (double)((float)pos.func_177956_o() - yradius), (double)((float)pos.func_177952_p() - zradius), (double)((float)pos.func_177958_n() + xradius), (double)((float)pos.func_177956_o() + yradius), (double)((float)pos.func_177952_p() + zradius)));
    }

    public static List<BlockPos> getBlocksWithinRadius(World world, BlockPos pos, float xradius, float yradius, float zradius, Block block) {
        ArrayList<BlockPos> blockList = new ArrayList<BlockPos>();
        int x = (int)(-xradius);
        while ((float)x <= xradius) {
            int z = (int)(-zradius);
            while ((float)z <= zradius) {
                int y = (int)(-yradius);
                while ((float)y <= yradius) {
                    if (world.func_180495_p(pos.func_177982_a(x, y, z)).func_177230_c() == block) {
                        blockList.add(pos.func_177982_a(x, y, z));
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        return blockList;
    }

    @Nonnull
    public static String lowercase(@Nonnull String s) {
        String f = "";
        for (int i = 0; i < s.length(); ++i) {
            String c = s.substring(i, i + 1);
            if (c.toUpperCase().compareTo(c) == 0) {
                if (i > 0) {
                    f = f + "_";
                }
                f = f + c.toLowerCase();
                continue;
            }
            f = f + c;
        }
        return f;
    }

    public static int intColor(int r, int g, int b) {
        return -16777216 + r * 65536 + g * 256 + b;
    }

    @Nonnull
    public static String getLowercaseClassName(@Nonnull Class c) {
        String[] nameParts = c.getTypeName().split("\\.");
        String className = nameParts[nameParts.length - 1];
        return Util.lowercase(className);
    }

    public static void spawnInventoryInWorld(World world, double x, double y, double z, IItemHandler inventory) {
        if (inventory != null && !world.field_72995_K) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (inventory.getStackInSlot(i) == ItemStack.field_190927_a) continue;
                world.func_72838_d((Entity)new EntityItem(world, x, y, z, inventory.getStackInSlot(i)));
            }
        }
    }
}

