/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.item;

import epicsquid.mysticallib.LibRegistry;
import epicsquid.mysticallib.block.BlockCropBase;
import epicsquid.mysticallib.model.CustomModelItem;
import epicsquid.mysticallib.model.CustomModelLoader;
import epicsquid.mysticallib.model.ICustomModeledObject;
import epicsquid.mysticallib.model.IModeledObject;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class ItemSeedBase
extends ItemSeeds
implements IModeledObject,
ICustomModeledObject {
    private boolean hasCustomModel;
    private EnumPlantType plantType;
    private BlockCropBase crop;
    private Block base;

    public ItemSeedBase(@Nonnull String name, @Nonnull BlockCropBase crop, @Nonnull Block base) {
        super((Block)crop, base);
        this.func_77655_b(name);
        this.setRegistryName(LibRegistry.getActiveModid(), name);
        this.plantType = crop.getPlantType(null, null);
        this.crop = crop;
        this.base = base;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        IBlockState state = worldIn.func_180495_p(pos);
        if (facing == EnumFacing.UP && player.func_175151_a(pos.func_177972_a(facing), facing, itemstack) && worldIn.func_175623_d(pos.func_177984_a()) && (state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)this) || this.plantType != EnumPlantType.Crop)) {
            worldIn.func_175656_a(pos.func_177984_a(), this.crop.func_176223_P());
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos.func_177984_a(), itemstack);
            }
            itemstack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public ItemSeedBase setModelCustom(boolean hasCustomModel) {
        this.hasCustomModel = hasCustomModel;
        return this;
    }

    @Override
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
    }

    @Override
    public void initCustomModel() {
        if (this.hasCustomModel) {
            CustomModelLoader.itemmodels.put(this.getRegistryName(), new CustomModelItem(false, new ResourceLocation(this.getRegistryName().func_110624_b() + ":items/" + this.getRegistryName().func_110623_a())));
        }
    }

    @Nonnull
    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return this.plantType;
    }
}

