/*
 * Decompiled with CFR 0.152.
 */
package openblocks.rubbish;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.OpenBlocks;
import openblocks.advancements.Criterions;
import openblocks.events.PlayerActionEvent;
import openmods.utils.ItemUtils;

public class BrickManager {
    public static final String BOWELS_PROPERTY = "Bowels";
    private static final ResourceLocation CAPABILITY_KEY = OpenBlocks.location("bowels");
    @CapabilityInject(value=BowelContents.class)
    private static Capability<BowelContents> CAPABILITY;

    @Nullable
    public static BowelContents getProperty(Entity entity) {
        return CAPABILITY != null ? (BowelContents)entity.getCapability(CAPABILITY, EnumFacing.UP) : null;
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(BowelContents.class, (Capability.IStorage)new Capability.IStorage<BowelContents>(){

            public NBTBase writeNBT(Capability<BowelContents> capability, BowelContents instance, EnumFacing side) {
                return new NBTTagInt(instance.brickCount);
            }

            public void readNBT(Capability<BowelContents> capability, BowelContents instance, EnumFacing side, NBTBase nbt) {
                instance.brickCount = ((NBTTagInt)nbt).func_150287_d();
            }
        }, BowelContents::new);
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityInjector());
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDropsEvent evt) {
        if (evt.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        BowelContents tag = BrickManager.getProperty(evt.getEntity());
        if (tag != null) {
            for (int i = 0; i < Math.min(tag.brickCount, 16); ++i) {
                EntityItem entityItem = BrickManager.createBrick(evt.getEntity());
                evt.getDrops().add(entityItem);
            }
        }
    }

    private static boolean tryDecrementBrick(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        BowelContents tag = BrickManager.getProperty((Entity)player);
        if (tag != null && tag.brickCount > 0) {
            --tag.brickCount;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onPlayerScared(PlayerActionEvent evt) {
        if (evt.type == PlayerActionEvent.Type.BOO && evt.sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)evt.sender;
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), OpenBlocks.Sounds.PLAYER_WHOOPS, SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (BrickManager.tryDecrementBrick((EntityPlayer)player)) {
                EntityItem drop = BrickManager.createBrick((Entity)player);
                drop.func_174869_p();
                player.field_70170_p.func_72838_d((Entity)drop);
                Criterions.brickDropped.trigger(player);
                player.func_71064_a(OpenBlocks.brickStat, 1);
            }
        }
    }

    private static EntityItem createBrick(Entity dropper) {
        ItemStack brick = new ItemStack(Items.field_151118_aC);
        EntityItem drop = ItemUtils.createDrop((Entity)dropper, (ItemStack)brick);
        double rotation = Math.toRadians(dropper.field_70177_z) - 1.5707963267948966;
        double dx = Math.cos(rotation);
        double dz = Math.sin(rotation);
        drop.func_70091_d(MoverType.SELF, 0.75 * dx, 0.5, 0.75 * dz);
        drop.field_70159_w = 0.5 * dx;
        drop.field_70181_x = 0.2;
        drop.field_70179_y = 0.5 * dz;
        return drop;
    }

    private static class CapabilityInjector {
        private CapabilityInjector() {
        }

        @SubscribeEvent
        public void attachCapability(AttachCapabilitiesEvent<Entity> evt) {
            if (evt.getObject() instanceof EntityPlayerMP) {
                evt.addCapability(CAPABILITY_KEY, (ICapabilityProvider)new ICapabilitySerializable<NBTTagInt>(){
                    private final BowelContents state = new BowelContents();

                    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                        return capability == CAPABILITY;
                    }

                    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                        if (capability == CAPABILITY) {
                            return (T)this.state;
                        }
                        return null;
                    }

                    public NBTTagInt serializeNBT() {
                        return new NBTTagInt(this.state.brickCount);
                    }

                    public void deserializeNBT(NBTTagInt nbt) {
                        this.state.brickCount = nbt.func_150287_d();
                    }
                });
            }
        }
    }

    public static class BowelContents {
        public int brickCount;
    }
}

