/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.TileEntityImaginary;
import openmods.colors.ColorMeta;
import openmods.utils.ItemUtils;
import openmods.utils.TranslationUtils;

public class ItemImaginationGlasses
extends ItemArmor {
    private static final String TAG_COLOR = "Color";
    public final Type type;

    public static int getGlassesColor(@Nonnull ItemStack stack) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        return tag.func_74762_e(TAG_COLOR);
    }

    public ItemImaginationGlasses(Type type) {
        super(ItemArmor.ArmorMaterial.GOLD, 1, EntityEquipmentSlot.HEAD);
        this.type = type;
        this.func_77627_a(true);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return this.type.textureName;
    }

    public boolean checkBlock(TileEntityImaginary.Property property, @Nonnull ItemStack stack, TileEntityImaginary te) {
        return this.type.checkBlock(property, stack, te);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> result) {
        if (this.func_194125_a(tab)) {
            result.add((Object)new ItemStack((Item)this));
        }
    }

    public static enum Type {
        PENCIL("pencil"){

            @Override
            protected boolean checkBlock(TileEntityImaginary.Property property, @Nonnull ItemStack stack, TileEntityImaginary te) {
                return te.isPencil() ^ te.isInverted();
            }
        }
        ,
        CRAYON("crayon"){

            @Override
            protected boolean checkBlock(TileEntityImaginary.Property property, @Nonnull ItemStack stack, TileEntityImaginary te) {
                return (!te.isPencil() && ItemImaginationGlasses.getGlassesColor(stack) == te.color) ^ te.isInverted();
            }
        }
        ,
        TECHNICOLOR("technicolor"){

            @Override
            protected boolean checkBlock(TileEntityImaginary.Property property, @Nonnull ItemStack stack, TileEntityImaginary te) {
                if (property == TileEntityImaginary.Property.VISIBLE) {
                    return true;
                }
                return te.isInverted();
            }
        }
        ,
        BASTARD("admin"){

            @Override
            protected boolean checkBlock(TileEntityImaginary.Property property, @Nonnull ItemStack stack, TileEntityImaginary te) {
                return true;
            }
        };

        public final String textureName;
        public static final Type[] VALUES;

        private Type(String name) {
            this.textureName = OpenBlocks.location("textures/models/glasses_" + name + ".png").toString();
        }

        protected abstract boolean checkBlock(TileEntityImaginary.Property var1, @Nonnull ItemStack var2, TileEntityImaginary var3);

        static {
            VALUES = Type.values();
        }
    }

    public static class ItemCrayonGlasses
    extends ItemImaginationGlasses {
        private static final String COLORED_OVERLAY = OpenBlocks.location("textures/models/glasses_crayon_overlay.png").toString();

        public ItemCrayonGlasses() {
            super(Type.CRAYON);
        }

        @Override
        public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> result) {
            if (this.func_194125_a(tab)) {
                for (ColorMeta color : ColorMeta.getAllColors()) {
                    result.add((Object)ItemCrayonGlasses.createCrayonGlasses((Item)this, color.rgb));
                }
            }
        }

        public int func_82814_b(@Nonnull ItemStack stack) {
            return ItemCrayonGlasses.getGlassesColor(stack);
        }

        @Nonnull
        public static ItemStack createCrayonGlasses(Item item, int color) {
            ItemStack stack = new ItemStack(item);
            NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
            tag.func_74768_a(ItemImaginationGlasses.TAG_COLOR, color);
            return stack;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, List<String> result, ITooltipFlag flag) {
            result.add(TranslationUtils.translateToLocalFormatted((String)"openblocks.misc.color", (Object[])new Object[]{this.func_82814_b(stack)}));
        }

        @Override
        public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
            if ("overlay".equals(type)) {
                return COLORED_OVERLAY;
            }
            return super.getArmorTexture(stack, entity, slot, type);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class CrayonColorHandler
    implements IItemColor {
        public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
            return ItemImaginationGlasses.getGlassesColor(stack);
        }
    }
}

