/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.TileEntityGuide;
import openblocks.events.GuideActionEvent;
import openmods.OpenMods;
import openmods.api.ISelectionAware;
import openmods.block.BlockRotationMode;
import openmods.block.IBlockRotationMode;
import openmods.block.OpenBlock;
import openmods.geometry.BlockSpaceTransform;
import openmods.geometry.Hitbox;
import openmods.geometry.IHitboxSupplier;
import openmods.geometry.Orientation;
import openmods.infobook.BookDocumentation;

@BookDocumentation(hasVideo=true)
public class BlockGuide
extends OpenBlock
implements ISelectionAware {
    private AxisAlignedBB selection;
    private final IHitboxSupplier buttonsHitbox = OpenMods.proxy.getHitboxes(OpenBlocks.location("guide_buttons"));

    public IBlockRotationMode getRotationMode() {
        return BlockRotationMode.THREE_FOUR_DIRECTIONS;
    }

    public BlockGuide() {
        super(Material.field_151576_e);
        this.func_149715_a(0.6f);
        this.setPlacementMode(OpenBlock.BlockPlacementMode.SURFACE);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return this.selection != null ? this.selection : super.func_180640_a(state, world, pos);
    }

    private Hitbox findClickBox(Vec3d pos) {
        for (Hitbox h : this.buttonsHitbox.asList()) {
            if (!h.aabb().func_72318_a(pos)) continue;
            return h;
        }
        return null;
    }

    protected boolean areButtonsActive(EntityPlayer player) {
        return true;
    }

    protected boolean onItemUse(EntityPlayerMP player, TileEntityGuide guide, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onSelected(World world, BlockPos pos, DrawBlockHighlightEvent evt) {
        if (this.areButtonsActive(evt.getPlayer())) {
            Vec3d hitVec = evt.getTarget().field_72307_f;
            Orientation orientation = this.getOrientation((IBlockAccess)world, pos);
            Vec3d localHit = BlockSpaceTransform.instance.mapWorldToBlock(orientation, hitVec.field_72450_a - (double)pos.func_177958_n(), hitVec.field_72448_b - (double)pos.func_177956_o(), hitVec.field_72449_c - (double)pos.func_177952_p());
            Hitbox clickBox = this.findClickBox(localHit);
            this.selection = clickBox != null ? BlockSpaceTransform.instance.mapBlockToWorld(orientation, clickBox.aabb()).func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) : null;
        } else {
            this.selection = null;
        }
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityGuide guide;
        ItemStack heldStack;
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (world.field_72995_K) {
            Orientation orientation;
            Vec3d localHit;
            Hitbox clickBox;
            if (this.areButtonsActive(player) && (clickBox = this.findClickBox(localHit = BlockSpaceTransform.instance.mapWorldToBlock(orientation = this.getOrientation((IBlockAccess)world, pos), (double)hitX, (double)hitY, (double)hitZ))) != null) {
                new GuideActionEvent(world.field_73011_w.getDimension(), pos, clickBox.name).sendToServer();
            }
            return true;
        }
        return player instanceof EntityPlayerMP && !(heldStack = player.func_184614_ca()).func_190926_b() && (guide = (TileEntityGuide)((Object)BlockGuide.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityGuide.class))).onItemUse((EntityPlayerMP)player, heldStack, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        float x = (float)pos.func_177958_n() + 0.5f;
        float y = (float)pos.func_177956_o() + 0.7f;
        float z = (float)pos.func_177952_p() + 0.5f;
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.FLAME, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, new int[0]);
    }
}

