/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.fml.common.eventhandler.ASMEventHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.ListenerList;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.api.GraveDropsEvent;
import openblocks.api.GraveSpawnEvent;
import openblocks.common.PlayerInventoryStore;
import openblocks.common.tileentity.TileEntityGrave;
import openmods.Log;
import openmods.inventory.GenericInventory;
import openmods.utils.NbtUtils;
import openmods.world.DelayedActionTickHandler;
import org.apache.logging.log4j.Level;

public class PlayerDeathHandler {
    private static final Comparator<BlockPos> SEARCH_COMPARATOR = new Comparator<BlockPos>(){

        private int coordSum(BlockPos c) {
            return Math.abs(c.func_177958_n()) + Math.abs(c.func_177956_o()) + Math.abs(c.func_177952_p());
        }

        private int coordMax(BlockPos c) {
            return Math.max(Math.max(Math.abs(c.func_177958_n()), Math.abs(c.func_177956_o())), Math.abs(c.func_177952_p()));
        }

        @Override
        public int compare(BlockPos a, BlockPos b) {
            int diff = this.coordSum(a) - this.coordSum(b);
            if (diff != 0) {
                return diff;
            }
            return this.coordMax(b) - this.coordMax(a);
        }
    };
    private static SearchOrder searchOrder;
    private static final GravePlacementChecker POLITE;
    private static final GravePlacementChecker BRUTAL;

    private static Iterable<BlockPos> getSearchOrder(int size) {
        if (searchOrder == null || PlayerDeathHandler.searchOrder.size != size) {
            searchOrder = new SearchOrder(size);
        }
        return searchOrder;
    }

    private static Level debugLevel() {
        return Config.debugGraves ? Level.INFO : Level.DEBUG;
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public void onPlayerDrops(PlayerDropsEvent event) {
        World world = event.getEntityPlayer().field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (Config.debugGraves) {
            PlayerDeathHandler.dumpDebugInfo(event);
        }
        EntityPlayer player = event.getEntityPlayer();
        if (OpenBlocks.Blocks.grave == null) {
            Log.log((Level)PlayerDeathHandler.debugLevel(), (String)"OpenBlocks graves disabled, not placing (player '%s')", (Object[])new Object[]{player});
            return;
        }
        if (player instanceof FakePlayer) {
            Log.debug((String)"'%s' (%s) is a fake player, grave will not be spawned", (Object[])new Object[]{player, player.getClass()});
            return;
        }
        if (event.isCanceled()) {
            Log.warn((String)"Event for player '%s' cancelled, grave will not be spawned", (Object[])new Object[]{player});
            return;
        }
        List drops = event.getDrops();
        if (drops.isEmpty()) {
            Log.log((Level)PlayerDeathHandler.debugLevel(), (String)"No drops from player '%s', grave will not be spawned'", (Object[])new Object[]{player});
            return;
        }
        GameRules gameRules = world.func_82736_K();
        if (gameRules.func_82766_b("keepInventory") || !gameRules.func_82766_b("openblocks:spawn_graves")) {
            Log.log((Level)PlayerDeathHandler.debugLevel(), (String)"Graves disabled by gamerule (player '%s')", (Object[])new Object[]{player});
            return;
        }
        GraveDropsEvent dropsEvent = new GraveDropsEvent(player);
        for (EntityItem drop : drops) {
            dropsEvent.addItem(drop);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)dropsEvent)) {
            Log.warn((String)"Grave drops event for player '%s' cancelled, grave will not be spawned'", (Object[])new Object[]{player});
            return;
        }
        ArrayList graveLoot = Lists.newArrayList();
        drops.clear();
        block5: for (GraveDropsEvent.ItemAction entry : dropsEvent.drops) {
            switch (entry.action) {
                case DELETE: {
                    if (!Config.debugGraves) continue block5;
                    Log.info((String)"Item %s is going to be deleted", (Object[])new Object[]{entry.item});
                    continue block5;
                }
                case DROP: {
                    if (Config.debugGraves) {
                        Log.info((String)"Item %s is going to be dropped", (Object[])new Object[]{entry.item});
                    }
                    drops.add(entry.item);
                    continue block5;
                }
            }
            graveLoot.add(entry.item);
        }
        if (graveLoot.isEmpty()) {
            Log.log((Level)PlayerDeathHandler.debugLevel(), (String)"No grave drops left for player '%s' after event filtering, grave will not be spawned'", (Object[])new Object[]{player});
            return;
        }
        if (!PlayerDeathHandler.tryConsumeGrave(player, Iterables.concat((Iterable)graveLoot, (Iterable)drops))) {
            Log.log((Level)PlayerDeathHandler.debugLevel(), (String)"No grave in drops for player '%s' after firing event, grave will not be spawned'", (Object[])new Object[]{player});
            drops.addAll(graveLoot);
            return;
        }
        Log.log((Level)PlayerDeathHandler.debugLevel(), (String)"Scheduling grave placement for player '%s':'%s' with %d item(s) stored and %d item(s) dropped", (Object[])new Object[]{player, player.func_146103_bH(), graveLoot.size(), drops.size()});
        DelayedActionTickHandler.INSTANCE.addTickCallback(world, (Runnable)new GraveCallable(world, player, graveLoot));
    }

    private static boolean tryConsumeGrave(EntityPlayer player, Iterable<EntityItem> graveLoot) {
        if (!Config.requiresGraveInInv || player.field_71075_bZ.field_75098_d) {
            return true;
        }
        Item graveItem = Item.func_150898_a((Block)OpenBlocks.Blocks.grave);
        if (graveItem == Items.field_190931_a) {
            return true;
        }
        Iterator<EntityItem> lootIter = graveLoot.iterator();
        while (lootIter.hasNext()) {
            EntityItem drop = lootIter.next();
            ItemStack itemStack = drop.func_92059_d();
            if (itemStack.func_77973_b() != graveItem || itemStack.func_190926_b()) continue;
            itemStack.func_190918_g(1);
            if (itemStack.func_190926_b()) {
                lootIter.remove();
            } else {
                drop.func_92058_a(itemStack);
            }
            return true;
        }
        return false;
    }

    private static void dumpDebugInfo(PlayerDropsEvent event) {
        Log.info((String)"Trying to spawn grave for player '%s':'%s'", (Object[])new Object[]{event.getEntityPlayer(), event.getEntityPlayer().func_146103_bH()});
        int i = 0;
        for (EntityItem e : event.getDrops()) {
            Log.info((String)"\tGrave drop %d: %s -> %s", (Object[])new Object[]{i++, e.getClass(), e.func_92059_d()});
        }
        ListenerList listeners = event.getListenerList();
        try {
            int busId = 0;
            while (true) {
                Log.info((String)"Dumping event %s listeners on bus %d", (Object[])new Object[]{event.getClass(), busId});
                for (IEventListener listener : listeners.getListeners(busId)) {
                    if (listener instanceof ASMEventHandler) {
                        try {
                            ASMEventHandler handler = (ASMEventHandler)listener;
                            Object o = ReflectionHelper.getPrivateValue(ASMEventHandler.class, (Object)handler, (String[])new String[]{"handler"});
                            Log.info((String)"\t'%s' (handler %s, priority: %s)", (Object[])new Object[]{handler, o.getClass(), handler.getPriority()});
                            continue;
                        }
                        catch (Throwable e) {
                            Log.log((Level)Level.INFO, (Throwable)e, (String)"Exception while getting field", (Object[])new Object[0]);
                        }
                    }
                    Log.info((String)"\t%s", (Object[])new Object[]{listener.getClass()});
                }
                ++busId;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    static {
        POLITE = new GravePlacementChecker(){

            @Override
            public boolean checkBlock(World world, BlockPos pos, IBlockState state) {
                Block block = state.func_177230_c();
                return block.isAir(state, (IBlockAccess)world, pos) || block.func_176200_f((IBlockAccess)world, pos);
            }
        };
        BRUTAL = new GravePlacementChecker(){

            @Override
            public boolean checkBlock(World world, BlockPos pos, IBlockState state) {
                return state.func_185887_b(world, pos) >= 0.0f && world.func_175625_s(pos) == null;
            }
        };
    }

    private static class GraveCallable
    implements Runnable {
        private final ITextComponent cause;
        private final GameProfile stiffId;
        private final BlockPos playerPos;
        private final List<EntityItem> loot;
        private final WeakReference<World> world;
        private final WeakReference<EntityPlayer> exPlayer;

        public GraveCallable(World world, EntityPlayer exPlayer, List<EntityItem> loot) {
            this.playerPos = exPlayer.func_180425_c();
            this.world = new WeakReference<World>(world);
            this.exPlayer = new WeakReference<EntityPlayer>(exPlayer);
            this.stiffId = exPlayer.func_146103_bH();
            ITextComponent day = GraveCallable.formatDate(world);
            ITextComponent deathCause = exPlayer.func_110142_aN().func_151521_b();
            this.cause = new TextComponentTranslation("openblocks.misc.grave_msg", new Object[]{deathCause, day});
            this.loot = ImmutableList.copyOf(loot);
        }

        private static ITextComponent formatDate(World world) {
            long time = world.func_82737_E();
            String day = String.format("%.1f", (double)time / 24000.0);
            TextComponentString dayComponent = new TextComponentString(day);
            dayComponent.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(true));
            return dayComponent;
        }

        private void setCommonStoreInfo(NBTTagCompound meta, boolean placed) {
            meta.func_74778_a("PlayerName", this.stiffId.getName());
            meta.func_74778_a("PlayerUUID", this.stiffId.getId().toString());
            meta.func_74782_a("PlayerLocation", (NBTBase)NbtUtils.store((BlockPos)this.playerPos));
            meta.func_74757_a("Placed", placed);
        }

        private boolean tryPlaceGrave(World world, BlockPos gravePos, String gravestoneText, ITextComponent deathMessage) {
            world.func_175656_a(gravePos, OpenBlocks.Blocks.grave.func_176223_P());
            TileEntity tile = world.func_175625_s(gravePos);
            if (tile == null || !(tile instanceof TileEntityGrave)) {
                Log.warn((String)"Failed to place grave @ %s: invalid tile entity: %s(%s)", (Object[])new Object[]{gravePos, tile, tile != null ? tile.getClass() : "?"});
                return false;
            }
            TileEntityGrave grave = (TileEntityGrave)tile;
            IInventory loot = this.getLoot();
            if (Config.backupGraves) {
                this.backupGrave(world, loot, meta -> {
                    this.setCommonStoreInfo(meta, true);
                    meta.func_74782_a("GraveLocation", (NBTBase)NbtUtils.store((BlockPos)gravePos));
                });
            }
            Log.info((String)"Grave for (%s,%s) was spawned at (%s) (player died at (%s))", (Object[])new Object[]{this.stiffId.getId(), this.stiffId.getName(), gravePos, this.playerPos});
            grave.setUsername(gravestoneText);
            grave.setLoot(loot);
            grave.setDeathMessage(deathMessage);
            return true;
        }

        protected IInventory getLoot() {
            GenericInventory loot = new GenericInventory("tmpplayer", false, this.loot.size());
            IItemHandlerModifiable handler = loot.getHandler();
            for (EntityItem entityItem : this.loot) {
                ItemStack stack = entityItem.func_92059_d();
                if (stack.func_190926_b()) continue;
                ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)false);
            }
            return loot;
        }

        private boolean trySpawnGrave(EntityPlayer player, World world) {
            String gravestoneText;
            BlockPos location = this.findLocation(world, player);
            GraveSpawnEvent evt = new GraveSpawnEvent(player, location, this.loot, gravestoneText = this.stiffId.getName(), this.cause);
            if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
                Log.warn((String)"Grave event for player %s cancelled, no grave will spawn", (Object[])new Object[]{this.stiffId});
                return false;
            }
            if (evt.location == null) {
                Log.warn((String)"No location for grave found, no grave will spawn", (Object[])new Object[]{this.stiffId});
                return false;
            }
            Log.log((Level)PlayerDeathHandler.debugLevel(), (String)"Grave for %s will be spawned at (%s)", (Object[])new Object[]{this.stiffId, evt.location});
            BlockPos under = evt.location.func_177977_b();
            if (Config.graveBase && GraveCallable.canSpawnBase(world, player, under)) {
                world.func_175656_a(under, Blocks.field_150346_d.func_176223_P());
            }
            return this.tryPlaceGrave(world, evt.location, evt.gravestoneText, evt.clickText);
        }

        private static boolean canSpawnBase(World world, EntityPlayer player, BlockPos pos) {
            return world.func_175667_e(pos) && world.func_175623_d(pos) && world.func_175660_a(player, pos);
        }

        private BlockPos findLocation(World world, EntityPlayer player, GravePlacementChecker checker) {
            int limitedPosY = Math.min(Math.max(this.playerPos.func_177956_o(), Config.minGraveY), Config.maxGraveY);
            BlockPos searchPos = new BlockPos(this.playerPos.func_177958_n(), limitedPosY, this.playerPos.func_177952_p());
            int searchSize = Config.graveSpawnRange / 2;
            for (BlockPos c : PlayerDeathHandler.getSearchOrder(searchSize)) {
                BlockPos tryPos = searchPos.func_177971_a((Vec3i)c);
                int y = tryPos.func_177956_o();
                if (y > Config.maxGraveY || y < Config.minGraveY || !checker.canPlace(world, player, tryPos)) continue;
                return tryPos;
            }
            return null;
        }

        private BlockPos findLocation(World world, EntityPlayer player) {
            BlockPos location = this.findLocation(world, player, POLITE);
            if (location != null) {
                return location;
            }
            if (Config.destructiveGraves) {
                Log.warn((String)"Failed to place grave for player %s, going berserk", (Object[])new Object[]{this.stiffId});
                return this.findLocation(world, player, BRUTAL);
            }
            return null;
        }

        private void backupGrave(World world, IInventory loot, PlayerInventoryStore.ExtrasFiller filler) {
            try {
                File backup = PlayerInventoryStore.instance.storeInventory(loot, this.stiffId.getName(), "grave", world, filler);
                Log.log((Level)PlayerDeathHandler.debugLevel(), (String)"Grave backup for player %s saved to %s", (Object[])new Object[]{this.stiffId, backup});
            }
            catch (Throwable t) {
                Log.warn((String)"Failed to store grave backup for player %s", (Object[])new Object[]{this.stiffId});
            }
        }

        @Override
        public void run() {
            EntityPlayer player = (EntityPlayer)this.exPlayer.get();
            if (player == null) {
                Log.warn((String)"Lost player while placing player %s grave", (Object[])new Object[]{this.stiffId});
                return;
            }
            World world = (World)this.world.get();
            if (world == null) {
                Log.warn((String)"Lost world while placing player %s grave", (Object[])new Object[]{this.stiffId});
                return;
            }
            if (!this.trySpawnGrave(player, world)) {
                if (Config.backupGraves) {
                    IInventory loot = this.getLoot();
                    this.backupGrave(world, loot, meta -> this.setCommonStoreInfo(meta, false));
                }
                for (EntityItem drop : this.loot) {
                    world.func_72838_d((Entity)drop);
                }
            }
        }
    }

    private static abstract class GravePlacementChecker {
        private GravePlacementChecker() {
        }

        public boolean canPlace(World world, EntityPlayer player, BlockPos pos) {
            if (!world.func_175667_e(pos)) {
                return false;
            }
            if (!world.func_175660_a(player, pos)) {
                return false;
            }
            IBlockState block = world.func_180495_p(pos);
            return this.checkBlock(world, pos, block);
        }

        public abstract boolean checkBlock(World var1, BlockPos var2, IBlockState var3);
    }

    private static class SearchOrder
    implements Iterable<BlockPos> {
        public final int size;
        private final List<BlockPos> coords;

        public SearchOrder(int size) {
            this.size = size;
            ArrayList coords = Lists.newArrayList();
            for (int x = -size; x <= size; ++x) {
                for (int y = -size; y <= size; ++y) {
                    for (int z = -size; z <= size; ++z) {
                        coords.add(new BlockPos(x, y, z));
                    }
                }
            }
            Collections.sort(coords, SEARCH_COMPARATOR);
            this.coords = ImmutableList.copyOf((Collection)coords);
        }

        @Override
        public Iterator<BlockPos> iterator() {
            return this.coords.iterator();
        }
    }
}

