/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.tank;

import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import openblocks.client.renderer.tileentity.tank.DoubledCoords;
import openblocks.client.renderer.tileentity.tank.GridConnection;
import openblocks.client.renderer.tileentity.tank.TankRenderUtils;

public class HorizontalConnection
extends GridConnection {
    private FluidStack fluidA;
    private FluidStack fluidB;
    private boolean isConnected;

    public HorizontalConnection(DoubledCoords coords) {
        super(coords);
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    public void updateFluid(EnumFacing direction, FluidStack stack) {
        if (direction == EnumFacing.NORTH || direction == EnumFacing.WEST) {
            this.fluidA = TankRenderUtils.safeCopy(stack);
        } else {
            this.fluidB = TankRenderUtils.safeCopy(stack);
        }
        this.isConnected = this.fluidA != null && this.fluidB != null && this.fluidA.isFluidEqual(this.fluidB);
    }

    public void clearFluid(EnumFacing direction) {
        if (direction == EnumFacing.NORTH || direction == EnumFacing.WEST) {
            this.fluidA = null;
        } else {
            this.fluidB = null;
        }
        this.isConnected = false;
    }
}

