/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.guide;

import openblocks.Config;
import openblocks.client.renderer.tileentity.guide.GuideAdvancedRenderer;
import openblocks.client.renderer.tileentity.guide.GuideLegacyRenderer;
import openblocks.client.renderer.tileentity.guide.IGuideRenderer;
import openmods.Log;
import openmods.renderer.shaders.ArraysHelper;
import openmods.renderer.shaders.BufferHelper;
import openmods.renderer.shaders.ShaderHelper;

public class GuideRendererSelector {
    private static IGuideRenderer renderer;

    private static IGuideRenderer createRenderer() {
        if (!(ShaderHelper.isSupported() && BufferHelper.isSupported() && ArraysHelper.isSupported())) {
            Log.debug((String)"Advanced guide renderer not supported, falling back to legacy renderer.", (Object[])new Object[0]);
            return new GuideLegacyRenderer();
        }
        if (!Config.useAdvancedRenderer) {
            Log.debug((String)"Advanced guide renderer disabled, falling back to legacy renderer.", (Object[])new Object[0]);
            return new GuideLegacyRenderer();
        }
        try {
            return new GuideAdvancedRenderer();
        }
        catch (Throwable e) {
            Log.warn((Throwable)e, (String)"Error trying to create advanced renderer, falling back to legacy renderer", (Object[])new Object[0]);
            return new GuideLegacyRenderer();
        }
    }

    public IGuideRenderer getRenderer() {
        if (renderer == null) {
            renderer = GuideRendererSelector.createRenderer();
        }
        return renderer;
    }
}

