/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import openblocks.OpenBlocks;
import openblocks.common.entity.EntityHangGlider;
import openmods.renderer.DisplayListWrapper;
import org.lwjgl.opengl.GL11;

public class EntityHangGliderRenderer
extends Render<EntityHangGlider> {
    private static final float QUAD_HALF_SIZE = 2.4f;
    private static final float ONGROUND_ROTATION = 90.0f;
    private final DisplayListWrapper gliderRender = new DisplayListWrapper(){

        public void compile() {
            GlStateManager.func_179129_p();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)2.4f, (float)0.0f, (float)2.4f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)-2.4f, (float)0.0f, (float)2.4f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)-2.4f, (float)0.0f, (float)-2.4f);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)2.4f, (float)0.0f, (float)-2.4f);
            GL11.glEnd();
            GlStateManager.func_179089_o();
        }
    };
    private static final ResourceLocation texture = OpenBlocks.location("textures/models/hang_glider.png");

    public EntityHangGliderRenderer(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityHangGlider glider, double x, double y, double z, float f, float f1) {
        EntityPlayer owner = glider.getPlayer();
        if (owner == null) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        boolean isLocalPlayer = owner.func_175144_cb();
        boolean isFpp = minecraft.field_71474_y.field_74320_O == 0;
        boolean isDeployed = glider.isDeployed();
        if (isLocalPlayer && isFpp && !isDeployed) {
            return;
        }
        float rotation = EntityHangGliderRenderer.interpolateRotation(glider.field_70126_B, glider.field_70177_z, f1);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotatef((float)(180.0f - rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        if (isLocalPlayer && isFpp) {
            GL11.glTranslated((double)0.0, (double)0.7, (double)0.0);
        } else if (!isDeployed) {
            GL11.glTranslated((double)0.0, (double)0.2, (double)0.3);
        } else {
            GL11.glTranslated((double)0.0, (double)-0.5, (double)-1.0);
        }
        if (!isDeployed) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)0.4f, (float)1.0f, (float)0.4f);
        }
        this.func_110776_a(texture);
        this.gliderRender.render();
        GL11.glPopMatrix();
    }

    private static float interpolateRotation(float prevRotation, float nextRotation, float modifier) {
        float rotation;
        for (rotation = nextRotation - prevRotation; rotation < -180.0f; rotation += 360.0f) {
        }
        while (rotation >= 180.0f) {
            rotation -= 360.0f;
        }
        return prevRotation + modifier * rotation;
    }

    protected ResourceLocation getEntityTexture(EntityHangGlider entity) {
        return texture;
    }
}

