/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.client.FMLClientHandler;
import openblocks.Config;
import openmods.Log;
import openmods.reflection.MethodAccess;
import openmods.renderer.PreWorldRenderHookVisitor;
import openmods.utils.render.FramebufferBlitter;
import openmods.utils.render.RenderUtils;

public class SkyBlockRenderer
implements IResourceManagerReloadListener {
    public static final SkyBlockRenderer INSTANCE = new SkyBlockRenderer();
    private Framebuffer skyFb;
    private boolean isActive;
    private int stencilBit = -1;
    private int stencilMask;
    private int lastRenderUsers;
    private boolean skyCaptured;
    private static Runnable NULL_HOOK = () -> {};

    public boolean hasSkyTexture() {
        return this.isActive && this.skyCaptured;
    }

    public int getStencilMask() {
        return this.stencilMask;
    }

    public void incrementUsers() {
        ++this.lastRenderUsers;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        boolean canActivate = SkyBlockRenderer.checkActivationConditions();
        if (canActivate) {
            if (!this.isActive) {
                this.isActive = this.activate();
            }
        } else if (this.isActive) {
            this.deactivate();
            this.isActive = false;
        }
    }

    private static boolean checkActivationConditions() {
        if (!Config.renderSkyBlocks) {
            Log.info((String)"Disabled by config", (Object[])new Object[0]);
            return false;
        }
        if (FMLClientHandler.instance().hasOptifine() && SkyBlockRenderer.optifineShadersEnabled()) {
            if (Config.skyBlocksOptifineOverride) {
                Log.warn((String)"Optifine detected: skyblocks + shaders may hang your game", (Object[])new Object[0]);
            } else {
                Log.info((String)"Disabled due to Optifine shaders (use `optifineOverride` config to override)", (Object[])new Object[0]);
                return false;
            }
        }
        if (!OpenGlHelper.func_148822_b()) {
            Log.info((String)"Framebuffer not enabled", (Object[])new Object[0]);
            return false;
        }
        if (!FramebufferBlitter.INSTANCE.isValid()) {
            Log.info((String)"Framebuffer blit not enabled", (Object[])new Object[0]);
            return false;
        }
        if (!PreWorldRenderHookVisitor.isActive()) {
            Log.info((String)"Pre-world render hook not active", (Object[])new Object[0]);
            return false;
        }
        Framebuffer mcFb = Minecraft.func_71410_x().func_147110_a();
        if (!mcFb.isStencilEnabled() && !mcFb.enableStencil()) {
            Log.info((String)"Stencil not enabled", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean optifineShadersEnabled() {
        try {
            Class<?> config = Class.forName("Config");
            MethodAccess.Function0 isShaders = MethodAccess.create(Boolean.TYPE, config, (String[])new String[]{"isShaders"});
            return (Boolean)isShaders.call(null);
        }
        catch (Exception e) {
            Log.info((Throwable)e, (String)"Failed to read Optifine config", (Object[])new Object[0]);
            return true;
        }
    }

    private boolean activate() {
        this.stencilBit = MinecraftForgeClient.reserveStencilBit();
        if (this.stencilBit < 0) {
            Log.info((String)"All stencil bits reserved", (Object[])new Object[0]);
            return false;
        }
        PreWorldRenderHookVisitor.setHook((Runnable)new SkyCapture());
        Log.debug((String)"Sky block rendering initialized correctly, stencilBit = %d", (Object[])new Object[]{this.stencilBit});
        this.stencilMask = 1 << this.stencilBit;
        return true;
    }

    private void deactivate() {
        PreWorldRenderHookVisitor.setHook((Runnable)NULL_HOOK);
        if (this.stencilBit >= 0) {
            MinecraftForgeClient.releaseStencilBit((int)this.stencilBit);
            this.stencilBit = -1;
        }
        Log.debug((String)"Sky block rendering deactivated", (Object[])new Object[0]);
    }

    public void bindSkyTexture() {
        this.skyFb.func_147612_c();
    }

    public void renderSkyTexture() {
        if (!this.isActive) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Framebuffer mcFb = mc.func_147110_a();
        GlStateManager.func_179106_n();
        RenderUtils.disableLightmap();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179132_a((boolean)false);
        this.skyFb.func_147615_c(mc.field_71443_c, mc.field_71440_d);
        GlStateManager.func_179126_j();
        GlStateManager.func_179083_b((int)0, (int)0, (int)mcFb.field_147621_c, (int)mcFb.field_147618_d);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        RenderUtils.enableLightmap();
        GlStateManager.func_179127_m();
    }

    private class SkyCapture
    implements Runnable {
        private SkyCapture() {
        }

        @Override
        public void run() {
            SkyBlockRenderer.this.skyCaptured = SkyBlockRenderer.this.lastRenderUsers > 0;
            if (!SkyBlockRenderer.this.skyCaptured) {
                return;
            }
            SkyBlockRenderer.this.lastRenderUsers = 0;
            Framebuffer mcFb = Minecraft.func_71410_x().func_147110_a();
            if (SkyBlockRenderer.this.skyFb == null) {
                SkyBlockRenderer.this.skyFb = new Framebuffer(mcFb.field_147621_c, mcFb.field_147618_d, false);
            } else if (((SkyBlockRenderer)SkyBlockRenderer.this).skyFb.field_147621_c != mcFb.field_147621_c || ((SkyBlockRenderer)SkyBlockRenderer.this).skyFb.field_147618_d != mcFb.field_147618_d) {
                SkyBlockRenderer.this.skyFb.func_147613_a(mcFb.field_147621_c, mcFb.field_147618_d);
            }
            FramebufferBlitter.INSTANCE.blitFramebuffer(mcFb, SkyBlockRenderer.this.skyFb);
            mcFb.func_147610_a(false);
        }
    }
}

