/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_Connector;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFeedthrough;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiblockFeedthrough
implements MultiblockHandler.IMultiblock {
    public static MultiblockFeedthrough instance = new MultiblockFeedthrough();
    static ItemStack[][][] structure = new ItemStack[1][1][3];
    private ItemStack renderStack;

    @Override
    public ItemStack[][][] getStructureManual() {
        return structure;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean overwriteBlockRender(ItemStack stack, int iterator) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderFormedStructure() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFormedStructure() {
        if (this.renderStack == null || this.renderStack.func_190926_b()) {
            this.renderStack = new ItemStack(IEContent.blockConnectors, 1, BlockTypes_Connector.FEEDTHROUGH.getMeta());
        }
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)1.5);
        GlStateManager.func_179114_b((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)1.75, (double)1.75, (double)1.75);
        GlStateManager.func_179129_p();
        ClientUtils.mc().func_175599_af().func_181564_a(this.renderStack, ItemCameraTransforms.TransformType.GUI);
        GlStateManager.func_179089_o();
    }

    @Override
    public IBlockState getBlockstateFromStack(int index, ItemStack stack) {
        IBlockState ret = MultiblockHandler.IMultiblock.super.getBlockstateFromStack(index, stack);
        if (stack == structure[0][0][0]) {
            return ret.func_177226_a((IProperty)IEProperties.FACING_ALL, (Comparable)EnumFacing.SOUTH);
        }
        return ret;
    }

    @Override
    public float getManualScale() {
        return 12.0f;
    }

    @Override
    public String getUniqueName() {
        return "IE:Feedthrough";
    }

    @Override
    public boolean isBlockTrigger(IBlockState state) {
        return WireApi.getWireType(state) != null;
    }

    @Override
    public boolean createStructure(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        ImmutableSet connHere;
        IBlockState stateHere = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
        if (stateHere.func_177227_a().contains(IEProperties.FACING_ALL)) {
            side = (EnumFacing)stateHere.func_177229_b((IProperty)IEProperties.FACING_ALL);
        }
        if ((connHere = ImmersiveNetHandler.INSTANCE.getConnections(world, pos)) == null) {
            connHere = ImmutableSet.of();
        }
        if (connHere.size() > 1) {
            return false;
        }
        WireType wire = WireApi.getWireType(stateHere);
        if (wire == null) {
            return false;
        }
        BlockPos middlePos = pos.func_177972_a(side);
        IBlockState middle = world.func_180495_p(middlePos).func_185899_b((IBlockAccess)world, middlePos);
        if (!middle.func_185917_h() || middle.func_177230_c().hasTileEntity(middle) || middle.func_185901_i() != EnumBlockRenderType.MODEL) {
            return false;
        }
        BlockPos otherPos = pos.func_177967_a(side, 2);
        IBlockState otherConn = world.func_180495_p(otherPos).func_185899_b((IBlockAccess)world, otherPos);
        if (WireApi.getWireType(otherConn) != wire) {
            return false;
        }
        if (otherConn.func_177229_b((IProperty)IEProperties.FACING_ALL) != side.func_176734_d()) {
            return false;
        }
        ImmutableSet connOther = ImmersiveNetHandler.INSTANCE.getConnections(world, otherPos);
        if (connOther == null) {
            connOther = ImmutableSet.of();
        }
        if (connOther.size() > 1) {
            return false;
        }
        if (connOther.stream().anyMatch(c -> c.end.equals((Object)pos))) {
            return false;
        }
        for (ImmersiveNetHandler.Connection c3 : connOther) {
            if (!connHere.stream().anyMatch(c2 -> c2.end.equals((Object)c.end))) continue;
            return false;
        }
        if (!world.field_72995_K) {
            IBlockState state = IEContent.blockConnectors.func_176223_P().func_177226_a(IEContent.blockConnectors.property, (Comparable)((Object)BlockTypes_Connector.FEEDTHROUGH)).func_177226_a((IProperty)IEProperties.FACING_ALL, (Comparable)side);
            BlockPos masterPos = pos.func_177972_a(side);
            TileEntityFeedthrough master = this.setBlock(world, masterPos, state, wire, middle, 0);
            if (master != null) {
                this.moveConnectionsToMaster((Collection<ImmersiveNetHandler.Connection>)connOther, world, true, master);
                this.moveConnectionsToMaster((Collection<ImmersiveNetHandler.Connection>)connHere, world, false, master);
                master.markContainingBlockForUpdate(null);
            }
            this.setBlock(world, pos, state, wire, middle, -1);
            this.setBlock(world, pos.func_177967_a(side, 2), state, wire, middle, 1);
        }
        return true;
    }

    private void moveConnectionsToMaster(Collection<ImmersiveNetHandler.Connection> conns, World world, boolean positive, TileEntityFeedthrough master) {
        BlockPos masterPos = master.func_174877_v();
        for (ImmersiveNetHandler.Connection c : ImmutableSet.copyOf(conns)) {
            ImmersiveNetHandler.Connection reverse = ImmersiveNetHandler.INSTANCE.getReverseConnection(world.field_73011_w.getDimension(), c);
            if (positive) {
                master.connPositive = c.end;
            } else {
                master.hasNegative = true;
            }
            ApiUtils.moveConnectionEnd(reverse, masterPos, world);
        }
    }

    @Nullable
    private TileEntityFeedthrough setBlock(World world, BlockPos here, IBlockState newState, WireType wire, IBlockState middle, int offset) {
        world.func_175656_a(here, newState);
        TileEntity te = world.func_175625_s(here);
        if (te instanceof TileEntityFeedthrough) {
            TileEntityFeedthrough feedthrough = (TileEntityFeedthrough)te;
            feedthrough.reference = wire;
            feedthrough.stateForMiddle = middle;
            feedthrough.offset = offset;
            world.func_175664_x(here);
            world.func_175641_c(here, feedthrough.func_145838_q(), 253, 0);
            return feedthrough;
        }
        return null;
    }

    @Override
    public IngredientStack[] getTotalMaterials() {
        return new IngredientStack[]{new IngredientStack(new ItemStack(IEContent.blockConnectors, 2)), new IngredientStack(new ItemStack(Blocks.field_150342_X, 1).func_190924_f("Arbitrary solid block"))};
    }

    static {
        MultiblockFeedthrough.structure[0][0][0] = new ItemStack(IEContent.blockConnectors, 1);
        MultiblockFeedthrough.structure[0][0][1] = new ItemStack(Blocks.field_150342_X, 1).func_190924_f("tile.immersiveengineering.arb_solid.name");
        MultiblockFeedthrough.structure[0][0][2] = new ItemStack(IEContent.blockConnectors, 1);
    }
}

