/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration2;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class TileEntityStructuralArm
extends TileEntityIEBase
implements IOBJModelCallback<IBlockState>,
IEBlockInterfaces.INeighbourChangeTile,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IAdvancedSelectionBounds {
    private int totalLength = 1;
    private int slopePosition = 0;
    private EnumFacing facing = EnumFacing.NORTH;
    private boolean onCeiling = false;
    private List<AxisAlignedBB> bounds = null;
    private static final Matrix4 SHRINK = new Matrix4();

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        int oldLength = this.totalLength;
        int oldPos = this.slopePosition;
        this.totalLength = nbt.func_74762_e("totalLength");
        this.slopePosition = nbt.func_74762_e("slopePosition");
        this.onCeiling = nbt.func_74767_n("onCeiling");
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && (oldLength != this.totalLength || this.slopePosition != oldPos)) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.bounds = null;
        }
        this.facing = EnumFacing.field_82609_l[nbt.func_74762_e("facing")];
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("totalLength", this.totalLength);
        nbt.func_74768_a("slopePosition", this.slopePosition);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74757_a("onCeiling", this.onCeiling);
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        boolean atEnd;
        boolean positive;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (otherPos.equals((Object)this.field_174879_c.func_177967_a(this.facing, 1))) {
            positive = true;
        } else if (otherPos.equals((Object)this.field_174879_c.func_177967_a(this.facing, -1))) {
            positive = false;
        } else {
            return;
        }
        TileEntityStructuralArm slope = null;
        TileEntity atOther = this.field_145850_b.func_175625_s(otherPos);
        if (atOther instanceof TileEntityStructuralArm) {
            TileEntityStructuralArm tmp = (TileEntityStructuralArm)atOther;
            IBlockState stateHere = this.field_145850_b.func_180495_p(this.field_174879_c);
            IBlockState stateThere = this.field_145850_b.func_180495_p(otherPos);
            BlockTypes_MetalDecoration2 typeHere = (BlockTypes_MetalDecoration2)((Object)stateHere.func_177229_b(IEContent.blockMetalDecoration2.property));
            BlockTypes_MetalDecoration2 typeOther = (BlockTypes_MetalDecoration2)((Object)stateThere.func_177229_b(IEContent.blockMetalDecoration2.property));
            if (tmp.facing == this.facing && typeHere == typeOther) {
                slope = (TileEntityStructuralArm)atOther;
            }
        }
        if ((atEnd = this.isAtEnd(positive)) == (slope == null)) {
            return;
        }
        if (slope == null) {
            int toEnd = this.blocksToEnd(positive);
            this.forEachSlopeBlockBeyond(positive, false, true, other -> {
                other.totalLength = toEnd - 1;
                if (positive) {
                    other.slopePosition -= this.slopePosition + 2;
                }
                other.bounds = null;
                this.updateNoNeighbours(other.field_174879_c);
            });
            this.forEachSlopeBlockBeyond(!positive, true, true, other -> {
                other.totalLength = this.totalLength - toEnd;
                if (!positive) {
                    other.slopePosition -= this.slopePosition;
                }
                other.bounds = null;
                this.updateNoNeighbours(other.field_174879_c);
            });
        } else {
            int oldLength = this.totalLength;
            if (!positive) {
                this.slopePosition += slope.totalLength;
            }
            this.totalLength += slope.totalLength;
            this.forEachSlopeBlockBeyond(positive, false, false, other -> {
                other.totalLength = this.totalLength;
                if (positive) {
                    other.slopePosition += oldLength;
                }
                other.bounds = null;
                this.updateNoNeighbours(other.field_174879_c);
            });
            this.forEachSlopeBlockBeyond(!positive, false, false, other -> {
                other.totalLength = this.totalLength;
                if (!positive) {
                    other.slopePosition += this.totalLength - oldLength;
                }
                other.bounds = null;
                this.updateNoNeighbours(other.field_174879_c);
            });
            this.bounds = null;
        }
        this.updateNoNeighbours(this.field_174879_c);
    }

    private boolean isAtEnd(boolean positive) {
        if (positive) {
            return this.slopePosition == this.totalLength - 1;
        }
        return this.slopePosition == 0;
    }

    private int blocksToEnd(boolean positive) {
        if (positive) {
            return this.totalLength - this.slopePosition - 1;
        }
        return this.slopePosition;
    }

    private void forEachSlopeBlockBeyond(boolean positive, boolean includeThis, boolean removing, Consumer<TileEntityStructuralArm> out) {
        if (positive) {
            for (int i = 1; i < this.totalLength - this.slopePosition; ++i) {
                this.acceptIfValid(i, removing, out);
            }
        } else {
            for (int i = -1; i >= -this.slopePosition; --i) {
                this.acceptIfValid(i, removing, out);
            }
        }
        if (includeThis) {
            out.accept(this);
        }
    }

    private void acceptIfValid(int offsetToHere, boolean removing, Consumer<TileEntityStructuralArm> out) {
        BlockPos posI = this.field_174879_c.func_177967_a(this.facing, offsetToHere);
        TileEntity teAtI = this.field_145850_b.func_175625_s(posI);
        if (teAtI instanceof TileEntityStructuralArm) {
            TileEntityStructuralArm slope = (TileEntityStructuralArm)teAtI;
            int offsetAtPos = this.slopePosition + offsetToHere;
            IBlockState stateHere = this.field_145850_b.func_180495_p(this.field_174879_c);
            IBlockState otherState = this.field_145850_b.func_180495_p(posI);
            BlockTypes_MetalDecoration2 typeHere = (BlockTypes_MetalDecoration2)((Object)stateHere.func_177229_b(IEContent.blockMetalDecoration2.property));
            BlockTypes_MetalDecoration2 typeOther = (BlockTypes_MetalDecoration2)((Object)otherState.func_177229_b(IEContent.blockMetalDecoration2.property));
            if ((!removing || slope.totalLength == this.totalLength && slope.slopePosition == offsetAtPos && slope.onCeiling == this.onCeiling) && typeHere == typeOther && slope.facing == this.facing) {
                out.accept(slope);
            }
        }
    }

    private void updateNoNeighbours(BlockPos pos) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        this.field_145850_b.func_184138_a(pos, state, state, 3);
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
        this.totalLength = 1;
        this.slopePosition = 0;
        this.bounds = null;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        }
    }

    @Override
    public EnumFacing getFacingForPlacement(EntityLivingBase placer, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.onCeiling = side == EnumFacing.DOWN || side != EnumFacing.UP && (double)hitY > 0.5;
        return IEBlockInterfaces.IDirectionalTile.super.getFacingForPlacement(placer, pos, side, hitX, hitY, hitZ);
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return side.func_176740_k() == EnumFacing.Axis.Y;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return axis.func_176740_k() == EnumFacing.Axis.Y;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        return this.getBounds();
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getBounds();
    }

    private List<AxisAlignedBB> getBounds() {
        if (this.bounds == null) {
            double lowerH = ((double)this.slopePosition + 0.5) / (double)this.totalLength;
            double upperH = ((double)this.slopePosition + 1.0) / (double)this.totalLength;
            ImmutableList basic = !this.onCeiling ? ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, lowerH, 1.0), (Object)new AxisAlignedBB(0.0, lowerH, 0.0, 1.0, upperH, 0.5)) : ImmutableList.of((Object)new AxisAlignedBB(0.0, 1.0 - lowerH, 0.0, 1.0, 1.0, 1.0), (Object)new AxisAlignedBB(0.0, 1.0 - upperH, 0.0, 1.0, 1.0 - lowerH, 0.5));
            this.bounds = (List)basic.stream().map(aabb -> Utils.transformAABB(aabb, this.facing).func_186670_a(this.field_174879_c)).collect(ImmutableList.toImmutableList());
        }
        return this.bounds;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> modifyQuads(IBlockState object, List<BakedQuad> quads) {
        float lowerHeight = (float)this.slopePosition / (float)this.totalLength;
        float upperHeight = ((float)this.slopePosition + 1.0f) / (float)this.totalLength;
        double lowerV = 16.0f * lowerHeight;
        double upperV = 16.0f * upperHeight;
        TextureAtlasSprite tas = quads.get(0).func_187508_a();
        VertexFormat format = quads.get(0).getFormat();
        quads = new ArrayList<BakedQuad>();
        Matrix4 mat = new Matrix4(this.facing);
        float y03 = this.onCeiling ? 1.0f : upperHeight;
        float y12 = this.onCeiling ? 1.0f : lowerHeight;
        float y47 = this.onCeiling ? 1.0f - upperHeight : 0.0f;
        float y56 = this.onCeiling ? 1.0f - lowerHeight : 0.0f;
        Vector3f[] vertices = new Vector3f[]{new Vector3f(0.0f, y03, 0.0f), new Vector3f(0.0f, y12, 1.0f), new Vector3f(1.0f, y12, 1.0f), new Vector3f(1.0f, y03, 0.0f), new Vector3f(0.0f, y47, 0.0f), new Vector3f(0.0f, y56, 1.0f), new Vector3f(1.0f, y56, 1.0f), new Vector3f(1.0f, y47, 0.0f)};
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = mat.apply(vertices[i]);
        }
        this.addCulledQuad(quads, format, Arrays.copyOf(vertices, 4), EnumFacing.UP, tas, new double[]{0.0, 0.0, 16.0, 16.0}, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        this.addCulledQuad(quads, format, this.getArrayByIndices(vertices, 7, 6, 5, 4), EnumFacing.DOWN, tas, new double[]{0.0, 0.0, 16.0, 16.0}, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        this.addSides(quads, vertices, tas, lowerV, upperV, false);
        this.addSides(quads, vertices, tas, lowerV, upperV, true);
        if (this.isAtEnd(true)) {
            this.addCulledQuad(quads, format, this.getArrayByIndices(vertices, 0, 3, 7, 4), EnumFacing.NORTH, tas, new double[]{0.0, 0.0, 16.0, 16.0}, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        }
        return quads;
    }

    private void addCulledQuad(List<BakedQuad> quads, VertexFormat format, Vector3f[] vertices, EnumFacing side, TextureAtlasSprite tas, double[] uvs, float[] alpha) {
        side = Utils.rotateFacingTowardsDir(side, this.facing);
        quads.add(ClientUtils.createBakedQuad(format, vertices, side, tas, uvs, alpha, false));
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = SHRINK.apply(vertices[i]);
        }
        quads.add(ClientUtils.createBakedQuad(format, vertices, side.func_176734_d(), tas, uvs, alpha, true));
    }

    private void addSides(List<BakedQuad> quads, Vector3f[] vertices, TextureAtlasSprite tas, double lowerV, double upperV, boolean invert) {
        if (invert) {
            for (int i = 0; i < vertices.length; ++i) {
                vertices[i] = SHRINK.apply(vertices[i]);
            }
        }
        quads.add(this.createSide(DefaultVertexFormats.field_176599_b, this.getArrayByIndices(vertices, 5, 1, 0, 4), EnumFacing.WEST, tas, lowerV, upperV, invert));
        quads.add(this.createSide(DefaultVertexFormats.field_176599_b, this.getArrayByIndices(vertices, 7, 3, 2, 6), EnumFacing.EAST, tas, upperV, lowerV, invert));
    }

    @SideOnly(value=Side.CLIENT)
    private BakedQuad createSide(VertexFormat format, Vector3f[] vertices, EnumFacing facing, TextureAtlasSprite sprite, double leftV, double rightV, boolean invert) {
        facing = Utils.rotateFacingTowardsDir(facing, this.facing);
        if (invert) {
            double tmp = leftV;
            leftV = rightV;
            rightV = tmp;
        }
        if (invert) {
            facing = facing.func_176734_d();
        }
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadOrientation(facing);
        builder.setTexture(sprite);
        OBJModel.Normal faceNormal = new OBJModel.Normal((float)facing.func_176730_m().func_177958_n(), (float)facing.func_176730_m().func_177956_o(), (float)facing.func_176730_m().func_177952_p());
        int vertexId = invert ? 3 : 0;
        double v = this.onCeiling ? 16.0 - leftV : 0.0;
        ClientUtils.putVertexData(format, builder, vertices[vertexId], faceNormal, vertexId > 1 ? 16.0 : 0.0, v, sprite, colour, 1.0f);
        vertexId = invert ? 2 : 1;
        v = this.onCeiling ? 16.0 : leftV;
        ClientUtils.putVertexData(format, builder, vertices[vertexId], faceNormal, vertexId > 1 ? 16.0 : 0.0, v, sprite, colour, 1.0f);
        vertexId = invert ? 1 : 2;
        v = this.onCeiling ? 16.0 : rightV;
        ClientUtils.putVertexData(format, builder, vertices[vertexId], faceNormal, vertexId > 1 ? 16.0 : 0.0, v, sprite, colour, 1.0f);
        vertexId = invert ? 0 : 3;
        v = this.onCeiling ? 16.0 - rightV : 0.0;
        ClientUtils.putVertexData(format, builder, vertices[vertexId], faceNormal, vertexId > 1 ? 16.0 : 0.0, v, sprite, colour, 1.0f);
        return builder.build();
    }

    private Vector3f[] getArrayByIndices(Vector3f[] in, int ... indices) {
        Vector3f[] ret = new Vector3f[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = in[indices[i]];
        }
        return ret;
    }

    @Override
    public String getCacheKey(IBlockState object) {
        return this.totalLength + "," + this.slopePosition + "," + this.facing.name() + "," + (this.onCeiling ? "1" : "0");
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, ((float)this.slopePosition + 0.5f) / (float)this.totalLength, 1.0f};
    }

    static {
        SHRINK.translate(0.5, 0.5, 0.5);
        SHRINK.scale(0.999, 0.999, 0.999);
        SHRINK.translate(-0.5, -0.5, -0.5);
    }
}

