/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorCovered;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorExtractCovered;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorVertical;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorVerticalCovered;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityConveyorBelt
extends TileEntityIEBase
implements IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IPlayerInteraction,
ConveyorHandler.IConveyorTile,
IEBlockInterfaces.IPropertyPassthrough,
IEBlockInterfaces.ITileDrop,
ITickable,
IEBlockInterfaces.IGeneralMultiblock,
IEBlockInterfaces.IFaceShape {
    public EnumFacing facing = EnumFacing.NORTH;
    private ConveyorHandler.IConveyorBelt conveyorBeltSubtype;
    static AxisAlignedBB COLISIONBB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    IItemHandler insertionHandler = new ConveyorInventoryHandler(this);

    @Override
    @Nullable
    public ConveyorHandler.IConveyorBelt getConveyorSubtype() {
        return this.conveyorBeltSubtype;
    }

    @Override
    public void setConveyorSubtype(ConveyorHandler.IConveyorBelt conveyor) {
        this.conveyorBeltSubtype = conveyor;
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (this.conveyorBeltSubtype != null) {
            this.conveyorBeltSubtype.onEntityCollision(this, entity, this.facing);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        if (nbt.func_74764_b("conveyorBeltSubtype")) {
            this.conveyorBeltSubtype = ConveyorHandler.getConveyor(new ResourceLocation(nbt.func_74779_i("conveyorBeltSubtype")), this);
            this.conveyorBeltSubtype.readConveyorNBT(nbt.func_74775_l("conveyorBeltSubtypeNBT"));
        }
        if (descPacket && this.field_145850_b != null) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("facing", this.facing.ordinal());
        if (this.conveyorBeltSubtype != null) {
            nbt.func_74778_a("conveyorBeltSubtype", ConveyorHandler.reverseClassRegistry.get(this.conveyorBeltSubtype.getClass()).toString());
            nbt.func_74782_a("conveyorBeltSubtypeNBT", (NBTBase)this.conveyorBeltSubtype.writeConveyorNBT());
        }
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 5;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return !entity.func_70093_af();
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    @Override
    public void afterRotation(EnumFacing oldDir, EnumFacing newDir) {
        if (this.conveyorBeltSubtype != null) {
            this.conveyorBeltSubtype.afterRotation(oldDir, newDir);
        }
    }

    @Override
    public boolean isLogicDummy() {
        return this.conveyorBeltSubtype != null && !this.conveyorBeltSubtype.isTicking(this);
    }

    public void func_73660_a() {
        ApiUtils.checkForNeedlessTicking(this);
        if (this.conveyorBeltSubtype != null) {
            this.conveyorBeltSubtype.onUpdate(this, this.getFacing());
        }
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && this.conveyorBeltSubtype != null && this.conveyorBeltSubtype.changeConveyorDirection()) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        EnumDyeColor dye;
        boolean update;
        if (this.conveyorBeltSubtype != null && (update = this.conveyorBeltSubtype.canBeDyed() && Utils.isDye(heldItem) ? (dye = EnumDyeColor.func_176766_a((int)Utils.getDye(heldItem))) != null && this.conveyorBeltSubtype.setDyeColour(dye.func_193350_e()) : this.conveyorBeltSubtype.playerInteraction(this, player, hand, heldItem, hitX, hitY, hitZ, side))) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
            return true;
        }
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f};
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        if (this.conveyorBeltSubtype != null) {
            ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
            for (AxisAlignedBB aabb : this.conveyorBeltSubtype.getColisionBoxes(this, this.facing)) {
                boxes.add(aabb.func_186670_a(this.func_174877_v()));
            }
            return boxes;
        }
        return Lists.newArrayList((Object[])new AxisAlignedBB[]{COLISIONBB.func_186670_a(this.func_174877_v())});
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        if (this.conveyorBeltSubtype != null) {
            ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
            for (AxisAlignedBB aabb : this.conveyorBeltSubtype.getSelectionBoxes(this, this.facing)) {
                boxes.add(aabb.func_186670_a(this.func_174877_v()));
            }
            return boxes;
        }
        return Lists.newArrayList((Object[])new AxisAlignedBB[]{COLISIONBB.func_186670_a(this.func_174877_v())});
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.insertionHandler;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c());
        if (this.conveyorBeltSubtype != null) {
            ItemNBTHelper.setString(stack, "conveyorType", ConveyorHandler.reverseClassRegistry.get(this.conveyorBeltSubtype.getClass()).toString());
        }
        return stack;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        String key = ItemNBTHelper.getString(stack, "conveyorType");
        ConveyorHandler.IConveyorBelt subType = ConveyorHandler.getConveyor(new ResourceLocation(key), this);
        this.setConveyorSubtype(subType);
    }

    @Override
    public BlockFaceShape getFaceShape(EnumFacing side) {
        ConveyorHandler.IConveyorBelt subtype = this.getConveyorSubtype();
        if (subtype == null) {
            return BlockFaceShape.UNDEFINED;
        }
        if (side == EnumFacing.DOWN && subtype.getConveyorDirection() == ConveyorHandler.ConveyorDirection.HORIZONTAL) {
            return BlockFaceShape.SOLID;
        }
        if (subtype instanceof ConveyorVertical) {
            if (side == this.facing) {
                return BlockFaceShape.SOLID;
            }
            if (side.func_176740_k() == EnumFacing.Axis.Y) {
                return BlockFaceShape.UNDEFINED;
            }
        }
        if ((subtype instanceof ConveyorCovered || subtype instanceof ConveyorVerticalCovered || subtype instanceof ConveyorExtractCovered) && side.func_176740_k() != this.facing.func_176740_k()) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public static class ConveyorInventoryHandler
    implements IItemHandlerModifiable {
        TileEntityConveyorBelt conveyor;

        public ConveyorInventoryHandler(TileEntityConveyorBelt conveyor) {
            this.conveyor = conveyor;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!simulate) {
                EntityItem entity = new EntityItem(this.conveyor.func_145831_w(), (double)this.conveyor.func_174877_v().func_177958_n() + 0.5, (double)this.conveyor.func_174877_v().func_177956_o() + 0.1875, (double)this.conveyor.func_174877_v().func_177952_p() + 0.5, stack.func_77946_l());
                entity.field_70159_w = 0.0;
                entity.field_70181_x = 0.0;
                entity.field_70179_y = 0.0;
                this.conveyor.func_145831_w().func_72838_d((Entity)entity);
                if (this.conveyor.conveyorBeltSubtype != null) {
                    this.conveyor.conveyorBeltSubtype.onItemDeployed(this.conveyor, entity, this.conveyor.facing);
                }
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }
}

