/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.xnet.api.channels.IChannelType;
import mcjty.xnet.api.channels.IConnectorSettings;
import mcjty.xnet.api.keys.NetworkId;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.blocks.generic.CableColor;
import mcjty.xnet.blocks.router.GuiRouter;
import mcjty.xnet.blocks.router.LocalChannelId;
import mcjty.xnet.clientinfo.ControllerChannelClientInfo;
import mcjty.xnet.config.GeneralConfiguration;
import mcjty.xnet.logic.ChannelInfo;
import mcjty.xnet.logic.LogicTools;
import mcjty.xnet.multiblock.BlobId;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WirelessChannelKey;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import org.apache.commons.lang3.tuple.Pair;

public final class TileEntityRouter
extends GenericTileEntity {
    public static final String CMD_UPDATENAME = "router.updateName";
    public static final Key<BlockPos> PARAM_POS = new Key("pos", Type.BLOCKPOS);
    public static final Key<Integer> PARAM_CHANNEL = new Key("channel", Type.INTEGER);
    public static final Key<String> PARAM_NAME = new Key("name", Type.STRING);
    public static final String CMD_GETCHANNELS = "getChannelInfo";
    public static final String CLIENTCMD_CHANNELSREADY = "channelsReady";
    public static final String CMD_GETREMOTECHANNELS = "getRemoteChannelInfo";
    public static final String CLIENTCMD_CHANNELSREMOTEREADY = "channelsRemoteReady";
    public static final PropertyBool ERROR = PropertyBool.func_177716_a((String)"error");
    private Map<LocalChannelId, String> publishedChannels = new HashMap<LocalChannelId, String>();
    private int channelCount = 0;

    public void addPublishedChannels(Set<String> channels) {
        channels.addAll(this.publishedChannels.values());
    }

    public int countPublishedChannelsOnNet() {
        HashSet channels = new HashSet();
        NetworkId networkId = this.findRoutingNetwork();
        if (networkId != null) {
            LogicTools.routers(this.func_145831_w(), networkId).forEach(router -> router.addPublishedChannels(channels));
        }
        return channels.size();
    }

    public boolean inError() {
        return this.channelCount > GeneralConfiguration.maxPublishedChannels;
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public void setChannelCount(int cnt) {
        if (this.channelCount == cnt) {
            return;
        }
        this.channelCount = cnt;
        this.markDirtyClient();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean oldError = this.inError();
        super.onDataPacket(net, packet);
        if (this.func_145831_w().field_72995_K && oldError != this.inError()) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        return super.func_189515_b(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("chancnt", this.channelCount);
        NBTTagList published = new NBTTagList();
        for (Map.Entry<LocalChannelId, String> entry : this.publishedChannels.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            BlockPosTools.writeToNBT((NBTTagCompound)tc, (String)"pos", (BlockPos)entry.getKey().getControllerPos());
            tc.func_74768_a("index", entry.getKey().getIndex());
            tc.func_74778_a("name", entry.getValue());
            published.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("published", (NBTBase)published);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.channelCount = tagCompound.func_74762_e("chancnt");
        NBTTagList published = tagCompound.func_150295_c("published", 10);
        for (int i = 0; i < published.func_74745_c(); ++i) {
            NBTTagCompound tc = published.func_150305_b(i);
            LocalChannelId id = new LocalChannelId(BlockPosTools.readFromNBT((NBTTagCompound)tc, (String)"pos"), tc.func_74762_e("index"));
            String name = tc.func_74779_i("name");
            this.publishedChannels.put(id, name);
        }
    }

    public Stream<Pair<String, IChannelType>> publishedChannelStream() {
        return LogicTools.connectors(this.field_145850_b, this.field_174879_c).map(connectorPos -> LogicTools.getControllerForConnector(this.func_145831_w(), connectorPos)).filter(Objects::nonNull).flatMap(controller -> IntStream.range(0, 8).mapToObj(i -> {
            LocalChannelId id;
            String publishedName;
            ChannelInfo channelInfo = controller.getChannels()[i];
            if (channelInfo != null && !channelInfo.getChannelName().isEmpty() && (publishedName = this.publishedChannels.get(id = new LocalChannelId(controller.func_174877_v(), i))) != null && !publishedName.isEmpty()) {
                return Pair.of((Object)publishedName, (Object)channelInfo.getType());
            }
            return null;
        }).filter(Objects::nonNull));
    }

    public void findLocalChannelInfo(List<ControllerChannelClientInfo> list, boolean onlyPublished, boolean remote) {
        LogicTools.connectors(this.func_145831_w(), this.func_174877_v()).map(connectorPos -> LogicTools.getControllerForConnector(this.func_145831_w(), connectorPos)).filter(Objects::nonNull).forEach(controller -> {
            for (int i = 0; i < 8; ++i) {
                ChannelInfo channelInfo = controller.getChannels()[i];
                if (channelInfo == null || channelInfo.getChannelName().isEmpty()) continue;
                LocalChannelId id = new LocalChannelId(controller.func_174877_v(), i);
                String publishedName = this.publishedChannels.get(id);
                if (publishedName == null) {
                    publishedName = "";
                }
                if (onlyPublished && publishedName.isEmpty()) continue;
                ControllerChannelClientInfo ci = new ControllerChannelClientInfo(channelInfo.getChannelName(), publishedName, controller.func_174877_v(), channelInfo.getType(), remote, i);
                if (!list.stream().noneMatch(ii -> Objects.equals(ii.getPublishedName(), ci.getPublishedName()) && Objects.equals(ii.getChannelName(), ci.getChannelName()) && Objects.equals(ii.getChannelType(), ci.getChannelType()) && Objects.equals(ii.getPos(), ci.getPos()))) continue;
                list.add(ci);
            }
        });
    }

    private void findRemoteChannelInfo(List<ControllerChannelClientInfo> list) {
        NetworkId networkId = this.findRoutingNetwork();
        if (networkId != null) {
            LogicTools.consumers(this.field_145850_b, networkId).forEach(consumerPos -> {
                LogicTools.routers(this.field_145850_b, consumerPos).filter(r -> r != this).forEach(router -> router.findLocalChannelInfo(list, true, false));
                LogicTools.wirelessRouters(this.field_145850_b, consumerPos).filter(router -> !router.inError()).forEach(router -> router.findRemoteChannelInfo(list));
            });
        }
    }

    @Nullable
    public NetworkId findRoutingNetwork() {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        return LogicTools.routingConnectors(this.func_145831_w(), this.func_174877_v()).findFirst().map(worldBlob::getNetworkAt).orElse(null);
    }

    public void addRoutedConnectors(Map<SidedConsumer, IConnectorSettings> connectors, @Nonnull BlockPos controllerPos, int channel, IChannelType type, Map<WirelessChannelKey, Integer> wirelessVersions) {
        if (this.inError()) {
            return;
        }
        LocalChannelId id = new LocalChannelId(controllerPos, channel);
        String publishedName = this.publishedChannels.get(id);
        if (publishedName != null && !publishedName.isEmpty()) {
            NetworkId networkId = this.findRoutingNetwork();
            if (networkId != null) {
                LogicTools.consumers(this.func_145831_w(), networkId).forEach(consumerPos -> {
                    LogicTools.routers(this.field_145850_b, consumerPos).forEach(router -> router.addConnectorsFromConnectedNetworks(connectors, publishedName, type));
                    LogicTools.wirelessRouters(this.field_145850_b, consumerPos).filter(router -> !router.inError()).forEach(router -> {
                        router.addWirelessConnectors(connectors, publishedName, type, null, wirelessVersions);
                        router.addWirelessConnectors(connectors, publishedName, type, this.getOwnerUUID(), wirelessVersions);
                    });
                });
            } else {
                this.addConnectorsFromConnectedNetworks(connectors, publishedName, type);
            }
        }
    }

    public boolean addConnectorsFromConnectedNetworks(Map<SidedConsumer, IConnectorSettings> connectors, String channelName, IChannelType type) {
        AtomicBoolean rc = new AtomicBoolean(false);
        LogicTools.connectors(this.func_145831_w(), this.func_174877_v()).map(connectorPos -> LogicTools.getControllerForConnector(this.func_145831_w(), connectorPos)).filter(Objects::nonNull).forEach(controller -> {
            for (int i = 0; i < 8; ++i) {
                String publishedName;
                ChannelInfo info = controller.getChannels()[i];
                if (info == null || (publishedName = this.publishedChannels.get(new LocalChannelId(controller.func_174877_v(), i))) == null || publishedName.isEmpty() || !channelName.equals(publishedName) || !type.equals(info.getType())) continue;
                connectors.putAll(controller.getConnectors(i));
                rc.set(true);
            }
        });
        return rc.get();
    }

    private void updatePublishName(@Nonnull BlockPos controllerPos, int channel, String name) {
        LocalChannelId id = new LocalChannelId(controllerPos, channel);
        if (name == null || name.isEmpty()) {
            this.publishedChannels.remove(id);
        } else {
            this.publishedChannels.put(id, name);
        }
        int number = this.countPublishedChannelsOnNet();
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        NetworkId networkId = this.findRoutingNetwork();
        if (networkId != null) {
            if (number != this.channelCount) {
                LogicTools.routers(this.func_145831_w(), networkId).forEach(router -> router.setChannelCount(number));
            }
            worldBlob.markNetworkDirty(networkId);
        }
        for (NetworkId net : worldBlob.getNetworksAt(this.field_174879_c)) {
            worldBlob.markNetworkDirty(net);
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            for (NetworkId net : worldBlob.getNetworksAt(this.field_174879_c.func_177972_a(facing))) {
                worldBlob.markNetworkDirty(net);
            }
        }
        this.markDirtyQuick();
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_UPDATENAME.equals(command)) {
            BlockPos controllerPos = (BlockPos)params.get(PARAM_POS);
            int channel = (Integer)params.get(PARAM_CHANNEL);
            String name = (String)params.get(PARAM_NAME);
            this.updatePublishName(controllerPos, channel, name);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if (CMD_GETCHANNELS.equals(command)) {
            ArrayList<ControllerChannelClientInfo> list = new ArrayList<ControllerChannelClientInfo>();
            this.findLocalChannelInfo(list, false, false);
            return type.convert(list);
        }
        if (CMD_GETREMOTECHANNELS.equals(command)) {
            ArrayList<ControllerChannelClientInfo> list = new ArrayList<ControllerChannelClientInfo>();
            this.findRemoteChannelInfo(list);
            return type.convert(list);
        }
        return Collections.emptyList();
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if (CLIENTCMD_CHANNELSREADY.equals(command)) {
            GuiRouter.fromServer_localChannels = new ArrayList<ControllerChannelClientInfo>(Type.create(ControllerChannelClientInfo.class).convert(list));
            return true;
        }
        if (CLIENTCMD_CHANNELSREMOTEREADY.equals(command)) {
            GuiRouter.fromServer_remoteChannels = new ArrayList<ControllerChannelClientInfo>(Type.create(ControllerChannelClientInfo.class).convert(list));
            return true;
        }
        return false;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        XNetBlobData blobData = XNetBlobData.getBlobData(world);
        WorldBlob worldBlob = blobData.getWorldBlob(world);
        Set<NetworkId> networks = worldBlob.getNetworksAt(data.getPos());
        for (NetworkId networkId : networks) {
            probeInfo.text(TextStyleClass.LABEL + "Network: " + TextStyleClass.INFO + networkId.getId());
            if (mode == ProbeMode.EXTENDED) continue;
            break;
        }
        if (this.inError()) {
            probeInfo.text(TextStyleClass.ERROR + "Too many channels on router!");
        } else {
            probeInfo.text(TextStyleClass.LABEL + "Channels: " + TextStyleClass.INFO + this.getChannelCount());
        }
        if (mode == ProbeMode.DEBUG) {
            ColorId colorId;
            BlobId blobId = worldBlob.getBlobAt(data.getPos());
            if (blobId != null) {
                probeInfo.text(TextStyleClass.LABEL + "Blob: " + TextStyleClass.INFO + blobId.getId());
            }
            if ((colorId = worldBlob.getColorAt(data.getPos())) != null) {
                probeInfo.text(TextStyleClass.LABEL + "Color: " + TextStyleClass.INFO + colorId.getId());
            }
        }
    }

    public void onBlockBreak(World workd, BlockPos pos, IBlockState state) {
        super.onBlockBreak(workd, pos, state);
        if (!this.field_145850_b.field_72995_K) {
            XNetBlobData blobData = XNetBlobData.getBlobData(this.field_145850_b);
            WorldBlob worldBlob = blobData.getWorldBlob(this.field_145850_b);
            worldBlob.removeCableSegment(pos);
            blobData.save();
        }
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            XNetBlobData blobData = XNetBlobData.getBlobData(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            NetworkId networkId = worldBlob.newNetwork();
            worldBlob.createNetworkProvider(pos, new ColorId(CableColor.ROUTING.ordinal() + 1), networkId);
            blobData.save();
        }
    }

    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a((IProperty)ERROR, (Comparable)Boolean.valueOf(this.inError()));
    }
}

