/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.dynamic.StatusModelData;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersComp;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCompDrawers
extends BlockDrawers
implements INetworked {
    public static final PropertyEnum SLOTS = PropertyEnum.func_177709_a((String)"slots", EnumCompDrawer.class);
    @SideOnly(value=Side.CLIENT)
    private StatusModelData statusInfo;

    public BlockCompDrawers(String registryName, String blockName) {
        super(Material.field_151576_e, registryName, blockName);
        this.func_149672_a(SoundType.field_185851_d);
    }

    @Override
    protected void initDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SLOTS, (Comparable)((Object)EnumCompDrawer.OPEN1)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initDynamic() {
        ResourceLocation location = new ResourceLocation("storagedrawers:models/dynamic/compDrawers.json");
        this.statusInfo = new StatusModelData(3, location);
    }

    @Override
    public StatusModelData getStatusInfo(IBlockState state) {
        return this.statusInfo;
    }

    @Override
    public int getDrawerCount(IBlockState state) {
        return 3;
    }

    @Override
    public boolean isHalfDepth(IBlockState state) {
        return false;
    }

    @Override
    protected int getDrawerSlot(int drawerCount, int side, float hitX, float hitY, float hitZ) {
        if (this.hitTop(hitY)) {
            return 0;
        }
        if (this.hitLeft(side, hitX, hitZ)) {
            return 1;
        }
        return 2;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P();
    }

    @Override
    public BlockType retrimType() {
        return null;
    }

    public TileEntityDrawers createNewTileEntity(World world, int meta) {
        return new TileEntityDrawersComp();
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{SLOTS, FACING}, new IUnlistedProperty[]{STATE_MODEL});
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityDrawers tile = this.getTileEntity(world, pos);
        if (tile == null) {
            return state;
        }
        EnumCompDrawer slots = EnumCompDrawer.OPEN1;
        if (tile.getDrawer(1).isEnabled()) {
            slots = EnumCompDrawer.OPEN2;
        }
        if (tile.getDrawer(2).isEnabled()) {
            slots = EnumCompDrawer.OPEN3;
        }
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)SLOTS, (Comparable)((Object)slots));
    }
}

