/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.IMaskedRedstonePart;
import codechicken.multipart.IRedstoneConnector;
import codechicken.multipart.IRedstoneConnectorBlock;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.IRedstoneTile;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.math.package$;

public final class RedstoneInteractions$ {
    public static final RedstoneInteractions$ MODULE$;
    private final Set<Block> fullVanillaBlocks;

    static {
        new RedstoneInteractions$();
    }

    public Set<Block> fullVanillaBlocks() {
        return this.fullVanillaBlocks;
    }

    public int getPowerTo(TMultiPart p, int side) {
        TileMultipart tile = p.tile();
        return this.getPowerTo(tile.func_145831_w(), tile.func_174877_v(), side, ((IRedstoneTile)((Object)tile)).openConnections(side) & this.connectionMask(p, side));
    }

    public int getPowerTo(World world, BlockPos pos, int side, int mask) {
        return this.getPower(world, pos.func_177972_a(EnumFacing.field_82609_l[side]), side ^ 1, mask);
    }

    public int getPower(World world, BlockPos pos, int side, int mask) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IRedstoneConnector) {
            return ((IRedstoneConnector)tile).weakPowerLevel(side, mask);
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IRedstoneConnectorBlock) {
            return ((IRedstoneConnectorBlock)block).weakPowerLevel((IBlockAccess)world, pos, side, mask);
        }
        int vmask = this.vanillaConnectionMask(state, (IBlockAccess)world, pos, side, true);
        if ((vmask & mask) > 0) {
            int m = world.func_175651_c(pos, EnumFacing.field_82609_l[side ^ 1]);
            if (m < 15) {
                Block block2 = block;
                BlockRedstoneWire blockRedstoneWire = Blocks.field_150488_af;
                if (!(block2 != null ? !block2.equals(blockRedstoneWire) : blockRedstoneWire != null)) {
                    m = package$.MODULE$.max(m, Predef$.MODULE$.Integer2int((Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)));
                }
            }
            return m;
        }
        return 0;
    }

    public int otherConnectionMask(IBlockAccess world, BlockPos pos, int side, boolean power) {
        return this.getConnectionMask(world, pos.func_177972_a(EnumFacing.values()[side]), side ^ 1, power);
    }

    public int connectionMask(TMultiPart p, int side) {
        if (p instanceof IRedstonePart && ((IRedstonePart)((Object)p)).canConnectRedstone(side)) {
            if (p instanceof IFaceRedstonePart) {
                int fside = ((IFaceRedstonePart)((Object)p)).getFace();
                if ((side & 6) == (fside & 6)) {
                    return 16;
                }
                return 1 << Rotation.rotationTo((int)(side & 6), (int)fside);
            }
            if (p instanceof IMaskedRedstonePart) {
                return ((IMaskedRedstonePart)((Object)p)).getConnectionMask(side);
            }
            return 31;
        }
        return 0;
    }

    public int getConnectionMask(IBlockAccess world, BlockPos pos, int side, boolean power) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IRedstoneConnector) {
            return ((IRedstoneConnector)tile).getConnectionMask(side);
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IRedstoneConnectorBlock) {
            return ((IRedstoneConnectorBlock)block).getConnectionMask(world, pos, side);
        }
        return this.vanillaConnectionMask(state, world, pos, side, power);
    }

    public int vanillaConnectionMask(IBlockState state, IBlockAccess world, BlockPos pos, int side, boolean power) {
        Block block;
        block14: {
            int fside;
            block13: {
                block12: {
                    block11: {
                        block = state.func_177230_c();
                        if (this.fullVanillaBlocks().apply((Object)block)) {
                            return 31;
                        }
                        if (side == 0) {
                            return power ? 31 : 0;
                        }
                        Block block2 = block;
                        BlockRedstoneWire blockRedstoneWire = Blocks.field_150488_af;
                        if (!(block2 == null ? blockRedstoneWire != null : !block2.equals(blockRedstoneWire))) break block11;
                        Block block3 = block;
                        BlockRedstoneComparator blockRedstoneComparator = Blocks.field_150455_bV;
                        if (!(block3 == null ? blockRedstoneComparator != null : !block3.equals(blockRedstoneComparator))) break block11;
                        Block block4 = block;
                        BlockRedstoneComparator blockRedstoneComparator2 = Blocks.field_150441_bU;
                        if (block4 != null ? !block4.equals(blockRedstoneComparator2) : blockRedstoneComparator2 != null) break block12;
                    }
                    if (side != 0) {
                        return power ? 31 : 4;
                    }
                    return 0;
                }
                Block block5 = block;
                BlockRedstoneRepeater blockRedstoneRepeater = Blocks.field_150416_aS;
                if (!(block5 == null ? blockRedstoneRepeater != null : !block5.equals(blockRedstoneRepeater))) break block13;
                Block block6 = block;
                BlockRedstoneRepeater blockRedstoneRepeater2 = Blocks.field_150413_aR;
                if (block6 != null ? !block6.equals(blockRedstoneRepeater2) : blockRedstoneRepeater2 != null) break block14;
            }
            if ((side & 6) == ((fside = ((Enum)((Object)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D))).ordinal()) & 6)) {
                return power ? 31 : 4;
            }
            return 0;
        }
        if (power || block.canConnectRedstone(state, world, pos, EnumFacing.field_82609_l[side])) {
            return 31;
        }
        return 0;
    }

    private RedstoneInteractions$() {
        MODULE$ = this;
        this.fullVanillaBlocks = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Block[]{Blocks.field_150429_aA, Blocks.field_150437_az, Blocks.field_150442_at, Blocks.field_150430_aB, Blocks.field_150471_bO, Blocks.field_150451_bX}));
    }
}

