/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import java.util.Random;

public final class MathHelper {
    public static final Random RANDOM = new Random();
    public static final double PHI = 1.618034;
    public static final double[] SIN_TABLE = new double[65536];

    private MathHelper() {
    }

    public static double sin(double d) {
        return SIN_TABLE[(int)((float)d * 10430.378f) & 0xFFFF];
    }

    public static double cos(double d) {
        return SIN_TABLE[(int)((float)d * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static int clamp(int a, int min, int max) {
        return a < min ? min : (a > max ? max : a);
    }

    public static float clamp(float a, float min, float max) {
        return a < min ? min : (a > max ? max : a);
    }

    public static double clamp(double a, double min, double max) {
        return a < min ? min : (a > max ? max : a);
    }

    public static float approachLinear(float a, float b, float max) {
        return a > b ? (a - b < max ? b : a - max) : (b - a < max ? b : a + max);
    }

    public static double approachLinear(double a, double b, double max) {
        return a > b ? (a - b < max ? b : a - max) : (b - a < max ? b : a + max);
    }

    public static float interpolate(float a, float b, float d) {
        return a + (b - a) * d;
    }

    public static double interpolate(double a, double b, double d) {
        return a + (b - a) * d;
    }

    public static double approachExp(double a, double b, double ratio) {
        return a + (b - a) * ratio;
    }

    public static double approachExp(double a, double b, double ratio, double cap) {
        double d = (b - a) * ratio;
        if (Math.abs(d) > cap) {
            d = Math.signum(d) * cap;
        }
        return a + d;
    }

    public static double retreatExp(double a, double b, double c, double ratio, double kick) {
        double d = (Math.abs(c - a) + kick) * ratio;
        if (d > Math.abs(b - a)) {
            return b;
        }
        return a + Math.signum(b - a) * d;
    }

    public static double clip(double value, double min, double max) {
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    public static boolean between(double a, double x, double b) {
        return a <= x && x <= b;
    }

    public static int approachExpI(int a, int b, double ratio) {
        int r = (int)Math.round(MathHelper.approachExp(a, b, ratio));
        return r == a ? b : r;
    }

    public static int retreatExpI(int a, int b, int c, double ratio, int kick) {
        int r = (int)Math.round(MathHelper.retreatExp(a, b, c, ratio, kick));
        return r == a ? b : r;
    }

    public static int round(double d) {
        return (int)(d + 0.5);
    }

    public static int ceil(double d) {
        return (int)(d + 0.9999);
    }

    public static int floor(double d) {
        int i = (int)d;
        return d < (double)i ? i - 1 : i;
    }

    public static float minF(float a, float b) {
        return a < b ? a : b;
    }

    public static float minF(int a, float b) {
        return (float)a < b ? (float)a : b;
    }

    public static float minF(float a, int b) {
        return a < (float)b ? a : (float)b;
    }

    public static float maxF(float a, float b) {
        return a > b ? a : b;
    }

    public static float maxF(int a, float b) {
        return (float)a > b ? (float)a : b;
    }

    public static float maxF(float a, int b) {
        return a > (float)b ? a : (float)b;
    }

    public static double maxAbs(double a, double b) {
        if (a < 0.0) {
            a = -a;
        }
        if (b < 0.0) {
            b = -b;
        }
        return a > b ? a : b;
    }

    public static int setBit(int mask, int bit, boolean value) {
        return mask |= (value ? 1 : 0) << bit;
    }

    public static boolean isBitSet(int mask, int bit) {
        return (mask & 1 << bit) != 0;
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            MathHelper.SIN_TABLE[i] = Math.sin((double)i / 65536.0 * 2.0 * Math.PI);
        }
        MathHelper.SIN_TABLE[0] = 0.0;
        MathHelper.SIN_TABLE[16384] = 1.0;
        MathHelper.SIN_TABLE[32768] = 0.0;
        MathHelper.SIN_TABLE[49152] = -1.0;
    }
}

