/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item.tool;

import cofh.api.item.IToolBow;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.IFOVUpdateItem;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBowCore
extends ItemBow
implements IEnchantableItem,
IFOVUpdateItem,
IToolBow {
    protected String repairIngot = "";
    protected Item.ToolMaterial toolMaterial;
    protected float arrowDamageMultiplier = 0.0f;
    protected float arrowSpeedMultiplier = 0.0f;
    protected float zoomMultiplier = 0.15f;
    protected boolean showInCreative = true;

    public ItemBowCore(Item.ToolMaterial toolMaterial) {
        this.toolMaterial = toolMaterial;
        this.func_77625_d(1);
        this.func_77656_e(toolMaterial.func_77997_a() + 325);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemBowCore ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public ItemBowCore setRepairIngot(String repairIngot) {
        this.repairIngot = repairIngot;
        return this;
    }

    public ItemBowCore setArrowDamage(float multiplier) {
        this.arrowDamageMultiplier = multiplier;
        return this;
    }

    public ItemBowCore setArrowSpeed(float multiplier) {
        this.arrowSpeedMultiplier = multiplier;
        return this;
    }

    public ItemBowCore setZoomMultiplier(float multiplier) {
        this.zoomMultiplier = multiplier;
        return this;
    }

    public ItemBowCore setShowInCreative(boolean showInCreative) {
        this.showInCreative = showInCreative;
        return this;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab) && this.showInCreative) {
            items.add((Object)new ItemStack((Item)this, 1, 0));
        }
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return ItemHelper.isOreNameEqual(stack, this.repairIngot);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.toolMaterial.func_77995_e();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack stack = player.func_184586_b(hand);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)(flag = !this.func_185060_a(player).func_190926_b()));
        if (ret != null) {
            return ret;
        }
        if (!player.field_71075_bZ.field_75098_d && !flag) {
            return !flag ? new ActionResult(EnumActionResult.FAIL, (Object)stack) : new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase livingBase, int timeLeft) {
        if (livingBase instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)livingBase;
            ItemStack arrowStack = this.func_185060_a(player);
            boolean flag = player.field_71075_bZ.field_75098_d || arrowStack.func_77973_b() instanceof ItemArrow && ((ItemArrow)arrowStack.func_77973_b()).isInfinite(arrowStack, stack, player);
            int charge = this.func_77626_a(stack) - timeLeft;
            if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)livingBase), (int)charge, (!arrowStack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!arrowStack.func_190926_b() || flag) {
                if (arrowStack.func_190926_b()) {
                    arrowStack = new ItemStack(Items.field_151032_g);
                }
                float f = ItemBowCore.func_185059_b((int)charge);
                float speedMod = 1.0f + this.arrowSpeedMultiplier;
                if ((double)f >= 0.1) {
                    if (!world.field_72995_K) {
                        int encMultishot = MathHelper.clamp(EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.multishot, (ItemStack)stack), 0, 10);
                        int encPunch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
                        int encPower = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
                        boolean encFlame = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0;
                        this.onBowFired(player, stack);
                        ItemArrow arrowItem = (ItemArrow)(arrowStack.func_77973_b() instanceof ItemArrow ? arrowStack.func_77973_b() : Items.field_151032_g);
                        for (int shot = 0; shot <= encMultishot; ++shot) {
                            EntityArrow arrow = arrowItem.func_185052_a(world, arrowStack, (EntityLivingBase)player);
                            arrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f * speedMod, 1.0f + (1.5f - f) * (float)shot);
                            arrow.func_70239_b(arrow.func_70242_d() * (double)(1.0f + this.arrowDamageMultiplier));
                            if (f >= 1.0f) {
                                arrow.func_70243_d(true);
                            }
                            if (encPower > 0) {
                                arrow.func_70239_b(arrow.func_70242_d() + (double)encPower * 0.5 + 0.5);
                            }
                            if (encPunch > 0) {
                                arrow.func_70240_a(encPunch);
                            }
                            if (encFlame) {
                                arrow.func_70015_d(100);
                            }
                            if (flag || shot > 0) {
                                arrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                            }
                            world.func_72838_d((Entity)arrow);
                        }
                        stack.func_77972_a(1, (EntityLivingBase)player);
                    }
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag) {
                        arrowStack.func_190918_g(1);
                        if (arrowStack.func_190916_E() == 0) {
                            player.field_71071_by.func_184437_d(arrowStack);
                        }
                    }
                    player.func_71029_a(StatList.func_188057_b((Item)this));
                }
            }
        }
    }

    @Override
    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.multishot;
    }

    @Override
    public float getFOVMod(ItemStack stack, EntityPlayer player) {
        float progress = MathHelper.clamp((float)(stack.func_77988_m() - player.func_184605_cv()) / 20.0f, 0.0f, 1.0f);
        return progress * progress * this.zoomMultiplier;
    }

    @Override
    public void onBowFired(EntityPlayer player, ItemStack item) {
    }

    @Override
    public float getArrowDamageMultiplier(ItemStack item) {
        return this.arrowDamageMultiplier;
    }

    @Override
    public float getArrowSpeedMultiplier(ItemStack item) {
        return this.arrowSpeedMultiplier;
    }
}

