/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element;

import cofh.core.gui.GuiColor;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class ElementTextField
extends ElementBase {
    public int borderColor = new GuiColor(55, 55, 55).getColor();
    public int backgroundColor = new GuiColor(139, 139, 139).getColor();
    public int disabledColor = new GuiColor(198, 198, 198).getColor();
    public int selectedLineColor = new GuiColor(160, 160, 224).getColor();
    public int textColor = new GuiColor(224, 224, 224).getColor();
    public int selectedTextColor = new GuiColor(224, 224, 224).getColor();
    public int defaultCaretColor = new GuiColor(255, 255, 255).getColor();
    @Deprecated
    protected int renderStart;
    protected char[] text;
    protected int textLength;
    protected int selectionStart;
    protected int selectionEnd;
    protected int renderStartX;
    protected int renderStartY;
    protected int caret;
    protected int prevCaret;
    protected int caretX;
    private boolean isFocused;
    private boolean canFocusChange = true;
    private boolean selecting;
    private boolean pressed;
    private byte caretCounter;
    private byte counterOffset;
    protected boolean caretInsert;
    protected boolean smartCaret = true;
    protected boolean smartCaretCase = true;
    protected boolean multiline = false;
    protected boolean enableStencil = true;

    public ElementTextField(GuiContainerCore gui, int posX, int posY, int width, int height) {
        this(gui, posX, posY, width, height, 32);
    }

    public ElementTextField(GuiContainerCore gui, int posX, int posY, int width, int height, short limit) {
        super(gui, posX, posY, width, height);
        this.setMaxLength(limit);
    }

    public ElementTextField setTextColor(Number textColor, Number selectedTextColor) {
        if (textColor != null) {
            this.textColor = textColor.intValue();
        }
        if (selectedTextColor != null) {
            this.selectedTextColor = selectedTextColor.intValue();
        }
        return this;
    }

    public ElementTextField setSelectionColor(Number selectedLineColor, Number defaultCaretColor) {
        if (selectedLineColor != null) {
            this.selectedLineColor = selectedLineColor.intValue();
        }
        if (defaultCaretColor != null) {
            this.defaultCaretColor = defaultCaretColor.intValue();
        }
        return this;
    }

    public ElementTextField setBackgroundColor(Number backgroundColor, Number disabledColor, Number borderColor) {
        if (backgroundColor != null) {
            this.backgroundColor = backgroundColor.intValue();
        }
        if (disabledColor != null) {
            this.disabledColor = disabledColor.intValue();
        }
        if (borderColor != null) {
            this.borderColor = borderColor.intValue();
        }
        return this;
    }

    public ElementTextField setMultiline(boolean multi) {
        this.multiline = multi;
        return this;
    }

    public ElementTextField setFocusable(boolean focusable) {
        this.canFocusChange = focusable;
        return this;
    }

    public ElementTextField setFocused(boolean focused) {
        if (this.isFocusable()) {
            this.isFocused = focused;
            this.resetCaretFlash();
        }
        return this;
    }

    public ElementTextField setText(String text) {
        this.selectionStart = 0;
        this.selectionEnd = this.textLength;
        this.writeText(text);
        return this;
    }

    public ElementTextField setMaxLength(short limit) {
        char[] oldText = this.text;
        this.text = new char[limit];
        this.textLength = Math.min(limit, this.textLength);
        if (oldText != null) {
            System.arraycopy(oldText, 0, this.text, 0, this.textLength);
        }
        this.findRenderStart();
        return this;
    }

    public int getContentLength() {
        return this.textLength;
    }

    public int getMaxLength() {
        return this.text.length;
    }

    @Deprecated
    public int getMaxStringLength() {
        return this.text.length;
    }

    public boolean isFocused() {
        return this.isEnabled() && this.isFocused;
    }

    public boolean isFocusable() {
        return this.canFocusChange;
    }

    public int getContentHeight() {
        FontRenderer font = this.getFontRenderer();
        int height = font.field_78288_b;
        if (this.multiline) {
            for (int i = 0; i < this.textLength; ++i) {
                if (this.text[i] != '\n') continue;
                height += font.field_78288_b;
            }
        }
        return height;
    }

    public int getVisibleHeight() {
        FontRenderer font = this.getFontRenderer();
        int height = font.field_78288_b;
        if (this.multiline) {
            for (int i = 0; i < this.textLength; ++i) {
                if (this.text[i] != '\n') continue;
                height += font.field_78288_b;
            }
        }
        return Math.min(height - this.renderStartY, this.sizeY);
    }

    public int getContentWidth() {
        FontRenderer font = this.getFontRenderer();
        int width = 0;
        for (int i = 0; i < this.textLength; ++i) {
            width += font.func_78263_a(this.text[i]);
        }
        return width;
    }

    public int getVisibleWidth() {
        FontRenderer font = this.getFontRenderer();
        int width = 0;
        int endX = this.sizeX - 1;
        int maxWidth = 0;
        if (this.multiline) {
            for (int i = 0; i < this.textLength; ++i) {
                char c = this.text[i];
                int charW = font.func_78263_a(c);
                if (c == '\n') {
                    maxWidth = Math.max(maxWidth, width);
                    width = 0;
                } else {
                    width += charW;
                }
                if (width - this.renderStartX < endX) continue;
                maxWidth = endX + this.renderStartX;
                break;
            }
            maxWidth -= this.renderStartX;
        } else {
            for (int i = this.renderStartX; i < this.textLength; ++i) {
                char c = this.text[i];
                int charW = font.func_78263_a(c);
                if ((maxWidth += charW) < endX) continue;
                maxWidth = endX;
                break;
            }
        }
        return maxWidth;
    }

    public String getText() {
        return new String(this.text, 0, this.textLength);
    }

    public String getSelectedText() {
        if (this.selectionStart != this.selectionEnd) {
            return new String(this.text, this.selectionStart, this.selectionEnd);
        }
        return this.getText();
    }

    public void writeText(String text) {
        int i;
        int e = text.length();
        for (i = 0; i < e && this.insertCharacter(text.charAt(i)); ++i) {
        }
        this.clearSelection();
        this.findRenderStart();
        this.onCharacterEntered(i > 0);
    }

    public boolean isAllowedCharacter(char charTyped) {
        return this.multiline && charTyped == '\n' || ChatAllowedCharacters.func_71566_a((char)charTyped);
    }

    protected boolean onEnter() {
        if (this.multiline) {
            boolean typed;
            if (this.caretInsert && this.selectionStart == this.selectionEnd) {
                this.caretInsert = false;
                typed = this.insertCharacter('\n');
                this.caretInsert = true;
            } else {
                typed = this.insertCharacter('\n');
            }
            this.clearSelection();
            this.findRenderStart();
            this.onCharacterEntered(typed);
            this.resetCaretFlash();
            return true;
        }
        return false;
    }

    protected void onFocusLost() {
    }

    protected void onCharacterEntered(boolean success) {
    }

    protected void resetCaretFlash() {
        int v = Minecraft.func_71410_x().field_71456_v.func_73834_c();
        this.counterOffset = (byte)(v - this.counterOffset & 0x3F);
        this.counterOffset = (byte)(this.counterOffset + (byte)(v - this.counterOffset & 0x3F));
        this.caretCounter = 0;
    }

    protected boolean insertCharacter(char charTyped) {
        if (this.isAllowedCharacter(charTyped)) {
            if (this.selectionStart != this.selectionEnd) {
                if (this.caret == this.selectionStart) {
                    ++this.caret;
                }
                this.text[this.selectionStart++] = charTyped;
                return true;
            }
            int len = this.getMaxLength();
            if (this.caretInsert && this.caret == len || this.textLength == len) {
                return false;
            }
            if (!this.caretInsert || this.multiline && this.text[this.caret] == '\n') {
                if (this.caret < this.textLength) {
                    System.arraycopy(this.text, this.caret, this.text, this.caret + 1, this.textLength - this.caret);
                }
                ++this.textLength;
            }
            this.text[this.caret++] = charTyped;
            return true;
        }
        return true;
    }

    protected void findRenderStart() {
        this.caret = MathHelper.clamp(this.caret, 0, this.textLength);
        if (this.selectionStart == this.selectionEnd) {
            this.selectionStart = this.selectionEnd = this.caret;
        }
        if (this.multiline) {
            this.findRenderStartML();
            return;
        }
        this.renderStartY = 0;
        if (this.caret < this.renderStartX) {
            this.renderStartX = this.caret;
            return;
        }
        FontRenderer font = this.getFontRenderer();
        int endX = this.sizeX - 2;
        int width = 0;
        for (int i = this.renderStartX; i < this.caret; ++i) {
            width += font.func_78263_a(this.text[i]);
            while (width >= endX) {
                width -= font.func_78263_a(this.text[this.renderStartX++]);
                if (this.renderStartX < this.textLength) continue;
                return;
            }
        }
    }

    protected void findRenderStartML() {
        char c;
        if (this.caret == this.textLength && this.textLength == 0) {
            this.renderStartY = 0;
            this.renderStartX = 0;
            return;
        }
        FontRenderer font = this.getFontRenderer();
        int widthLeft = 0;
        int breaksAbove = 0;
        int i = this.caret;
        while (i-- > 0) {
            char c2 = this.text[i];
            if (c2 == '\n') {
                while (i > 0) {
                    c2 = this.text[i];
                    if (c2 == '\n') {
                        breaksAbove += font.field_78288_b;
                    }
                    --i;
                }
                break;
            }
            widthLeft += font.func_78263_a(c2);
        }
        this.caretX = widthLeft;
        int pos = Math.max(0, (this.sizeY - 2) / font.field_78288_b) * font.field_78288_b;
        if (this.caret > 0 && this.text[this.caret - 1] == '\n') {
            this.renderStartX = 0;
            if (this.caret == this.textLength) {
                this.renderStartY -= pos;
                this.renderStartY &= ~this.renderStartY >> 31;
            }
        }
        while (breaksAbove - this.renderStartY < 0) {
            this.renderStartY -= font.field_78288_b;
        }
        while (breaksAbove - this.renderStartY >= pos) {
            this.renderStartY += font.field_78288_b;
        }
        int dir = this.prevCaret > this.caret ? 1 : -1;
        int i2 = 0;
        while (widthLeft - this.renderStartX < 0 && (c = this.text[this.caret + i2]) != '\n') {
            this.renderStartX -= font.func_78263_a(c);
            i2 += dir;
        }
        this.renderStartX &= ~this.renderStartX >> 31;
        pos = this.sizeX - 2 - 3;
        i2 = 0;
        while (widthLeft - this.renderStartX >= pos) {
            this.renderStartX += font.func_78263_a(this.text[this.caret - i2]);
            ++i2;
        }
        this.prevCaret = this.caret;
    }

    protected void clearSelection() {
        if (this.selectionStart != this.selectionEnd) {
            if (this.selectionEnd < this.textLength) {
                System.arraycopy(this.text, this.selectionEnd, this.text, this.selectionStart, this.textLength - this.selectionEnd);
            }
            this.textLength -= this.selectionEnd - this.selectionStart;
            this.selectionEnd = this.caret = this.selectionStart;
            this.findRenderStart();
            this.onCharacterEntered(true);
        }
    }

    protected final int seekNextCaretLocation(int pos) {
        return this.seekNextCaretLocation(pos, true);
    }

    protected int seekNextCaretLocation(int pos, boolean forward) {
        int i;
        char prevChar;
        int e;
        int dir = forward ? 1 : -1;
        int n = e = forward ? this.textLength : 0;
        if (pos != e) {
            pos += dir;
        }
        char c = prevChar = pos == this.textLength ? (char)'\u0000' : this.text[pos];
        if (!forward) {
            if (pos != e && Character.isSpaceChar(prevChar)) {
                pos += !Character.isSpaceChar(this.text[pos + dir]) ? dir : 0;
            }
        } else if (pos != e && Character.isSpaceChar(prevChar)) {
            pos -= !Character.isSpaceChar(this.text[pos - dir]) ? dir : 0;
        }
        prevChar = this.text[pos];
        if (this.smartCaret) {
            boolean originalCase = Character.isUpperCase(prevChar);
            for (i = pos; i != e; i += dir) {
                boolean space;
                char curChar = this.text[i];
                boolean dig = Character.isLetterOrDigit(curChar) != Character.isLetterOrDigit(prevChar);
                boolean caze = !dig && Character.isUpperCase(curChar) != Character.isUpperCase(prevChar);
                boolean bl = space = Character.isWhitespace(prevChar) != Character.isWhitespace(curChar);
                if (dig || caze & this.smartCaretCase || space) {
                    int o = 0;
                    if (this.smartCaretCase && caze) {
                        o = originalCase && Character.isUpperCase(prevChar) ? -dir : 0;
                    } else if (space) {
                        if (forward) {
                            if (i != e && !Character.isWhitespace(this.text[i + dir])) {
                                o = Character.isWhitespace(curChar) ? 1 : 0;
                            }
                        } else {
                            o = 1;
                        }
                    }
                    return i + o;
                }
                prevChar = curChar;
            }
        } else {
            while (i != e) {
                char curChar = this.text[i];
                if (Character.isSpaceChar(curChar) != Character.isSpaceChar(prevChar)) {
                    return i;
                }
                i += dir;
            }
        }
        return forward ? this.textLength : 0;
    }

    @Override
    public boolean onKeyTyped(char charTyped, int keyTyped) {
        if (!this.isFocused()) {
            return false;
        }
        switch (charTyped) {
            case '\u0001': {
                this.selectionEnd = this.caret = this.textLength;
                this.selectionStart = 0;
                this.findRenderStart();
                return true;
            }
            case '\u0003': {
                if (this.selectionStart != this.selectionEnd) {
                    GuiScreen.func_146275_d((String)this.getSelectedText());
                }
                return true;
            }
            case '\u0018': {
                if (this.selectionStart != this.selectionEnd) {
                    GuiScreen.func_146275_d((String)this.getSelectedText());
                    this.clearSelection();
                    this.resetCaretFlash();
                }
                return true;
            }
            case '\u0016': {
                this.writeText(GuiScreen.func_146277_j());
                this.resetCaretFlash();
                return true;
            }
        }
        switch (keyTyped) {
            case 1: {
                this.setFocused(false);
                return !this.isFocused();
            }
            case 28: 
            case 156: {
                return this.onEnter();
            }
            case 210: {
                if (GuiScreen.func_146272_n()) {
                    this.writeText(GuiScreen.func_146277_j());
                    this.resetCaretFlash();
                } else {
                    this.caretInsert = !this.caretInsert;
                }
                return true;
            }
            case 218: {
                this.clearSelection();
                this.resetCaretFlash();
                return true;
            }
            case 211: {
                boolean changed = false;
                if (!GuiScreen.func_146272_n()) {
                    if (this.selectionStart != this.selectionEnd) {
                        this.clearSelection();
                    } else if (GuiScreen.func_146271_m()) {
                        int size = this.seekNextCaretLocation(this.caret, true) - this.caret;
                        this.selectionStart = this.caret;
                        this.selectionEnd = this.caret + size;
                        this.clearSelection();
                    } else {
                        if (this.caret < this.textLength && this.textLength > 0) {
                            --this.textLength;
                            System.arraycopy(this.text, this.caret + 1, this.text, this.caret, this.textLength - this.caret);
                            changed = true;
                        }
                        this.findRenderStart();
                        this.onCharacterEntered(changed);
                    }
                    this.resetCaretFlash();
                    return true;
                }
            }
            case 14: {
                boolean changed = false;
                boolean calledEntered = true;
                boolean onBreak = false;
                if (this.selectionStart != this.selectionEnd) {
                    this.clearSelection();
                } else if (GuiScreen.func_146271_m()) {
                    int size = this.seekNextCaretLocation(this.caret, false) - this.caret;
                    this.selectionStart = this.caret + size;
                    this.selectionEnd = this.caret;
                    this.clearSelection();
                } else {
                    calledEntered = false;
                    if (this.caret > 0 && this.textLength > 0) {
                        if (this.caret != this.textLength) {
                            System.arraycopy(this.text, this.caret, this.text, this.caret - 1, this.textLength - this.caret);
                        }
                        onBreak = this.text[--this.caret] == '\n';
                        --this.textLength;
                        changed = true;
                    }
                }
                int old = this.caret;
                if (!onBreak) {
                    int i = 3;
                    while (i-- > 0 && this.caret > 1 && this.text[this.caret - 1] != '\n') {
                        --this.caret;
                    }
                }
                this.findRenderStart();
                this.caret = old;
                if (!calledEntered) {
                    this.onCharacterEntered(changed);
                }
                this.resetCaretFlash();
                return true;
            }
            case 199: {
                int begin = 0;
                if (!GuiScreen.func_146271_m()) {
                    for (int i = this.caret - 1; i > 0; --i) {
                        if (this.text[i] != '\n') continue;
                        begin = Math.min(i + 1, this.textLength);
                        break;
                    }
                }
                if (GuiScreen.func_146272_n()) {
                    if (this.caret >= this.selectionEnd) {
                        this.selectionEnd = this.selectionStart;
                    }
                    this.selectionStart = begin;
                } else {
                    this.selectionStart = this.selectionEnd = begin;
                }
                this.caret = begin;
                this.findRenderStart();
                this.resetCaretFlash();
                return true;
            }
            case 207: {
                int end = this.textLength;
                if (!GuiScreen.func_146271_m()) {
                    for (int i = this.caret; i < this.textLength; ++i) {
                        if (this.text[i] != '\n') continue;
                        end = i;
                        break;
                    }
                }
                if (GuiScreen.func_146272_n()) {
                    if (this.caret <= this.selectionStart) {
                        this.selectionStart = this.selectionEnd;
                    }
                    this.selectionEnd = end;
                } else {
                    this.selectionStart = this.selectionEnd = end;
                }
                this.caret = end;
                this.findRenderStart();
                this.resetCaretFlash();
                return true;
            }
            case 203: 
            case 205: {
                int size = keyTyped == 203 ? -1 : 1;
                boolean shiftCaret = false;
                if (GuiScreen.func_146271_m()) {
                    size = this.seekNextCaretLocation(this.caret, keyTyped == 205) - this.caret;
                } else if (StringHelper.isAltKeyDown() && GuiScreen.func_146272_n()) {
                    this.selectionStart = this.selectionEnd = (this.caret = this.seekNextCaretLocation(this.caret, keyTyped == 205));
                    size = this.seekNextCaretLocation(this.caret, keyTyped != 205) - this.caret;
                    shiftCaret = true;
                }
                if (!GuiScreen.func_146272_n()) {
                    this.selectionStart = this.selectionEnd = this.caret;
                }
                int t = this.caret;
                this.caret = MathHelper.clamp(this.caret + size, 0, this.textLength);
                size = this.caret - t;
                if (GuiScreen.func_146272_n()) {
                    if (this.caret == this.selectionStart + size) {
                        this.selectionStart = this.caret;
                    } else if (this.caret == this.selectionEnd + size) {
                        this.selectionEnd = this.caret;
                    }
                    if (this.selectionStart > this.selectionEnd) {
                        t = this.selectionStart;
                        this.selectionStart = this.selectionEnd;
                        this.selectionEnd = t;
                    }
                }
                if (shiftCaret) {
                    this.caret -= size;
                }
                this.findRenderStart();
                this.resetCaretFlash();
                return true;
            }
            case 200: 
            case 208: {
                int i;
                if (!this.multiline) {
                    return false;
                }
                if (!GuiScreen.func_146272_n()) {
                    this.selectionStart = this.selectionEnd = this.caret;
                }
                int dir = keyTyped == 200 ? -1 : 1;
                int end = dir == -1 ? 0 : this.textLength;
                int pos = this.caretX;
                int old = i;
                for (i = this.caret; i != end; i += dir) {
                    if (dir == -1 && i == this.caret || this.text[i] != '\n') continue;
                    if (i != end) {
                        i += dir;
                        break;
                    }
                    return true;
                }
                if (dir == -1) {
                    while (i > 0 && this.text[i] != '\n') {
                        --i;
                    }
                    if (i == 0) {
                        if (this.text[0] == '\n') {
                            this.caret = 0;
                            this.findRenderStart();
                            this.caretX = pos;
                        }
                    } else {
                        ++i;
                    }
                }
                FontRenderer font = this.getFontRenderer();
                int width = 0;
                while (i <= this.textLength) {
                    char c;
                    char c2 = c = i < this.textLength ? this.text[i] : (char)'\u0000';
                    if (i == this.textLength || c == '\n' || width >= pos) {
                        this.caret = i;
                        this.findRenderStart();
                        this.caretX = pos;
                        break;
                    }
                    width += font.func_78263_a(c);
                    ++i;
                }
                int size = this.caret - old;
                if (GuiScreen.func_146272_n()) {
                    if (this.selectionStart == this.selectionEnd) {
                        this.selectionStart = this.selectionEnd = old;
                    }
                    if (this.caret == this.selectionStart + size) {
                        this.selectionStart = this.caret;
                    } else if (this.caret == this.selectionEnd + size) {
                        this.selectionEnd = this.caret;
                    }
                    if (this.selectionStart > this.selectionEnd) {
                        int t = this.selectionStart;
                        this.selectionStart = this.selectionEnd;
                        this.selectionEnd = t;
                    }
                }
                this.resetCaretFlash();
                return true;
            }
        }
        if (this.isAllowedCharacter(charTyped)) {
            boolean typed = this.insertCharacter(charTyped);
            this.clearSelection();
            this.findRenderStart();
            this.onCharacterEntered(typed);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        this.pressed = mouseButton == 0;
        boolean bl = this.selecting = mouseButton == 0 && this.isFocused();
        if (this.selecting) {
            if (this.textLength == 0) {
                this.caret = 0;
                this.selectionEnd = 0;
                this.selectionStart = 0;
            } else {
                block12: {
                    FontRenderer font = this.getFontRenderer();
                    int posX = mouseX - this.posX - 1;
                    int posY = mouseY - this.posY - 1;
                    if (!this.multiline) {
                        int charW;
                        int i = this.renderStartX;
                        int width = 0;
                        while ((width += (charW = font.func_78263_a(this.text[i]))) <= posX && ++i < this.textLength) {
                        }
                        this.selectionEnd = this.caret = i;
                        this.selectionStart = this.caret;
                    } else {
                        posX += this.renderStartX;
                        posY += this.renderStartY;
                        int maxX = 0;
                        boolean found = false;
                        int i = 0;
                        int width = 0;
                        int height = font.field_78288_b;
                        while (i < this.textLength) {
                            char c = this.text[i];
                            int charW = 0;
                            if (c == '\n') {
                                if (height > posY) {
                                    maxX = i;
                                    break;
                                }
                                found = false;
                                width = 0;
                                height += font.field_78288_b;
                            } else {
                                charW = font.func_78263_a(c);
                            }
                            if (!found) {
                                maxX = i;
                            }
                            if ((width += charW) <= posX && ++i < this.textLength) continue;
                            if (posY < height || i >= this.textLength) {
                                this.selectionEnd = this.caret = i;
                                this.selectionStart = this.caret;
                                break block12;
                            }
                            ++i;
                            found = true;
                        }
                        this.selectionEnd = this.caret = maxX;
                        this.selectionStart = this.caret;
                    }
                }
                this.findRenderStart();
            }
        }
        this.setFocused(true);
        return true;
    }

    @Override
    public void update(int mouseX, int mouseY) {
        this.caretCounter = (byte)(Minecraft.func_71410_x().field_71456_v.func_73834_c() - this.counterOffset & 0x3F);
    }

    @Override
    public void onMouseReleased(int mouseX, int mouseY) {
        if (!this.pressed) {
            boolean focus = this.isFocused();
            this.setFocused(false);
            if (focus && !this.isFocused()) {
                this.onFocusLost();
            }
        }
        this.selecting = false;
        this.pressed = false;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        this.drawModalRect(this.posX - 1, this.posY - 1, this.posX + this.sizeX + 1, this.posY + this.sizeY + 1, this.borderColor);
        this.drawModalRect(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, this.isEnabled() ? this.backgroundColor : this.disabledColor);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        boolean enableStencil = this.enableStencil;
        int bit = -1;
        if (enableStencil) {
            bit = MinecraftForgeClient.reserveStencilBit();
            if (bit == -1) {
                enableStencil = false;
            } else {
                GL11.glEnable((int)2960);
                this.drawStencil(this.posX + 1, this.posY + 1, this.posX + this.sizeX - 1, this.posY + this.sizeY - 1, 1 << bit);
            }
        }
        FontRenderer font = this.getFontRenderer();
        char[] text = this.text;
        int startX = this.posX + 1 - (this.multiline ? this.renderStartX : 0);
        int endX = this.sizeX - 1;
        int startY = this.posY + 1 - this.renderStartY;
        int endY = startY + font.field_78288_b;
        int drawY = this.renderStartY + Math.max(0, (this.sizeY - 2) / font.field_78288_b) * font.field_78288_b;
        if (enableStencil && this.sizeY - (drawY - this.renderStartY) > 2) {
            drawY += font.field_78288_b;
        }
        int drawX = endX + (this.multiline ? this.renderStartX : 0);
        int width = 0;
        int height = 0;
        for (int i = this.multiline ? 0 : this.renderStartX; i <= this.textLength; ++i) {
            int caretEnd;
            boolean drawCaret;
            boolean end = i == this.textLength;
            boolean draw = height >= this.renderStartY && width < drawX && height < drawY;
            int charW = 2;
            char c = '\u0000';
            if (!end) {
                c = text[i];
                if (draw) {
                    charW = this.multiline && c == '\n' ? 2 : font.func_78263_a(c);
                }
                int tWidth = width + charW;
                if (this.multiline) {
                    if (!enableStencil) {
                        draw &= width >= this.renderStartX;
                    }
                    draw &= tWidth > this.renderStartX;
                }
                if (!enableStencil && tWidth > endX) {
                    draw = false;
                    if (!this.multiline) break;
                    if (c != '\n') continue;
                }
            }
            boolean bl = drawCaret = draw && i == this.caret && (this.caretCounter & 0x1F) < 16 && this.isFocused();
            if (drawCaret) {
                caretEnd = width + 2;
                if (this.caretInsert) {
                    caretEnd = width + charW;
                }
                this.drawModalRect(startX + width, startY - 1 + height, startX + caretEnd, endY + height, 0xFF000000 & this.defaultCaretColor | ~this.defaultCaretColor & 0xFFFFFF);
            }
            if (draw && !end) {
                boolean selected = i >= this.selectionStart & i < this.selectionEnd;
                if (selected) {
                    this.drawModalRect(startX + width, startY + height, startX + width + charW, endY + height, this.selectedLineColor);
                }
                if (c != '\n') {
                    font.func_78276_b(String.valueOf(c), startX + width, startY + height, selected ? this.selectedTextColor : this.textColor);
                }
            }
            if (drawCaret) {
                caretEnd = width + 2;
                if (this.caretInsert) {
                    caretEnd = width + charW;
                }
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)775, (int)0);
                this.gui.drawSizedRect(startX + width, startY - 1 + height, startX + caretEnd, endY + height, -1);
                GlStateManager.func_179084_k();
            }
            if (c == '\n') {
                width = 0;
                charW = 0;
                if ((height += font.field_78288_b) > drawY) break;
            }
            if (!this.multiline && (width += charW) > endX) break;
        }
        if (enableStencil) {
            GL11.glDisable((int)2960);
            MinecraftForgeClient.releaseStencilBit((int)bit);
        }
    }
}

