/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui;

public class GuiColor
extends Number {
    private static final long serialVersionUID = 7024827242888861187L;
    private final int _color;

    public GuiColor(int argb) {
        this._color = argb;
    }

    public GuiColor(int rgba, Void dummy) {
        this(rgba >>> 24, rgba >> 16, rgba >> 8, rgba);
    }

    public GuiColor(byte alpha, int argb) {
        this(argb >> 16, argb >> 8, argb, alpha);
    }

    public GuiColor(int rgba, byte alpha) {
        this(rgba >>> 24, rgba >> 16, rgba >> 8, alpha);
    }

    public GuiColor(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public GuiColor(int r, int g, int b, int a) {
        this._color = b & 0xFF | (g & 0xFF) << 8 | (r & 0xFF) << 16 | (a & 0xFF) << 24;
    }

    public int getColor() {
        return this._color;
    }

    public int getIntR() {
        return this._color >> 16 & 0xFF;
    }

    public int getIntG() {
        return this._color >> 8 & 0xFF;
    }

    public int getIntB() {
        return this._color & 0xFF;
    }

    public int getIntA() {
        return this._color >> 24 & 0xFF;
    }

    public float getFloatR() {
        return (float)this.getIntR() / 255.0f;
    }

    public float getFloatG() {
        return (float)this.getIntG() / 255.0f;
    }

    public float getFloatB() {
        return (float)this.getIntB() / 255.0f;
    }

    public float getFloatA() {
        return (float)this.getIntA() / 255.0f;
    }

    public GuiColor multiply(float amount) {
        return this.multiply(amount, amount, amount, amount);
    }

    public GuiColor multiply(float rgb, float a) {
        return this.multiply(rgb, rgb, rgb, a);
    }

    public GuiColor multiply(float r, float g, float b) {
        return this.multiply(r, g, b, 1.0f);
    }

    public GuiColor multiply(float r, float g, float b, float a) {
        return new GuiColor(Math.min((int)((float)this.getIntR() * r), 255), Math.min((int)((float)this.getIntG() * g), 255), Math.min((int)((float)this.getIntB() * b), 255));
    }

    public GuiColor add(int amount) {
        return new GuiColor(Math.max(Math.min(this.getIntR() + amount, 255), 0), Math.max(Math.min(this.getIntG() + amount, 255), 0), Math.max(Math.min(this.getIntB() + amount, 255), 0), Math.max(Math.min(this.getIntA() + amount, 255), 0));
    }

    public GuiColor add(GuiColor color) {
        return new GuiColor(Math.max(Math.min(this.getIntR() + color.getIntR(), 255), 0), Math.max(Math.min(this.getIntG() + color.getIntG(), 255), 0), Math.max(Math.min(this.getIntB() + color.getIntB(), 255), 0), Math.max(Math.min(this.getIntA() + color.getIntA(), 255), 0));
    }

    @Override
    public int intValue() {
        return this.getColor();
    }

    @Override
    public long longValue() {
        return this.getColor();
    }

    @Override
    public float floatValue() {
        return this.getColor();
    }

    @Override
    public double doubleValue() {
        return this.getColor();
    }
}

