/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.energy;

import cofh.core.util.ItemWrapper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class FurnaceFuelHandler
implements IFuelHandler {
    public static final FurnaceFuelHandler INSTANCE = new FurnaceFuelHandler();
    private static Map<ItemWrapper, Integer> fuels = new Object2ObjectOpenHashMap();

    public static void initialize() {
        GameRegistry.registerFuelHandler((IFuelHandler)INSTANCE);
    }

    private FurnaceFuelHandler() {
    }

    public int getBurnTime(ItemStack fuel) {
        if (fuel.func_190926_b() || !fuels.containsKey(new ItemWrapper(fuel))) {
            return 0;
        }
        return fuels.get(new ItemWrapper(fuel));
    }

    public static boolean registerFuel(ItemStack fuel, int burnTime) {
        if (fuel.func_190926_b() || burnTime <= 0 || fuels.containsKey(new ItemWrapper(fuel))) {
            return false;
        }
        fuels.put(new ItemWrapper(fuel), burnTime);
        return true;
    }

    public static void refresh() {
        Object2ObjectOpenHashMap tempMap = new Object2ObjectOpenHashMap();
        for (Map.Entry<ItemWrapper, Integer> entry : fuels.entrySet()) {
            ItemWrapper tempItem = new ItemWrapper(entry.getKey().item, entry.getKey().metadata);
            tempMap.put(tempItem, entry.getValue());
        }
        fuels.clear();
        fuels = tempMap;
    }
}

