/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.api.ITeleportPipe;
import buildcraft.additionalpipes.api.TeleportPipeType;
import buildcraft.additionalpipes.pipes.PipeBehaviorTeleport;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventItem;
import buildcraft.transport.pipe.flow.PipeFlowItems;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class PipeBehaviorTeleportItems
extends PipeBehaviorTeleport {
    private static final double TELEPORTED_ITEM_SPEED = 0.1;
    private EnumFacing teleportSide = null;

    public PipeBehaviorTeleportItems(IPipe pipe, NBTTagCompound tagCompound) {
        super(pipe, tagCompound, TeleportPipeType.ITEMS);
        this.teleportSide = EnumFacing.field_82609_l[tagCompound.func_74771_c("teleportSide")];
    }

    public PipeBehaviorTeleportItems(IPipe pipe) {
        super(pipe, TeleportPipeType.ITEMS);
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        if (this.getTeleportSide() != null) {
            nbt.func_74774_a("teleportSide", (byte)this.getTeleportSide().ordinal());
        }
        return nbt;
    }

    public EnumFacing getTeleportSide() {
        if (this.isClient()) {
            return null;
        }
        if (this.teleportSide == null || this.pipe.isConnected(this.teleportSide) || !this.pipe.isConnected(this.teleportSide.func_176734_d())) {
            Log.debug("[ItemTeleportPipe]" + this.getPosition().toString() + " Recalculating teleport side...");
            this.teleportSide = null;
            boolean allSidesConnected = true;
            for (EnumFacing side : EnumFacing.field_82609_l) {
                Log.debug("isConnected(" + side + ") = " + this.pipe.isConnected(side));
                if (!this.pipe.isConnected(side) && this.pipe.isConnected(side.func_176734_d())) {
                    this.teleportSide = side;
                    break;
                }
                allSidesConnected = allSidesConnected && this.pipe.isConnected(side);
            }
            if (this.teleportSide == null && allSidesConnected) {
                this.teleportSide = EnumFacing.DOWN;
            }
            Log.debug("[ItemTeleportPipe]" + this.getPosition().toString() + " Teleport side set to " + String.valueOf(this.teleportSide));
        }
        return this.teleportSide;
    }

    @PipeEventHandler
    public void onTryDrop(PipeEventItem.Drop event) {
        PipeBehaviorTeleportItems otherPipe;
        int originalPipeNumber;
        if (this.pipe.getHolder().getPipeWorld().field_72995_K || !this.canSend()) {
            return;
        }
        ArrayList<ITeleportPipe> connectedTeleportPipes = TeleportManager.instance.getConnectedPipes(this, false, true);
        if (connectedTeleportPipes.size() <= 0 || (this.state & 1) == 0) {
            return;
        }
        LinkedList<EnumFacing> outputOrientations = new LinkedList<EnumFacing>();
        int currentPipeNumber = originalPipeNumber = this.pipe.getHolder().getPipeWorld().field_73012_v.nextInt(connectedTeleportPipes.size());
        boolean found = false;
        int numberOfTries = 0;
        do {
            ++numberOfTries;
            otherPipe = (PipeBehaviorTeleportItems)connectedTeleportPipes.get(currentPipeNumber);
            for (EnumFacing o : EnumFacing.values()) {
                if (!otherPipe.pipe.isConnected(o)) continue;
                outputOrientations.add(o);
            }
            if (outputOrientations.size() <= 0) {
                if (++currentPipeNumber < connectedTeleportPipes.size()) continue;
                currentPipeNumber = 0;
                continue;
            }
            found = true;
        } while (numberOfTries < connectedTeleportPipes.size() && !found);
        if (!found) {
            Log.debug("[ItemTeleportPipe]" + this.getPosition().toString() + "Unable to find a destination, dropping item " + event.getStack());
            return;
        }
        ((PipeFlowItems)otherPipe.pipe.getFlow()).insertItemsForce(event.getStack(), otherPipe.getTeleportSide(), null, 0.1);
        Log.debug("[ItemTeleportPipe]" + this.getPosition().toString() + event.getStack() + " from " + this.getPosition() + " to " + otherPipe.getPosition());
        event.setStack(ItemStack.field_190927_a);
    }

    @PipeEventHandler
    public void orderSides(PipeEventItem.SideCheck event) {
        if (event.from != this.getTeleportSide()) {
            try {
                event.increasePriority(this.getTeleportSide(), 100);
            }
            catch (NullPointerException ex) {
                Log.debug("Caught NPE from SideCheck.increasePriority()");
            }
        }
    }
}

