/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.additionalpipes.utils.InventoryUtils;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.inventory.IItemTransactor;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventItem;
import buildcraft.lib.inventory.ItemTransactorHelper;
import buildcraft.lib.misc.EntityUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class PipeBehaviorClosed
extends APPipe
implements ICapabilityProvider {
    public static final int INVENTORY_SIZE = 9;
    ItemStackHandler inventory = new ItemStackHandler(9);
    boolean isClosed;

    public boolean isClosed() {
        return this.isClosed;
    }

    public PipeBehaviorClosed(IPipe pipe) {
        super(pipe);
    }

    public PipeBehaviorClosed(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.inventory.deserializeNBT(nbt.func_74775_l("closedInventory"));
        if (this.isServer()) {
            this.updateClosedStatus();
        }
    }

    public boolean onPipeActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        if (EntityUtil.getWrenchHand((EntityLivingBase)player) != null) {
            return super.onPipeActivate(player, trace, hitX, hitY, hitZ, part);
        }
        if (!player.field_70170_p.field_72995_K) {
            BlockPos pipePos = this.pipe.getHolder().getPipePos();
            player.openGui((Object)AdditionalPipes.instance, 4, this.pipe.getHolder().getPipeWorld(), pipePos.func_177958_n(), pipePos.func_177956_o(), pipePos.func_177952_p());
        }
        return true;
    }

    public void addDrops(NonNullList<ItemStack> toDrop, int fortune) {
        super.addDrops(toDrop, fortune);
        toDrop.addAll(InventoryUtils.getItems((IItemHandler)this.inventory));
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbttagcompound = super.writeToNbt();
        nbttagcompound.func_74782_a("closedInventory", (NBTBase)this.inventory.serializeNBT());
        return nbttagcompound;
    }

    @PipeEventHandler
    public void onDrop(PipeEventItem.Drop event) {
        if (this.isClient()) {
            return;
        }
        IItemTransactor transactor = ItemTransactorHelper.getTransactor((ICapabilityProvider)this, (EnumFacing)EnumFacing.UP);
        ItemStack overflow = transactor.insert(event.getStack(), true, true);
        if (overflow != ItemStack.field_190927_a) {
            for (int i = 8; i > 1; --i) {
                this.inventory.setStackInSlot(i, this.inventory.getStackInSlot(i - 1));
            }
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        }
        transactor.insert(event.getStack(), false, false);
        event.setStack(ItemStack.field_190927_a);
        this.updateClosedStatus();
    }

    public void updateClosedStatus() {
        boolean newIsClosed = false;
        for (int i = 0; i < 9; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            newIsClosed = true;
            break;
        }
        if (newIsClosed != this.isClosed) {
            this.isClosed = newIsClosed;
            this.pipe.getHolder().scheduleNetworkUpdate(new IPipeHolder.PipeMessageReceiver[]{IPipeHolder.PipeMessageReceiver.BEHAVIOUR});
        }
    }

    public void writePayload(PacketBuffer buffer, Side side) {
        Log.debug("wrote payload");
        buffer.writeBoolean(this.isClosed);
    }

    public void readPayload(PacketBuffer buffer, Side side, MessageContext ctx) {
        Log.debug("read payload");
        this.isClosed = buffer.readBoolean();
        this.pipe.markForUpdate();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getTextureIndex(EnumFacing direction) {
        return this.isClosed ? 1 : 0;
    }
}

