/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.network.message;

import buildcraft.additionalpipes.pipes.PipeBehaviorJeweled;
import buildcraft.additionalpipes.pipes.SideFilterData;
import buildcraft.transport.tile.TilePipeHolder;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageJeweledPipeOptionsServer
implements IMessage,
IMessageHandler<MessageJeweledPipeOptionsServer, IMessage> {
    public BlockPos position;
    byte index;
    boolean acceptUnsorted;
    boolean matchNBT;
    boolean matchMeta;

    public MessageJeweledPipeOptionsServer() {
    }

    public MessageJeweledPipeOptionsServer(BlockPos position, byte index, SideFilterData filterData) {
        this.position = position;
        this.index = index;
        this.acceptUnsorted = filterData.acceptsUnsortedItems();
        this.matchMeta = filterData.matchMetadata();
        this.matchNBT = filterData.matchNBT();
    }

    public void fromBytes(ByteBuf buf) {
        this.position = BlockPos.func_177969_a((long)buf.readLong());
        this.index = buf.readByte();
        this.acceptUnsorted = buf.readBoolean();
        this.matchNBT = buf.readBoolean();
        this.matchMeta = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.position.func_177986_g());
        buf.writeByte((int)this.index);
        buf.writeBoolean(this.acceptUnsorted);
        buf.writeBoolean(this.matchNBT);
        buf.writeBoolean(this.matchMeta);
    }

    public IMessage onMessage(MessageJeweledPipeOptionsServer message, MessageContext ctx) {
        World world = ctx.getServerHandler().field_147369_b.func_130014_f_();
        TileEntity te = world.func_175625_s(message.position);
        if (te instanceof TilePipeHolder) {
            PipeBehaviorJeweled pipe = (PipeBehaviorJeweled)((TilePipeHolder)te).getPipe().getBehaviour();
            SideFilterData dataToUpdate = pipe.filterData[message.index - 1];
            dataToUpdate.setAcceptUnsortedItems(message.acceptUnsorted);
            dataToUpdate.setMatchNBT(message.matchNBT);
            dataToUpdate.setMatchMetadata(message.matchMeta);
        }
        return null;
    }

    public String toString() {
        return "MessageJeweledPipeOptionsServer";
    }
}

