/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part.aspect;

import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartPosIteratorHandler;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.core.network.PartPosIteratorHandlerRoundRobin;
import org.cyclops.integratedtunnels.core.part.PartStateRoundRobin;
import org.cyclops.integratedtunnels.part.aspect.IChanneledTarget;

public abstract class ChanneledTarget<N extends IPositionedAddonsNetwork>
implements IChanneledTarget<N> {
    private final INetwork network;
    private final N channeledNetwork;
    private final PartStateRoundRobin<?> partState;
    private final int channel;
    private final boolean roundRobin;
    private final boolean craftIfFailed;

    public ChanneledTarget(INetwork network, N channeledNetwork, PartStateRoundRobin<?> partState, int channel, boolean roundRobin, boolean craftIfFailed) {
        this.network = network;
        this.channeledNetwork = channeledNetwork;
        this.partState = partState;
        this.channel = channel;
        this.roundRobin = roundRobin;
        this.craftIfFailed = craftIfFailed;
    }

    @Override
    public INetwork getNetwork() {
        return this.network;
    }

    @Override
    public N getChanneledNetwork() {
        return this.channeledNetwork;
    }

    @Override
    public PartStateRoundRobin<?> getPartState() {
        return this.partState;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public boolean isRoundRobin() {
        return this.roundRobin;
    }

    @Override
    public boolean isCraftIfFailed() {
        return this.craftIfFailed;
    }

    @Override
    public void preTransfer() {
        if (this.isRoundRobin()) {
            IPartPosIteratorHandler handler = this.getPartState().getPartPosIteratorHandler();
            if (handler == null) {
                handler = new PartPosIteratorHandlerRoundRobin();
            }
            this.getChanneledNetwork().setPartPosIteratorHandler(handler);
        }
    }

    @Override
    public void postTransfer() {
        IPartPosIteratorHandler handler;
        if (this.isRoundRobin() && (handler = this.getChanneledNetwork().getPartPosIteratorHandler()) != null) {
            this.getPartState().setPartPosIteratorHandler(handler);
            this.getChanneledNetwork().setPartPosIteratorHandler(null);
        }
    }
}

