/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.integratedtunnels.Capabilities;
import org.cyclops.integratedtunnels.api.network.IItemNetwork;
import org.cyclops.integratedtunnels.capability.network.ItemNetworkConfig;
import org.cyclops.integratedtunnels.core.part.PartTypeInterfacePositionedAddon;

public class PartTypeInterfaceItem
extends PartTypeInterfacePositionedAddon<IItemNetwork, IItemHandler, PartTypeInterfaceItem, State> {
    public PartTypeInterfaceItem(String name) {
        super(name);
    }

    @Override
    protected Capability<IItemNetwork> getNetworkCapability() {
        return ItemNetworkConfig.CAPABILITY;
    }

    @Override
    protected Capability<IItemHandler> getTargetCapability() {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    protected State constructDefaultState() {
        return new State();
    }

    public static class State
    extends PartTypeInterfacePositionedAddon.State<PartTypeInterfaceItem, IItemNetwork, IItemHandler>
    implements IItemHandler,
    ISlotlessItemHandler {
        @Override
        protected Capability<IItemHandler> getTargetCapability() {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        protected IItemHandler getItemHandler() {
            return (IItemHandler)((IItemNetwork)this.getPositionedAddonsNetwork()).getChannelExternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getChannel());
        }

        public int getSlots() {
            this.disablePosition();
            int ret = this.getPositionedAddonsNetwork() != null ? this.getItemHandler().getSlots() : 0;
            this.enablePosition();
            return ret;
        }

        public ItemStack getStackInSlot(int slot) {
            this.disablePosition();
            ItemStack ret = this.getPositionedAddonsNetwork() != null ? this.getItemHandler().getStackInSlot(slot) : ItemStack.field_190927_a;
            this.enablePosition();
            return ret;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            this.disablePosition();
            ItemStack ret = this.getPositionedAddonsNetwork() != null ? this.getItemHandler().insertItem(slot, stack, simulate) : stack;
            this.enablePosition();
            return ret;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            this.disablePosition();
            ItemStack ret = this.getPositionedAddonsNetwork() != null ? this.getItemHandler().extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
            this.enablePosition();
            return ret;
        }

        public int getSlotLimit(int slot) {
            this.disablePosition();
            int ret = this.getPositionedAddonsNetwork() != null ? this.getItemHandler().getSlotLimit(slot) : 0;
            this.enablePosition();
            return ret;
        }

        public Iterator<ItemStack> getItems() {
            this.disablePosition();
            UnmodifiableIterator ret = this.getPositionedAddonsNetwork() != null ? ((IItemNetwork)this.getPositionedAddonsNetwork()).getChannel(this.getChannelInterface()).iterator() : Iterators.forArray((Object[])new ItemStack[0]);
            this.enablePosition();
            return ret;
        }

        public Iterator<ItemStack> findItems(@Nonnull ItemStack stack, int matchFlags) {
            this.disablePosition();
            UnmodifiableIterator ret = this.getPositionedAddonsNetwork() != null ? ((IItemNetwork)this.getPositionedAddonsNetwork()).getChannel(this.getChannelInterface()).iterator((Object)stack, (Object)matchFlags) : Iterators.forArray((Object[])new ItemStack[0]);
            this.enablePosition();
            return ret;
        }

        public ItemStack insertItem(ItemStack stack, boolean simulate) {
            this.disablePosition();
            ItemStack ret = this.getPositionedAddonsNetwork() != null ? (ItemStack)((IItemNetwork)this.getPositionedAddonsNetwork()).getChannel(this.getChannelInterface()).insert((Object)stack, simulate) : stack;
            this.enablePosition();
            return ret;
        }

        public ItemStack extractItem(int amount, boolean simulate) {
            this.disablePosition();
            ItemStack ret = this.getPositionedAddonsNetwork() != null ? (ItemStack)((IItemNetwork)this.getPositionedAddonsNetwork()).getChannel(this.getChannelInterface()).extract((long)amount, simulate) : ItemStack.field_190927_a;
            this.enablePosition();
            return ret;
        }

        public ItemStack extractItem(ItemStack matchStack, int matchFlags, boolean simulate) {
            this.disablePosition();
            ItemStack ret = this.getPositionedAddonsNetwork() != null ? (ItemStack)((IItemNetwork)this.getPositionedAddonsNetwork()).getChannel(this.getChannelInterface()).extract((Object)matchStack, (Object)matchFlags, simulate) : ItemStack.field_190927_a;
            this.enablePosition();
            return ret;
        }

        public int getLimit() {
            this.disablePosition();
            int limit = 0;
            if (this.getPositionedAddonsNetwork() != null) {
                IItemHandler itemHandler = this.getItemHandler();
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    limit += itemHandler.getSlotLimit(i);
                }
            }
            this.enablePosition();
            return limit;
        }

        public boolean hasCapability(Capability<?> capability) {
            return this.getPositionedAddonsNetwork() != null && capability == Capabilities.SLOTLESS_ITEMHANDLER || super.hasCapability(capability);
        }

        public <T> T getCapability(Capability<T> capability) {
            if (this.getPositionedAddonsNetwork() != null && capability == Capabilities.SLOTLESS_ITEMHANDLER) {
                return (T)((Object)this);
            }
            return (T)super.getCapability(capability);
        }
    }
}

