/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part;

import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.EnergyHelpers;
import org.cyclops.integratedtunnels.Capabilities;
import org.cyclops.integratedtunnels.core.part.PartTypeInterfacePositionedAddon;

public class PartTypeInterfaceEnergy
extends PartTypeInterfacePositionedAddon<IEnergyNetwork, IEnergyStorage, PartTypeInterfaceEnergy, State> {
    public PartTypeInterfaceEnergy(String name) {
        super(name);
    }

    @Override
    protected Capability<IEnergyNetwork> getNetworkCapability() {
        return Capabilities.NETWORK_ENERGY;
    }

    @Override
    protected Capability<IEnergyStorage> getTargetCapability() {
        return CapabilityEnergy.ENERGY;
    }

    @Override
    protected IEnergyStorage getTargetCapabilityInstance(PartPos pos) {
        return EnergyHelpers.getEnergyStorage((PartPos)pos);
    }

    protected State constructDefaultState() {
        return new State();
    }

    public static class State
    extends PartTypeInterfacePositionedAddon.State<PartTypeInterfaceEnergy, IEnergyNetwork, IEnergyStorage>
    implements IEnergyStorage {
        @Override
        protected Capability<IEnergyStorage> getTargetCapability() {
            return CapabilityEnergy.ENERGY;
        }

        protected IEnergyStorage getEnergyStorage() {
            return (IEnergyStorage)((IEnergyNetwork)this.getPositionedAddonsNetwork()).getChannelExternal(CapabilityEnergy.ENERGY, this.getChannel());
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            this.disablePosition();
            int ret = this.getPositionedAddonsNetwork() != null ? this.getEnergyStorage().receiveEnergy(maxReceive, simulate) : 0;
            this.enablePosition();
            return ret;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            this.disablePosition();
            int ret = this.getPositionedAddonsNetwork() != null ? this.getEnergyStorage().extractEnergy(maxExtract, simulate) : 0;
            this.enablePosition();
            return ret;
        }

        public int getEnergyStored() {
            this.disablePosition();
            int ret = this.getPositionedAddonsNetwork() != null ? this.getEnergyStorage().getEnergyStored() : 0;
            this.enablePosition();
            return ret;
        }

        public int getMaxEnergyStored() {
            this.disablePosition();
            int ret = this.getPositionedAddonsNetwork() != null ? this.getEnergyStorage().getMaxEnergyStored() : 0;
            this.enablePosition();
            return ret;
        }

        public boolean canExtract() {
            this.disablePosition();
            boolean ret = this.getPositionedAddonsNetwork() != null && this.getEnergyStorage().canExtract();
            this.enablePosition();
            return ret;
        }

        public boolean canReceive() {
            this.disablePosition();
            boolean ret = this.getPositionedAddonsNetwork() != null && this.getEnergyStorage().canReceive();
            this.enablePosition();
            return ret;
        }
    }
}

