/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import org.cyclops.integratedtunnels.core.ExtendedFakePlayer;

public class PlayerHelpers {
    private static final Map<WorldServer, FakePlayer> FAKE_PLAYERS = new WeakHashMap<WorldServer, FakePlayer>();

    public static FakePlayer getFakePlayer(WorldServer world) {
        FakePlayer fakePlayer = FAKE_PLAYERS.get(world);
        if (fakePlayer == null) {
            fakePlayer = new ExtendedFakePlayer(world);
            FAKE_PLAYERS.put(world, fakePlayer);
        }
        return fakePlayer;
    }

    public static void setPlayerState(EntityPlayer player, EnumHand hand, BlockPos pos, EnumFacing side, boolean sneaking) {
        BlockPos playerPos = side == EnumFacing.UP || side == EnumFacing.DOWN ? pos.func_177967_a(side, 2) : pos;
        player.func_70107_b((double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p());
        player.field_70169_q = player.field_70165_t;
        player.field_70167_r = player.field_70163_u;
        player.field_70166_s = player.field_70161_v;
        player.field_70177_z = side.func_176734_d().func_185119_l();
        player.field_70125_A = side == EnumFacing.UP ? 90.0f : (side == EnumFacing.DOWN ? -90.0f : 0.0f);
        player.func_70095_a(sneaking);
        PlayerHelpers.setHeldItemSilent(player, hand, ItemStack.field_190927_a);
        player.func_70071_h_();
        player.field_70122_E = true;
    }

    public static void setHeldItemSilent(EntityPlayer player, EnumHand hand, ItemStack itemStack) {
        if (hand == EnumHand.MAIN_HAND) {
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)itemStack);
        } else if (hand == EnumHand.OFF_HAND) {
            player.field_71071_by.field_184439_c.set(0, (Object)itemStack);
        } else {
            player.func_184611_a(hand, itemStack);
        }
    }
}

