/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.tileentity;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.recipe.custom.api.IMachine;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeRegistry;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectableInventory;
import org.cyclops.integrateddynamics.network.MechanicalMachineNetworkElement;

public abstract class TileMechanicalMachine<RCK, M extends IMachine<M, I, O, P>, I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties>
extends TileCableConnectableInventory
implements IEnergyStorage,
SingleUseTank.IUpdateListener {
    private static int SLEEP_TIME = 40;
    @NBTPersist
    private int energy;
    @NBTPersist
    private int progress = -1;
    @NBTPersist
    private int sleep = -1;
    private SingleCache<RCK, IRecipe<I, O, P>> recipeCache;

    public TileMechanicalMachine(int inventorySize) {
        super(inventorySize, "machine", 64);
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(World world, BlockPos blockPos) {
                return new MechanicalMachineNetworkElement(DimPos.of((World)world, (BlockPos)blockPos));
            }
        });
        this.addCapabilityInternal(CapabilityEnergy.ENERGY, (Object)this);
        HashSet in = Sets.newHashSet((Object[])ArrayUtils.toObject((int[])this.getInputSlots()));
        HashSet out = Sets.newHashSet((Object[])ArrayUtils.toObject((int[])this.getOutputSlots()));
        this.addSlotsToSide(EnumFacing.UP, in);
        this.addSlotsToSide(EnumFacing.DOWN, out);
        this.addSlotsToSide(EnumFacing.NORTH, in);
        this.addSlotsToSide(EnumFacing.SOUTH, out);
        this.addSlotsToSide(EnumFacing.WEST, in);
        this.addSlotsToSide(EnumFacing.EAST, out);
        this.recipeCache = new SingleCache(this.createCacheUpdater());
    }

    protected abstract SingleCache.ICacheUpdater<RCK, IRecipe<I, O, P>> createCacheUpdater();

    public abstract int[] getInputSlots();

    public abstract int[] getOutputSlots();

    public abstract boolean wasWorking();

    public abstract void setWorking(boolean var1);

    public boolean hasWork() {
        return this.getCurrentRecipe() != null;
    }

    public boolean isWorking() {
        return this.progress >= 0 && this.sleep == -1;
    }

    public boolean canWork() {
        int rate = this.getEnergyConsumptionRate();
        return this.drainEnergy(rate, true) == rate && !this.field_145850_b.func_175640_z(this.func_174877_v());
    }

    public boolean isSleeping() {
        return this.sleep > 0;
    }

    public IEnergyNetwork getEnergyNetwork() {
        return NetworkHelpers.getEnergyNetwork(this.getNetwork());
    }

    public void onTankChanged() {
        this.sendUpdate();
        this.updateInventoryHash();
    }

    protected void onInventoryChanged() {
        super.onInventoryChanged();
        this.sleep = -1;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (ArrayUtils.contains((int[])this.getInputSlots(), (int)index)) {
            NonNullList inputStacks = NonNullList.func_191196_a();
            for (int slot : this.getInputSlots()) {
                if (slot == index) {
                    inputStacks.add((Object)stack);
                    continue;
                }
                inputStacks.add((Object)this.func_70301_a(slot));
            }
            return this.getRecipeRegistry().findRecipeByInput(this.getRecipeInput((NonNullList<ItemStack>)inputStacks)) != null;
        }
        return super.func_94041_b(index, stack);
    }

    protected abstract IRecipeRegistry<M, I, O, P> getRecipeRegistry();

    protected abstract RCK getCurrentRecipeCacheKey();

    public IRecipe<I, O, P> getCurrentRecipe() {
        return (IRecipe)this.recipeCache.get(this.getCurrentRecipeCacheKey());
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.getCurrentRecipe() != null ? this.getRecipeDuration(this.getCurrentRecipe()) : 0;
    }

    public abstract I getRecipeInput(NonNullList<ItemStack> var1);

    public abstract int getRecipeDuration(IRecipe<I, O, P> var1);

    protected abstract boolean finalizeRecipe(IRecipe<I, O, P> var1, boolean var2);

    @Override
    protected void updateTileEntity() {
        super.updateTileEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (this.isSleeping()) {
                --this.sleep;
                this.func_70296_d();
            } else if (this.canWork()) {
                IRecipe<I, O, P> recipe = this.getCurrentRecipe();
                if (recipe != null) {
                    if (this.progress == 0 && !this.finalizeRecipe(recipe, true)) {
                        this.sleep = SLEEP_TIME;
                    } else if (this.progress < this.getMaxProgress()) {
                        int toDrain = this.getEnergyConsumptionRate();
                        if (this.drainEnergy(toDrain, true) == toDrain) {
                            this.drainEnergy(toDrain, false);
                            ++this.progress;
                            this.sleep = -1;
                            this.sendUpdate();
                        } else {
                            this.sleep = 1;
                        }
                    } else if (this.finalizeRecipe(recipe, true)) {
                        this.progress = 0;
                        this.finalizeRecipe(recipe, false);
                    } else {
                        this.sleep = 40;
                    }
                } else {
                    this.progress = -1;
                    this.sleep = -1;
                }
            }
            this.updateWorkingState();
        }
    }

    public void updateWorkingState() {
        boolean wasWorking = this.wasWorking();
        boolean isWorking = this.isWorking();
        if (isWorking != wasWorking) {
            this.setWorking(isWorking);
        }
    }

    public abstract int getEnergyConsumptionRate();

    protected int drainEnergy(int amount, boolean simulate) {
        IEnergyNetwork energyNetwork;
        int toDrain = amount;
        if ((toDrain -= this.extractEnergyInternal(toDrain, simulate)) > 0 && (energyNetwork = this.getEnergyNetwork()) != null) {
            return (Integer)energyNetwork.getChannel(0).extract((long)toDrain, simulate);
        }
        return amount - toDrain;
    }

    protected int extractEnergyInternal(int energy, boolean simulate) {
        energy = Math.max(0, energy);
        int stored = this.getEnergyStored();
        int newEnergy = Math.max(stored - energy, 0);
        if (!simulate) {
            this.setEnergy(newEnergy);
        }
        return stored - newEnergy;
    }

    protected void setEnergy(int energy) {
        int lastEnergy = this.energy;
        if (lastEnergy != energy) {
            this.energy = energy;
            this.sendUpdate();
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int stored = this.getEnergyStored();
        int energyReceived = Math.min(this.getMaxEnergyStored() - stored, maxReceive);
        if (!simulate) {
            this.setEnergy(stored + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

