/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import java.beans.ConstructorProperties;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.cyclops.integrateddynamics.core.network.diagnostics.IRawData;

public class RawObserverData
implements IRawData {
    private final int dimension;
    private final BlockPos pos;
    private final EnumFacing side;
    private final String name;
    private final long last20TicksDurationNs;

    public String toString() {
        return String.format("%s: %s,%s,%s,%s (%s)", this.name, this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), this.side, this.dimension);
    }

    public NBTTagCompound toNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("dimension", this.dimension);
        tag.func_74772_a("pos", this.pos.func_177986_g());
        if (this.side != null) {
            tag.func_74768_a("side", this.side.ordinal());
        }
        tag.func_74778_a("name", this.name);
        tag.func_74772_a("last20TicksDurationNs", this.last20TicksDurationNs);
        return tag;
    }

    public static RawObserverData fromNbt(NBTTagCompound tag) {
        return new RawObserverData(tag.func_74762_e("dimension"), BlockPos.func_177969_a((long)tag.func_74763_f("pos")), tag.func_74764_b("side") ? EnumFacing.field_82609_l[tag.func_74762_e("side")] : null, tag.func_74779_i("name"), tag.func_74763_f("last20TicksDurationNs"));
    }

    @ConstructorProperties(value={"dimension", "pos", "side", "name", "last20TicksDurationNs"})
    public RawObserverData(int dimension, BlockPos pos, EnumFacing side, String name, long last20TicksDurationNs) {
        this.dimension = dimension;
        this.pos = pos;
        this.side = side;
        this.name = name;
        this.last20TicksDurationNs = last20TicksDurationNs;
    }

    public int getDimension() {
        return this.dimension;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public EnumFacing getSide() {
        return this.side;
    }

    public String getName() {
        return this.name;
    }

    public long getLast20TicksDurationNs() {
        return this.last20TicksDurationNs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawObserverData)) {
            return false;
        }
        RawObserverData other = (RawObserverData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDimension() != other.getDimension()) {
            return false;
        }
        BlockPos this$pos = this.getPos();
        BlockPos other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        EnumFacing this$side = this.getSide();
        EnumFacing other$side = other.getSide();
        if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        return this.getLast20TicksDurationNs() == other.getLast20TicksDurationNs();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawObserverData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDimension();
        BlockPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        EnumFacing $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : $side.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        long $last20TicksDurationNs = this.getLast20TicksDurationNs();
        result = result * 59 + (int)($last20TicksDurationNs >>> 32 ^ $last20TicksDurationNs);
        return result;
    }
}

