/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.ingredient.collection.IngredientHashMap;
import org.cyclops.integrateddynamics.api.network.IPartPosIteratorHandler;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.PartPosIteratorHandlerDummy;
import org.cyclops.integrateddynamics.core.network.PositionedAddonsNetworkIngredients;

public abstract class IngredientChannelAdapter<T, M>
implements IIngredientComponentStorage<T, M> {
    private final IPositionedAddonsNetworkIngredients<T, M> network;
    private final int channel;
    private boolean limitsEnabled;

    public IngredientChannelAdapter(PositionedAddonsNetworkIngredients<T, M> network, int channel) {
        this.network = network;
        this.channel = channel;
        this.limitsEnabled = true;
    }

    public void enableLimits() {
        this.limitsEnabled = true;
    }

    public void disableLimits() {
        this.limitsEnabled = false;
    }

    public IPositionedAddonsNetworkIngredients<T, M> getNetwork() {
        return this.network;
    }

    public int getChannel() {
        return this.channel;
    }

    public IngredientComponent<T, M> getComponent() {
        return this.network.getComponent();
    }

    protected abstract Iterator<PartPos> getNonFullPositions();

    protected abstract Iterator<PartPos> getAllPositions();

    protected abstract Iterator<PartPos> getNonEmptyPositions();

    protected abstract Iterator<PartPos> getMatchingPositions(@Nonnull T var1, M var2);

    public long getMaxQuantity() {
        long sum = 0L;
        Iterator<PartPos> it = this.getAllPositions();
        while (it.hasNext()) {
            PartPos pos = it.next();
            if (!pos.getPos().isLoaded()) continue;
            sum = Math.addExact(sum, this.network.getPositionedStorage(pos).getMaxQuantity());
        }
        return sum;
    }

    protected Pair<IPartPosIteratorHandler, Iterator<PartPos>> getPartPosIteratorData(Supplier<Iterator<PartPos>> iteratorSupplier, int channel) {
        IPartPosIteratorHandler handler = this.network.getPartPosIteratorHandler();
        handler = handler == null ? PartPosIteratorHandlerDummy.INSTANCE : handler.clone();
        return Pair.of((Object)handler, handler.handleIterator(iteratorSupplier, channel));
    }

    protected void savePartPosIteratorHandler(IPartPosIteratorHandler partPosIteratorHandler) {
        this.network.setPartPosIteratorHandler(partPosIteratorHandler);
    }

    public T insert(@Nonnull T ingredient, boolean simulate) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        if (matcher.isEmpty(ingredient)) {
            return ingredient;
        }
        long skippedQuantity = 0L;
        T ingredientOriginal = ingredient;
        if (this.limitsEnabled) {
            long limit = this.network.getRateLimit();
            long currentQuantity = matcher.getQuantity(ingredient);
            if (currentQuantity > limit) {
                ingredient = matcher.withQuantity(ingredient, limit);
                skippedQuantity = currentQuantity - limit;
            }
        }
        Pair<IPartPosIteratorHandler, Iterator<PartPos>> partPosIteratorData = this.getPartPosIteratorData(this::getNonFullPositions, this.channel);
        Iterator it = (Iterator)partPosIteratorData.getRight();
        while (it.hasNext()) {
            PartPos pos = (PartPos)it.next();
            if (!pos.getPos().isLoaded()) continue;
            this.network.disablePosition(pos);
            long quantityBefore = matcher.getQuantity(ingredient);
            ingredient = this.network.getPositionedStorage(pos).insert(ingredient, simulate);
            long quantityAfter = matcher.getQuantity(ingredient);
            this.network.enablePosition(pos);
            if (!simulate && quantityBefore != quantityAfter) {
                this.network.scheduleObservationForced(this.channel, pos);
            }
            if (!matcher.isEmpty(ingredient)) continue;
            break;
        }
        if (skippedQuantity > 0L) {
            ingredient = matcher.withQuantity(ingredientOriginal, skippedQuantity + matcher.getQuantity(ingredient));
        }
        if (!simulate) {
            this.savePartPosIteratorHandler((IPartPosIteratorHandler)partPosIteratorData.getLeft());
        }
        return ingredient;
    }

    public T extract(long maxQuantity, boolean simulate) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        if (this.limitsEnabled) {
            maxQuantity = (int)Math.min(maxQuantity, this.network.getRateLimit());
        }
        Pair<IPartPosIteratorHandler, Iterator<PartPos>> partPosIteratorData = this.getPartPosIteratorData(this::getNonEmptyPositions, this.channel);
        Iterator it = (Iterator)partPosIteratorData.getRight();
        while (it.hasNext()) {
            PartPos pos = (PartPos)it.next();
            if (!pos.getPos().isLoaded()) continue;
            this.network.disablePosition(pos);
            Object extracted = this.network.getPositionedStorage(pos).extract(maxQuantity, simulate);
            this.network.enablePosition(pos);
            if (matcher.isEmpty(extracted)) continue;
            if (!simulate) {
                this.network.scheduleObservationForced(this.channel, pos);
                this.savePartPosIteratorHandler((IPartPosIteratorHandler)partPosIteratorData.getLeft());
            }
            return (T)extracted;
        }
        if (!simulate) {
            this.savePartPosIteratorHandler((IPartPosIteratorHandler)partPosIteratorData.getLeft());
        }
        return (T)matcher.getEmptyInstance();
    }

    public T extract(@Nonnull T prototype, M matchFlags, boolean simulate) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        boolean checkQuantity = matcher.hasCondition(matchFlags, this.getComponent().getPrimaryQuantifier().getMatchCondition());
        if (this.limitsEnabled) {
            long limit = this.network.getRateLimit();
            if (matcher.getQuantity(prototype) > limit) {
                if (checkQuantity) {
                    return (T)matcher.getEmptyInstance();
                }
                prototype = matcher.withQuantity(prototype, limit);
            }
        }
        T prototypeFinal = prototype;
        long requiredQuantity = matcher.getQuantity(prototypeFinal);
        if (checkQuantity) {
            matchFlags = matcher.withoutCondition(matchFlags, this.getComponent().getPrimaryQuantifier().getMatchCondition());
        }
        M finalMatchFlags = matchFlags;
        IngredientHashMap validInstancesCollapsed = new IngredientHashMap(this.getComponent());
        Pair<IPartPosIteratorHandler, Iterator<PartPos>> partPosIteratorData = this.getPartPosIteratorData(() -> this.getMatchingPositions(prototypeFinal, finalMatchFlags), this.channel);
        Iterator it = (Iterator)partPosIteratorData.getRight();
        while (it.hasNext()) {
            PartPos pos = (PartPos)it.next();
            if (!pos.getPos().isLoaded()) continue;
            this.network.disablePosition(pos);
            Object extractedSimulated = this.network.getPositionedStorage(pos).extract(prototypeFinal, finalMatchFlags, true);
            this.network.enablePosition(pos);
            Object storagePrototype = this.getComponent().getMatcher().withQuantity(extractedSimulated, 1L);
            Pair existingValue = (Pair)validInstancesCollapsed.get(storagePrototype);
            if (existingValue == null) {
                existingValue = Pair.of((Object)new Wrapper((Object)0L), (Object)Lists.newLinkedList());
                validInstancesCollapsed.put(storagePrototype, (Object)existingValue);
            }
            long newCount = (Long)((Wrapper)existingValue.getLeft()).get() + matcher.getQuantity(extractedSimulated);
            ((Wrapper)existingValue.getLeft()).set((Object)newCount);
            ((List)existingValue.getRight()).add(pos);
            if (newCount < requiredQuantity) continue;
            if (!simulate) {
                this.savePartPosIteratorHandler((IPartPosIteratorHandler)partPosIteratorData.getLeft());
            }
            ((Wrapper)existingValue.getLeft()).set((Object)requiredQuantity);
            return (T)this.finalizeExtraction(storagePrototype, matchFlags, (Pair<Wrapper<Long>, List<PartPos>>)existingValue, simulate);
        }
        if (!simulate) {
            this.savePartPosIteratorHandler((IPartPosIteratorHandler)partPosIteratorData.getLeft());
        }
        if (checkQuantity) {
            return (T)matcher.getEmptyInstance();
        }
        Pair maxValue = Pair.of((Object)new Wrapper((Object)0L), (Object)Lists.newArrayList());
        Object maxInstance = matcher.getEmptyInstance();
        for (Map.Entry entry : validInstancesCollapsed) {
            if ((Long)((Wrapper)((Pair)entry.getValue()).getLeft()).get() <= (Long)((Wrapper)maxValue.getLeft()).get()) continue;
            maxInstance = entry.getKey();
            maxValue = (Pair)entry.getValue();
        }
        return (T)this.finalizeExtraction(maxInstance, matchFlags, (Pair<Wrapper<Long>, List<PartPos>>)maxValue, simulate);
    }

    @Deprecated
    protected boolean canExtract(T extractedSimulated) {
        return true;
    }

    protected T finalizeExtraction(T instancePrototype, M matchFlags, Pair<Wrapper<Long>, List<PartPos>> value, boolean simulate) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        long extractedCount = (Long)((Wrapper)value.getLeft()).get();
        if (!simulate && extractedCount > 0L) {
            long toExtract = extractedCount;
            for (PartPos pos : (List)value.getRight()) {
                instancePrototype = matcher.withQuantity(instancePrototype, toExtract);
                this.network.disablePosition(pos);
                Object extracted = this.network.getPositionedStorage(pos).extract(instancePrototype, matchFlags, false);
                this.network.enablePosition(pos);
                this.network.scheduleObservationForced(this.channel, pos);
                long thisExtractedAmount = matcher.getQuantity(extracted);
                toExtract -= thisExtractedAmount;
            }
            if (toExtract != 0L) {
                extractedCount -= toExtract;
            }
        }
        return (T)this.getComponent().getMatcher().withQuantity(instancePrototype, extractedCount);
    }
}

