/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.network.IEnergyConsumingNetworkElement;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.core.network.PositionedAddonsNetworkIngredients;

public class EnergyNetwork
extends PositionedAddonsNetworkIngredients<Integer, Boolean>
implements IEnergyNetwork {
    private INetwork network;

    public EnergyNetwork(IngredientComponent<Integer, Boolean> component) {
        super(component);
    }

    @Override
    public boolean canUpdate(INetworkElement element) {
        if (!(element instanceof IEnergyConsumingNetworkElement)) {
            return true;
        }
        int multiplier = GeneralConfig.energyConsumptionMultiplier;
        if (multiplier == 0) {
            return true;
        }
        int consumptionRate = ((IEnergyConsumingNetworkElement)element).getConsumptionRate() * multiplier;
        return (Integer)this.getChannel(element.getChannel()).extract((long)consumptionRate, true) == consumptionRate;
    }

    @Override
    public void onSkipUpdate(INetworkElement element) {
        if (element instanceof IEnergyConsumingNetworkElement) {
            ((IEnergyConsumingNetworkElement)element).postUpdate(this.getNetwork(), false);
        }
    }

    @Override
    public void postUpdate(INetworkElement element) {
        if (element instanceof IEnergyConsumingNetworkElement) {
            int multiplier = GeneralConfig.energyConsumptionMultiplier;
            if (multiplier > 0) {
                int consumptionRate = ((IEnergyConsumingNetworkElement)element).getConsumptionRate() * multiplier;
                this.getChannel(element.getChannel()).extract((long)consumptionRate, false);
            }
            ((IEnergyConsumingNetworkElement)element).postUpdate(this.getNetwork(), true);
        }
    }

    @Override
    public int getConsumptionRate() {
        int multiplier = GeneralConfig.energyConsumptionMultiplier;
        if (multiplier == 0) {
            return 0;
        }
        int consumption = 0;
        for (INetworkElement element : this.getNetwork().getElements()) {
            consumption += ((IEnergyConsumingNetworkElement)element).getConsumptionRate() * multiplier;
        }
        return consumption;
    }

    @Override
    public long getRateLimit() {
        return GeneralConfig.energyRateLimit;
    }

    @Override
    public INetwork getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(INetwork network) {
        this.network = network;
    }
}

